/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

function setElementDisabled(elements, disable)
{
  if ((elements != null) && (elements[0] != null))
  {
    elements[0].disabled = disable;
    elements[0].readOnly = disable;
  }
}

function executeAdapterOnLoad(prefix)
{
  //NOTE: prefix here will normally look like:
  //
  //  settings.en0
  //
  //However, under more exotic HxPx environments, the prefix could look like:
  //
  //  root.content.TcpIpPlatformServicePlugin.TcpIpService.settings.en0
  //
  //The host level settings like "usesAdapterLevelSettings" and "dnsHosts" will require that
  //we strip off the adapter context ("en0" above) in order to find the fields - don't use the hardcoded
  //'settings' prefix (NCCB-34651). Strip off everything after the last '.' to determine the 'host' level prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var usesAdapterLevelSettings = (document.getElementsByName(hostLevelPrefix + ".usesAdapterLevelSettings.hidden")[0].value === "true");
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterEnabled           = (document.getElementsByName(prefix + ".adapterEnabled.hidden")[0].value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");
  var canDisableAdapter        = (document.getElementsByName(prefix + ".canDisableAdapter.hidden")[0].value === "true");

  //ipv4 support
  var canUseDhcp               = (document.getElementsByName(prefix + ".canUseDhcp.hidden")[0].value === "true");
  var dhcpEnabled              = (document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value === "true");

  //ipv6 support
  var ipv6Supported            = (document.getElementsByName(prefix + ".ipv6Supported.hidden")[0].value === "true");
  var canDisableIpv6           = (document.getElementsByName(prefix + ".canDisableIpv6.hidden")[0].value === "true");
  var ipv6Enabled              = (document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value === "true");
  var ipv6Readonly             = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value === "true");
  var canUseIpv6Dhcp           = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value === "true");
  var ipv6DhcpEnabled          = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value === "true");

  //dhcpdv4 support
  var canUseDhcpdv4            = (document.getElementsByName(prefix + ".canUseDhcpdv4.hidden")[0].value === "true");
  var dhcpdv4Readonly          = (document.getElementsByName(prefix + ".dhcpdv4Readonly.hidden")[0].value === "true");
  var dhcpdv4Enabled           = (document.getElementsByName(prefix + ".dhcpdv4Enabled.hidden")[0].value === "true");

  //generic settings
  setElementDisabled(document.getElementsByName(prefix + ".adapterEnabled.value"),          (adapterReadonly || !canDisableAdapter || !operatorCanWrite));

  //ipv4 support
  setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),               (adapterReadonly || !adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"),              (adapterReadonly || !adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".dhcpEnabled.value"),             !(!adapterReadonly && adapterEnabled && canUseDhcp  &&  operatorCanWrite && !dhcpdv4Enabled));

  if (usesAdapterLevelSettings)
  {
    setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),               (adapterReadonly || !adapterEnabled || dhcpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),              (adapterReadonly || !adapterEnabled || dhcpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".domain.value"),                (adapterReadonly || !adapterEnabled || dhcpEnabled || !operatorCanWrite));
  }
  else
  {
    //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
    //knows if its current configuration would disable the host level fields - it does
    //not know about how other adapters may influence the state of those fields. We would
    //not want to enable the fields if they were disabled by the settings of one of our peer
    //adapters.
    //
    //Also, since this is executeOnLoad(), it will be called for either adapter - we don't want to
    //clear to disabled state set by an adapter called before us. This means we only want to set the
    //fields disabled if we know we are the ones responsible for it being disabled - never to enable it

    if (((adapterEnabled && dhcpEnabled) || !operatorCanWrite))
    {
      //Settings should be disabled
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".domain.value"),                 true);
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".gateway.value"),                true);
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".dnsHosts.value"),               true);
    }
  }

  if (ipv6Supported)
  {
    //ipv6 support
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Enabled.value"),             (adapterReadonly || !adapterEnabled || !operatorCanWrite || ipv6Readonly || !canDisableIpv6));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (adapterReadonly || !adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (adapterReadonly || !adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(!adapterReadonly && adapterEnabled && ipv6Enabled  && canUseIpv6Dhcp  && operatorCanWrite && !ipv6Readonly));

    //Unclear at this time if AutoConfiguration of IPv6 automatically sets host level values (IPv6 Gateway, DNSv6)
    //Do not let it's value influence the readonly state of these editors
    ipv6DhcpEnabled = false;

    if (usesAdapterLevelSettings)
    {
      setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),           (adapterReadonly || !adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
      setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),          (adapterReadonly || !adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
    }
    else
    {
      //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
      //knows if its current configuration would disable the host level fields - it does
      //not know about how other adapters may influence the state of those fields. We would
      //not want to enable the fields if they were disabled by the settings of one of our peer
      //adapters.
      //
      //Also, since this is executeOnLoad(), it will be called for either adapter - we don't want to
      //clear to disabled state set by an adapter called before us. This means we only want to set the
      //fields disabled if we know we are the ones responsible for it being disabled - never to enable it
      if (((adapterEnabled && ipv6Enabled && ipv6DhcpEnabled) || !operatorCanWrite || ipv6Readonly))
      {
        //Settings should be disabled
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),            true);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),           true);
      }
    }
  }

  //dhcpdv4 support
  if (canUseDhcpdv4)
  {
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Enabled.value"),            (adapterReadonly || !adapterEnabled || dhcpEnabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.bigHour"), (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.min"),     (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sec"),     (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sign"),    (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.bigHour"),     (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.min"),         (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sec"),         (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sign"),        (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Subnet.value"),             (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Netmask.value"),            (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4ClientRangeLow.value"),     (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxClients.value"),         (adapterReadonly || !adapterEnabled || dhcpEnabled || !dhcpdv4Enabled || dhcpdv4Readonly));
  }
}

function onDhcpEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].dhcpEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var usesAdapterLevelSettings = (document.getElementsByName(hostLevelPrefix + ".usesAdapterLevelSettings.hidden")[0].value === "true");

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var dhcpEnabled              = (element.value === "true");

  //dhcpdv4 support
  var canUseDhcpdv4            = (document.getElementsByName(prefix + ".canUseDhcpdv4.hidden")[0].value === "true");
  var dhcpdv4Readonly          = (document.getElementsByName(prefix + ".dhcpdv4Readonly.hidden")[0].value === "true");
  var dhcpdv4Enabled           = (document.getElementsByName(prefix + ".dhcpdv4Enabled.hidden")[0].value === "true");

  if (operatorCanWrite && !adapterReadonly)
  {
    document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),  dhcpEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"), dhcpEnabled);

    if (usesAdapterLevelSettings)
    {
      setElementDisabled(document.getElementsByName(prefix + ".domain.value"),     dhcpEnabled);
      setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),    dhcpEnabled);
      setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),   dhcpEnabled);
    }
    else
    {
      //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
      //knows if its current configuration would disable the host level fields - it does
      //not know about how other adapters may influence the state of those fields. We would
      //not want to enable the fields if they were disabled by the settings of one of our peer
      //adapters.
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".domain.value"),     dhcpEnabled);
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".gateway.value"),    dhcpEnabled);
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".dnsHosts.value"),   dhcpEnabled);
    }

    if (canUseDhcpdv4 && !dhcpdv4Readonly)
    {
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Enabled.value"),            dhcpEnabled);
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.bigHour"), (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.min"),     (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sec"),     (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sign"),    (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.bigHour"),     (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.min"),         (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sec"),         (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sign"),        (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Subnet.value"),             (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Netmask.value"),            (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4ClientRangeLow.value"),     (dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxClients.value"),         (dhcpEnabled || !dhcpdv4Enabled));
    }
  }
}

function onIpv6DhcpEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].ipv6DhcpEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  //var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  //var usesAdapterLevelSettings = (document.getElementsByName(hostLevelPrefix + ".usesAdapterLevelSettings.hidden")[0].value === "true");

  var operatorCanWrite = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly  = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var ipv6DhcpEnabled  = (element.value === "true");
  var ipv6Readonly     = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value === "true");

  if (operatorCanWrite && !adapterReadonly && !ipv6Readonly)
  {
    document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),            ipv6DhcpEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"), ipv6DhcpEnabled);

    /*Unclear at this time if AutoConfiguration of IPv6 automatically sets host level values (IPv6 Gateway, DNSv6)
    if (usesAdapterLevelSettings)
    {
      setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),          ipv6DhcpEnabled);
      setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),         ipv6DhcpEnabled);
    }
    else
    {
      //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
      //knows if its current configuration would disable the host level fields - it does
      //not know about how other adapters may influence the state of those fields. We would
      //not want to enable the fields if they were disabled by the settings of one of our peer
      //adapters.
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),           ipv6DhcpEnabled);
      setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),          ipv6DhcpEnabled);
    }
    */
  }
}

//noinspection JSUnusedGlobalSymbols
function onAdapterEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].adapterEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var usesAdapterLevelSettings = (document.getElementsByName(hostLevelPrefix + ".usesAdapterLevelSettings.hidden")[0].value === "true");

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterEnabled           = (element.value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  //ipv4 support
  var canUseDhcp               = (document.getElementsByName(prefix + ".canUseDhcp.hidden")[0].value === "true");
  var dhcpEnabled              = (document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value === "true");

  //ipv6 support
  var ipv6Supported            = (document.getElementsByName(prefix + ".ipv6Supported.hidden")[0].value === "true");
  var canDisableIpv6           = (document.getElementsByName(prefix + ".canDisableIpv6.hidden")[0].value === "true");
  var ipv6Enabled              = (document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value === "true");
  var ipv6Readonly             = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value === "true");
  var canUseIpv6Dhcp           = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value === "true");
  var ipv6DhcpEnabled          = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value === "true");

  //dhcpdv4 support
  var canUseDhcpdv4            = (document.getElementsByName(prefix + ".canUseDhcpdv4.hidden")[0].value === "true");
  var dhcpdv4Readonly          = (document.getElementsByName(prefix + ".dhcpdv4Readonly.hidden")[0].value === "true");
  var dhcpdv4Enabled           = (document.getElementsByName(prefix + ".dhcpdv4Enabled.hidden")[0].value === "true");

  if (operatorCanWrite && !adapterReadonly)
  {
    document.getElementsByName(prefix + ".adapterEnabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),               (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"),              (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpEnabled.value"),             !(adapterEnabled && canUseDhcp && !dhcpdv4Enabled));

    if (usesAdapterLevelSettings)
    {
      setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),                 (!adapterEnabled || dhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),                (!adapterEnabled || dhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".domain.value"),                  (!adapterEnabled || dhcpEnabled));
    }
    else
    {
      //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
      //knows if its current configuration would disable the host level fields - it does
      //not know about how other adapters may influence the state of those fields. We would
      //not want to enable the fields if they were disabled by the settings of one of our peer
      //adapters.
      if (adapterEnabled && dhcpEnabled)
      {
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".domain.value"),                   true);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".gateway.value"),                  true);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".dnsHosts.value"),                 true);
      }
      else if (!adapterEnabled && dhcpEnabled)
      {
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".domain.value"),                   false);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".gateway.value"),                  false);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".dnsHosts.value"),                 false);
      }
      //Else we don't know enough about the state of the host to alter settings
    }

    if (ipv6Supported && !ipv6Readonly)
    {
      setElementDisabled(document.getElementsByName(prefix + ".ipv6Enabled.value"),             (!adapterEnabled || !canDisableIpv6));
      setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(adapterEnabled && canUseIpv6Dhcp && ipv6Enabled));

      //Unclear at this time if AutoConfiguration of IPv6 automatically sets host level values (IPv6 Gateway, DNSv6)
      //Do not let it's value influence the readonly state of these editors
      ipv6DhcpEnabled = false;

      if (usesAdapterLevelSettings)
      {
        setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled));
        setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),            (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled));
      }
      else
      {
        //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
        //knows if its current configuration would disable the host level fields - it does
        //not know about how other adapters may influence the state of those fields. We would
        //not want to enable the fields if they were disabled by the settings of one of our peer
        //adapters.
        if (adapterEnabled && ipv6Enabled && ipv6DhcpEnabled)
        {
          setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),             true);
          setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),            true);
        }
        else if (!adapterEnabled && ipv6Enabled && ipv6DhcpEnabled)
        {
          setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),             false);
          setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),            false);
        }
        //Else we don't know enough about the state of the host to alter settings
      }
    }

    //dhcpdv4 support
    if (canUseDhcpdv4 && !dhcpdv4Readonly)
    {
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Enabled.value"),            (!adapterEnabled || dhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.bigHour"), (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.min"),     (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sec"),     (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sign"),    (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.bigHour"),     (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.min"),         (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sec"),         (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sign"),        (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Subnet.value"),             (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Netmask.value"),            (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4ClientRangeLow.value"),     (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
      setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxClients.value"),         (!adapterEnabled || dhcpEnabled || !dhcpdv4Enabled));
    }
  }
}

function onIpv6EnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].ipv6Enabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var usesAdapterLevelSettings = (document.getElementsByName(hostLevelPrefix + ".usesAdapterLevelSettings.hidden")[0].value === "true");

  var ipv6Enabled     = (element.value === "true");
  var canUseIpv6Dhcp  = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value === "true");
  var ipv6DhcpEnabled = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value === "true");
  var ipv6Readonly    = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value === "true");

  if (operatorCanWrite && !adapterReadonly && !ipv6Readonly)
  {
    document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (!ipv6Enabled || ipv6DhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (!ipv6Enabled || ipv6DhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(ipv6Enabled && canUseIpv6Dhcp));

    //Unclear at this time if AutoConfiguration of IPv6 automatically sets host level values (IPv6 Gateway, DNSv6)
    //Do not let it's value influence the readonly state of these editors
    ipv6DhcpEnabled = false;

    if (usesAdapterLevelSettings)
    {
      setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),             (!ipv6Enabled || ipv6DhcpEnabled));
      setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),            (!ipv6Enabled || ipv6DhcpEnabled));
    }
    else
    {
      //NOTE: Setting host levels via the adapter is dangerous, this adapter really only
      //knows if its current configuration would disable the host level fields - it does
      //not know about how other adapters may influence the state of those fields. We would
      //not want to enable the fields if they were disabled by the settings of one of our peer
      //adapters.
      if (ipv6Enabled && ipv6DhcpEnabled)
      {
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),             true);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),            true);
      }
      else if (!ipv6Enabled && ipv6DhcpEnabled)
      {
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6Gateway.value"),             false);
        setElementDisabled(document.getElementsByName(hostLevelPrefix + ".ipv6DnsHosts.value"),            false);
      }
      //Else we don't know enough about the host settings to change the state of the editors
    }
  }
}

function onDhcpdv4EnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].dhcpdv4Enabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  //var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var dhcpdv4Enabled   = (element.value === "true");
  var canUseDhcpdv4    = (document.getElementsByName(prefix + ".canUseDhcpdv4.hidden")[0].value === "true");
  var dhcpdv4Readonly  = (document.getElementsByName(prefix + ".dhcpdv4Readonly.hidden")[0].value === "true");

  if (operatorCanWrite && !adapterReadonly && canUseDhcpdv4 && !dhcpdv4Readonly)
  {
    document.getElementsByName(prefix + ".dhcpdv4Enabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.bigHour"), !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.min"),     !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sec"),     !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4DefaultLeaseTime.sign"),    !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.bigHour"),     !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.min"),         !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sec"),         !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxLeaseTime.sign"),        !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Subnet.value"),             !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4Netmask.value"),            !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4ClientRangeLow.value"),     !dhcpdv4Enabled);
    setElementDisabled(document.getElementsByName(prefix + ".dhcpdv4MaxClients.value"),         !dhcpdv4Enabled);

    //Also disable DHCP client
    setElementDisabled(document.getElementsByName(prefix + ".dhcpEnabled.value"),               dhcpdv4Enabled);
  }
}

