/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

var restartFieldDirty = false;
var rebootFieldDirty = false;
   
function setElementDisabled(elements, disable)
{
  if ((elements != null) && (elements[0] != null))
  {
    elements[0].disabled = disable;
  }
}
   
function onSystemPlatformServiceSave(scope, restartMessage, rebootMessage)
{
  if (rebootFieldDirty)
  {
    if (!window.confirm(rebootMessage))
    {
      return;
    }
  }
  else if (restartFieldDirty)
  {
    if (!window.confirm(restartMessage))
    {
      return;
    }
  }

  //Variable is defined outside the scope of this function, will be valid
  //when loaded with parent HxOp
  // noinspection JSUnresolvedVariable
  hx.save();
}

function unscope(path, levels)
{
  var result = path;
  for (var i = 0; i < levels; i++)
  {
    if (result)
    {
      result = result.substring(0, result.lastIndexOf("."));
    }
    else
    {
      return;
    }
  }
  return result;
}

function scope(path, name)
{
  return (path) ? path + "." + name : name;
}

function eventPath(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;
  return element.name;
}

function onLocaleChanged(event)
{
  var restartEnabledName = scope(unscope(eventPath(event), 2), "restartEnabled");
  var systemRestartName = scope(unscope(eventPath(event), 2), "systemRestart");
  var systemRebootName = scope(unscope(eventPath(event), 2), "systemReboot");
  
  if (document.getElementsByName(restartEnabledName)[0].value === "true")
  {
    document.getElementsByName(systemRestartName)[0].value = "true";
    restartFieldDirty = true;
  }
  else
  {
    document.getElementsByName(systemRebootName)[0].value = "true";
    rebootFieldDirty = true;
  }
}

function onTimeZoneChanged(event)
{
  var restartEnabledName = scope(unscope(eventPath(event), 2), "restartEnabled");
  var systemRestartName = scope(unscope(eventPath(event), 2), "systemRestart");
  var systemRebootName = scope(unscope(eventPath(event), 2), "systemReboot");

  if (document.getElementsByName(restartEnabledName)[0].value === "true")
  {
    document.getElementsByName(systemRestartName)[0].value = "true";
    restartFieldDirty = true;
  }
  else
  {
    document.getElementsByName(systemRebootName)[0].value = "true";
    rebootFieldDirty = true;
  }
}
 
function onEnableStationAutoSaveChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;
  var isStationAutoSaveEnabled = (element.value === "true");
  
  setElementDisabled(document.getElementsByName("stationSaveBackupCount.value"), !isStationAutoSaveEnabled);   
  setElementDisabled(document.getElementsByName("stationAutoSaveFrequency.bigHour"), !isStationAutoSaveEnabled);
  setElementDisabled(document.getElementsByName("stationAutoSaveFrequency.min"), !isStationAutoSaveEnabled);
}
 
function executeOnload(prefix)
{
  var isStationAutoSaveEnabled = (document.getElementsByName("isStationAutoSaveEnabled")[0].value === "true");
  
  //issue 13824, prevent unprivileged users from modifying platform values
  var canOperatorWrite = (document.getElementsByName("operatorCanWrite")[0].value === "true");
  
  setElementDisabled(document.getElementsByName("stationSaveBackupCount.value"),     !(canOperatorWrite && isStationAutoSaveEnabled));
  setElementDisabled(document.getElementsByName("stationAutoSaveFrequency.bigHour"), !(canOperatorWrite && isStationAutoSaveEnabled));
  setElementDisabled(document.getElementsByName("stationAutoSaveFrequency.min"),     !(canOperatorWrite && isStationAutoSaveEnabled));
}
