function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/lonworks/rc/fe/DomainIdEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/lonworks/rc/baja/DomainId', 'nmodule/webEditors/rc/util/byteUtils', 'lex!lonworks', 'css!nmodule/lonworks/rc/lonworks'], function (baja, $, Promise, Widget, events, fe, BaseEditor, htmlUtils, OrderedMapEditor, DomainId, byteUtils, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    lonworksLex = _lexs[0];
  var lengthLabel = lonworksLex.getSafe('DomainIdFE.length'),
    idLabel = lonworksLex.getSafe('DomainIdFE.id');
  var escapeHtml = htmlUtils.escapeHtml,
    radix = 16;
  var domainIdEditorHtml = function domainIdEditorHtml() {
    return "\n   <span class='domainIdLength-label' style=\"padding-right:0.2em;\"><label>".concat(lengthLabel, "</label></span>\n   <span class='domainIdLength'></span>\n   <span class='domainIdValue-label'\n    style=\"visibility:hidden;padding-left\":1em\"><label>").concat(idLabel, "</label></span>\n   <span class='domainIdValue' style=\"visibility:hidden\"></span>\n  ");
  };

  /**
   * Baja UX field editor for lonworks Domain Id.
   * Has an editor for Domain Id length and Domain Id value
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/lonworks/rc/fe/DomainIdEditor
   */
  var DomainIdEditor = /*#__PURE__*/function (_BaseEditor) {
    function DomainIdEditor() {
      _classCallCheck(this, DomainIdEditor);
      return _callSuper(this, DomainIdEditor, arguments);
    }
    _inherits(DomainIdEditor, _BaseEditor);
    return _createClass(DomainIdEditor, [{
      key: "doInitialize",
      value:
      /**
       * Creates a length editor with value 0 as default.
       * On change function makes Domain Id String editor visible if the length of
       * the Domain Id is greater than 0.
       * Each time the value of Domain Id length changes the Domain Id string editor
       * get initialized to a string of zeros based on the length selected.
       * Width of the string editor also changes based on length.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.addClass('DomainIdEditor');
        dom.html(domainIdEditorHtml());
        dom.on(events.MODIFY_EVENT, '.domainIdLength', function (e, ed) {
          ed.read().then(function (len) {
            var length = parseInt(len);
            var idElement = _this.$getIdElement();
            if (length !== 0) {
              _this.$styleIdEditor(idElement, length);
              return _this.$getIdEditor().load(byteUtils.byteArrayToString([0, 0, 0, 0, 0, 0], " ", length, radix));
            } else {
              $('.domainIdValue-label').css("visibility", "hidden");
              idElement.css("visibility", "hidden");
            }
          })["catch"](function (err) {
            baja.error(err);
            throw err;
          });
        });
        dom.on(events.MODIFY_EVENT, '.domainIdValue', function () {
          _this.setModified(true);
          return false;
        });
        var domainIdEditors = [fe.buildFor({
          dom: this.$getLengthElement(),
          value: this.$getLengthPatternMap(),
          loadParams: {
            selectedValue: "0"
          },
          type: OrderedMapEditor
        }), fe.buildFor({
          dom: this.$getIdElement(),
          value: "",
          formFactor: 'mini'
        })];
        return Promise.all(domainIdEditors);
      }

      /**
       * Loads the Domain Id Length editor and makes the Domain Id string editor
       * visible only if the length editor has a value other than 0.
       * Byte array entered by the user is converted to string.
       *
       * @param domainId
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(domainId) {
        var len = domainId.getDomainIdLength(),
          promiseList = [];
        var domainLengthFE = this.$getLengthEditor().setSelectedValue(len.toString(), true);
        promiseList.push(domainLengthFE);
        var idElement = this.$getIdElement();
        if (len !== 0) {
          this.$styleIdEditor(idElement, len);
          promiseList.push(this.$getIdEditor().load(byteUtils.byteArrayToString(domainId.getDomainId(), ' ', len, radix)));
        } else {
          idElement.css("visibility", "hidden");
        }
        return Promise.all(promiseList);
      }

      /**
       * Reads the value of the Domain Id length and string editors.
       *
       *  @returns module:nmodule/lonworks/rc/baja/DomainId
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getLengthEditor().read(), this.$getIdEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            len = _ref2[0],
            id = _ref2[1];
          var length = parseInt(len);
          var byteId = byteUtils.stringToByteArray(id, length);
          return DomainId.make(length, byteId);
        });
      }

      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Returns the OrderedMap of Domain Id length to be loaded in to the Domain Id
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "$getLengthPatternMap",
      value: function $getLengthPatternMap() {
        var map = new baja.OrderedMap();
        map.put(escapeHtml("0"), "0");
        map.put(escapeHtml("1"), "1");
        map.put(escapeHtml("3"), "3");
        map.put(escapeHtml("6"), "6");
        return map;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLengthEditor",
      value: function $getLengthEditor() {
        return Widget["in"](this.$getLengthElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLengthElement",
      value: function $getLengthElement() {
        return this.jq().find('.domainIdLength');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getIdEditor",
      value: function $getIdEditor() {
        return Widget["in"](this.$getIdElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getIdElement",
      value: function $getIdElement() {
        return this.jq().find('.domainIdValue');
      }

      /**
       * Function is used to make the Domain Id Label and Id editor visible and change
       * the width of the Id editor as per the length in the Domain Id Length editor
       *
       * @param {JQuery} idElement - Domain Id element
       * @param {number } length - Domain Id Length
       */
    }, {
      key: "$styleIdEditor",
      value: function $styleIdEditor(idElement, length) {
        this.jq().find('.domainIdValue-label').css("visibility", "visible");
        idElement.css("visibility", "visible");
        idElement.find("input").css("width", getWidth(length));
      }
    }]);
  }(BaseEditor);
  /**
   * Function gets the width of the Domain Id string editor based on the length
   * of the Domain Id length
   * @param length
   * @returns {string}
   */
  function getWidth(length) {
    switch (length) {
      case 1:
        return "4em";
      case 3:
        return "7em";
      case 6:
        return "13em";
      default:
        return "6em";
    }
  }
  return DomainIdEditor;
});
