function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/baja/DomainId
 */
define(['baja!', 'lex!lonworks', 'nmodule/webEditors/rc/util/byteUtils'], function (baja, lexs, byteUtils) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    lonworksLex = _lexs[0];

  /**
   * A javascript based implementation of lonworks:DomainId
   *
   * @class
   * @alias module:nmodule/lonworks/rc/baja/DomainId
   * @extends baja.Simple
   */
  var DomainId = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructs a DomainId with the given byte array of the specified length.
     *
     * @param {number} len - The length of the domain Id.It can take a value of 0,1,3 and 6.NaN, +inf, -inf are invalid values.
     * @param {Array.<number>} id - The domain id value
     */
    function DomainId(len, id) {
      var _this;
      _classCallCheck(this, DomainId);
      _this = _callSuper(this, DomainId);
      if (!isValidLength(len)) {
        throw new Error(lonworksLex.get('domainId.length.error', len));
      }
      if (isInvalidDomainId(id)) {
        throw new Error(lonworksLex.get('domainId.id.error', id));
      }
      _this.$domainLength = len;
      //copying id to domainId
      _this.$domainId = id.slice(0, len);
      return _this;
    }

    /**
     * Make a domainId with passed length and Id
     *
     * @example
     * //creates a domain ID with specified length as 3 and domain Id value
     * let domainId=DomainId.make(3,[10,28,110]);
     *
     * @example
     * //creates a domain ID with specified len as 6 and domain Id value
     * let domainId=DomainId.make(6,[10,28,110,78,90,23]);
     *
     * @param {number} len
     * @param {Array.<number>} id
     * @returns {module:nmodule/lonworks/rc/baja/DomainId}
     */
    _inherits(DomainId, _baja$Simple);
    return _createClass(DomainId, [{
      key: "make",
      value:
      /**
       * Make a domainId with passed length and Id
       *
       * @param {number} len
       * @param {Array.<number>} id
       * @returns {module:nmodule/lonworks/rc/baja/DomainId}
       */
      function make(len, id) {
        return new DomainId(len, id);
      }

      /**
       * Encodes the domainId length and id value to string with
       * len=domainIdlength:id
       *
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return "len=" + this.$domainLength + ":" + byteUtils.byteArrayToString(this.$domainId, '.', this.$domainLength, 16);
      }

      /**
       * Converts a string value into a domainId tuple. Throws an error if the string is not in the valid format.
       *
       * @param {string} string
       * @returns {module:nmodule/lonworks/rc/baja/DomainId}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        if (string.length === 0) {
          return DomainId.DEFAULT;
        }
        var slen = string.substring(string.indexOf('=') + 1, string.indexOf(':')).trim();
        var len = parseInt(slen);
        if (len === 0) {
          return DomainId.DEFAULT;
        }
        if (!isValidLength(len)) {
          throw new Error(lonworksLex.get('domainId.length.error', len));
        }
        var id = string.substring(string.indexOf(':') + 1);
        var domId = byteUtils.stringToByteArray(id, len);
        return new DomainId(len, domId);
      }

      /**
       * Get the length of the domain Id
       *
       * @returns {number}
       */
    }, {
      key: "getDomainIdLength",
      value: function getDomainIdLength() {
        return this.$domainLength;
      }

      /**
       * Get the byte array of the domain Id value
       *
       * @returns {Array.<number>|null}
       */
    }, {
      key: "getDomainId",
      value: function getDomainId() {
        return this.$domainId.slice();
      }
    }], [{
      key: "make",
      value: function make(len, id) {
        return new DomainId(len, id);
      }
    }]);
  }(baja.Simple);
  DomainId.DEFAULT = new DomainId(0, []);

  /**
   * Function to check if the domain id length is valid. Only acceptable values are 0,1,3 and 6
   * @param len
   * @returns {boolean}
   */
  function isValidLength(len) {
    switch (len) {
      case 0:
      case 1:
      case 3:
      case 6:
        return true;
    }
    return false;
  }

  /**
   * Function checks if the domain Id is invalid. Negative infinity, NaN and Positive infinity are not valid.
   * @param id
   * @returns {boolean}
   */
  function isInvalidDomainId(id) {
    for (var i = 0; i < id.length; i++) {
      if (!isFinite(id[i])) {
        return true;
      }
    }
    return false;
  }
  return DomainId;
});
