function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/Bargraph
 */
define(['baja!', 'baja!bajaui:Orientation', 'lex!kitPx', 'bajaux/spandrel', 'underscore', 'nmodule/bajaui/rc/baja/Border', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Font', 'css!nmodule/kitPx/rc/kitPx'], function (baja, types, lexs, spandrel, _, Border, Brush, Font) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    kitPxLex = _lexs[0];
  var range = _.range;
  var MIN_AUTO_TICKS = 4;
  var MAX_AUTO_TICKS = 10;
  var LOG10E = 0.4342944819018;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Bargraph',
        background: Brush.DEFAULT,
        fill: Brush.make('#666699'),
        foreground: Brush.make('black'),
        max: 100,
        min: 0,
        orientation: baja.$('bajaui:Orientation', 'vertical'),
        scale: 10,
        scaleFont: Font.NULL,
        scaleVisible: true,
        text: '',
        value: 0,
        valueFont: Font.NULL,
        valueVisible: true
      }
    };
  };

  /**
   * UxMedia implementation of `kitPx:Bargraph`.
   *
   * @class
   * @alias module:nmodule/kitPx/rc/ux/Bargraph
   * @extends module:bajaux/Widget
   */
  var BarGraph = /*#__PURE__*/function (_spandrel) {
    function BarGraph(params) {
      _classCallCheck(this, BarGraph);
      return _callSuper(this, BarGraph, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Move the text outside of the bar if it doesn't fit.
     */
    _inherits(BarGraph, _spandrel);
    return _createClass(BarGraph, [{
      key: "doLayout",
      value: function doLayout() {
        var bar = this.jq().find('.-t-Bargraph-bar');
        if (!bar.length) {
          return;
        }
        var text = bar.children('.-t-Bargraph-text');
        var orientation = this.properties().getValue('orientation').getTag();
        var textBiggerThanBar = orientation === 'vertical' ? text.height() > bar.height() : text.width() > bar.width();
        text.toggleClass('-t-Bargraph-text-outside-bar', textBiggerThanBar);
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var max = properties.max,
      min = properties.min,
      orientation = properties.orientation,
      scale = properties.scale,
      scaleVisible = properties.scaleVisible,
      text = properties.text,
      value = properties.value,
      valueVisible = properties.valueVisible;
    if (scale < 0) {
      scaleVisible = false;
    } else if (scale === 0) {
      scale = calcAutoScale(min, max);
    }
    var percent = clamp((value - min) / (max - min) * 100, 0, 100);
    var notchCount = scaleVisible ? Math.floor((max - min) / scale) : 0;
    var notchHeight = 100 / notchCount + '%';
    return Promise.all(range(0, notchCount).map(function (i) {
      return toNotchLabel(i, min, scale);
    })).then(function (notchLabels) {
      return spandrel.jsx("div", {
        className: "-t-Bargraph-wrapper -t-Bargraph-wrapper-".concat(orientation.getTag()),
        $init: initWrapper(properties)
      }, spandrel.jsx("div", {
        className: "-t-Bargraph-bar",
        style: {
          flexBasis: percent + '%'
        },
        $init: initBar(properties)
      }, spandrel.jsx("label", {
        className: "-t-Bargraph-text",
        style: {
          display: !valueVisible && 'none'
        },
        $init: initText(properties)
      }, text)), spandrel.jsx("div", {
        className: "-t-Bargraph-scale",
        style: {
          display: !scaleVisible && 'none'
        },
        $init: initScale(properties)
      }, notchLabels.map(function (notchLabel) {
        return spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch",
          style: {
            flexBasis: notchHeight
          }
        }, spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch-text"
        }, notchLabel), spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch-tick",
          $init: initNotchTick(properties)
        }));
      })));
    });
  }));
  function calcAutoScale(min, max) {
    var delta = max - min;
    var log10 = Math.log(delta) * LOG10E;
    var tickIncrement = Math.max(Math.pow(10, Math.trunc(log10)), Number.MIN_VALUE);
    var tickCount = Math.trunc(delta / tickIncrement);

    // at the completion of this block of code we are guaranteed
    // that (tickCount < MAX_TICKS) -- which is the primary goal.
    if (delta > 1) {
      if (tickCount < MIN_AUTO_TICKS) {
        tickIncrement /= 10.0;
        while (tickCount < MIN_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
        // squeeze
        while (tickCount > MAX_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
      }
    } else {
      // <= 1.0
      if (tickCount < MIN_AUTO_TICKS) {
        tickIncrement /= 10.0;
        while (tickCount < MIN_AUTO_TICKS) {
          tickIncrement /= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
        // squeeze
        while (tickCount > MAX_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
      }
    }
    return tickIncrement;
  }
  function calcPrecision(scale) {
    var precision = 1;
    while (scale < 1) {
      scale *= 10;
      ++precision;
    }
    return precision;
  }
  function clamp(value, min, max) {
    return Math.min(Math.max(min, value), max);
  }

  /** style the filled bar portion of the graph */
  function initBar(_ref2) {
    var fill = _ref2.fill;
    return function (el) {
      return fill.applyBackgroundToElement(el);
    };
  }

  /** style the "tick" at each notch in the scale display */
  function initNotchTick(_ref3) {
    var foreground = _ref3.foreground;
    return function (el) {
      return foreground.applyBackgroundToElement(el);
    };
  }

  /** style the scale display which contains the ticks and tick labels */
  function initScale(_ref4) {
    var foreground = _ref4.foreground,
      scaleFont = _ref4.scaleFont;
    if (scaleFont.equivalent(Font.NULL)) {
      scaleFont = Font.make(kitPxLex.get('bargraph.scale.font'));
    }
    return function (el) {
      foreground.applyForegroundToElement(el);
      scaleFont.applyToElement(el);
    };
  }

  /** style the text display of the current value */
  function initText(_ref5) {
    var foreground = _ref5.foreground,
      valueFont = _ref5.valueFont;
    if (valueFont.equivalent(Font.NULL)) {
      valueFont = Font.make(kitPxLex.get('bargraph.value.font'));
    }
    return function (el) {
      valueFont.applyToElement(el);
      foreground.applyForegroundToElement(el);
    };
  }

  /** style the background */
  function initWrapper(_ref6) {
    var background = _ref6.background,
      foreground = _ref6.foreground;
    return function (el) {
      Border.make({
        width: 1,
        style: Border.SOLID,
        brush: foreground
      }).applyToElement(el);
      background.applyBackgroundToElement(el);
    };
  }
  function toNotchLabel(i, min, scale) {
    return i ? (min + i * scale).toString({
      precision: calcPrecision(scale),
      trimTrailingZeros: true
    }) : '';
  }
  return BarGraph;
});
