function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/SetPointEditor
 */
define(['bajaux/mixin/subscriberMixIn', 'bajaux/Properties', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'baja!'], function (subscriberMixIn, Properties, CompositeEditor, CompositeBuilder, baja) {
  'use strict';

  var INNER_EDITOR = 'innerEditor',
    keys = [INNER_EDITOR];

  /**
   * Bajaux Editor for SetPointEditor which only works with HxSetPointFE to call the set
   * action on a ControlPoint when any modified changes to the editor occur and the
   * save is invoked.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/config/CompositeBuilder
   * @alias module:nmodule/kitPx/rc/SetPointEditor
   */
  var SetPointEditor = function SetPointEditor() {
    var that = this;
    CompositeEditor.apply(that, arguments);
    subscriberMixIn(that);
  };

  //extend and set up prototype chain
  SetPointEditor.prototype = Object.create(CompositeEditor.prototype);
  SetPointEditor.prototype.constructor = SetPointEditor;

  /**
   * Creates a span element for the inner editor.
   * @param {Object} dom
   * @returns {Promise}
   */
  SetPointEditor.prototype.doInitialize = function (dom) {
    dom.html('<span class="js-' + INNER_EDITOR + '"/>');
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Load the value into an inner editor. When a ControlPoint is loaded,
   * subscribe to 'out' slot and provide any changes to the userif the
   * Editor is not modified.
   * @param {baja.Value} value
   * @param loadParams The Object literal for load params
   * @returns {Promise}
   */
  SetPointEditor.prototype.doLoad = function (value, loadParams) {
    var that = this;
    return CompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      if (loadParams && loadParams.complexOrd && !loadParams.slot) {
        //SetPointFieldEditor subscribes to the complex Ord and updates on any changes to out when the slot is empty
        return baja.Ord.make(loadParams.complexOrd).get({
          lease: true
        }).then(function (comp) {
          that.getSubscriber().attach("changed", function (prop) {
            if (prop.getName() === "out" && !that.isModified()) {
              return that.getBuilder().getEditorFor(INNER_EDITOR).load(comp.get(prop).getValue());
            }
          });
          return that.getSubscriber().subscribe(comp).then(function () {
            if (!that.isModified()) {
              //this accounts for any changes to the out value that occur between when the HxSetPointEditor is loaded and the subscription starts.
              return that.getBuilder().getEditorFor(INNER_EDITOR).load(comp.get("out").getValue());
            }
          });
        });
      }
    });
  };

  /**
   *  Read the result of the inner Widget.read(). If the value happens to be a
   *  'baja:StatusValue' then ensure to make the status {ok} just like bajaui does.
   *  @returns {baja.Value}
   */
  SetPointEditor.prototype.doRead = function () {
    var that = this;
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        result = _ref2[0];
      if (that.value().getType().is("baja:StatusValue")) {
        var statusValue = that.value().newCopy();
        statusValue.setStatus(baja.Status.ok);
        statusValue.setValue(result);
        return statusValue;
      }
      return result;
    });
  };

  /**
   * Provide a copy of the value in to the inner editor. If the value is a
   * 'baja:StatusValue' then only send down the value. Transfer all properties
   * except the 'uxFieldEditor'.
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  SetPointEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder(),
      properties = that.properties().clone();
    properties.remove("uxFieldEditor");
    builder.getDomFor = function (key) {
      return that.jq().children('.js-' + key);
    };
    builder.getKeys = function () {
      return keys.slice();
    };
    builder.getValueFor = function (key) {
      if (key === INNER_EDITOR) {
        if (that.value().getType().is("baja:StatusValue")) {
          //SetPointFieldEditor only shows the value and not status even if the
          //binding ord is for a StatusValue.
          return that.value().getValue().newCopy();
        } else {
          return that.value().newCopy();
        }
      }
    };
    builder.getConfigFor = function (key) {
      if (key === INNER_EDITOR) {
        return {
          formFactor: that.getFormFactor(),
          properties: properties
        };
      }
    };
    return builder;
  };
  return SetPointEditor;
});
