function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/fe/GenericFieldEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/bajaui/rc/model/UxModelSupport', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/commands/PopOutCommand', 'css!nmodule/kitPx/rc/kitPx'], function (baja, $, Promise, spandrel, Widget, CommandGroup, CommandButtonGroup, UxModelSupport, fe, ComplexDiff, PropertySheet, PopOutCommand) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-GenericFieldEditor',
        foreground: baja.$('gx:Brush', 'null'),
        background: baja.$('gx:Brush', 'null')
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/kitPx/rc/fe/GenericFieldEditor
   * @extends {module:bajaux/spandrel/SpandrelWidget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function GenericFieldEditor(params) {
      var _this;
      _classCallCheck(this, GenericFieldEditor);
      _this = _callSuper(this, GenericFieldEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      UxModelSupport(_this);
      return _this;
    }

    /**
     * Returns the editor wrapped by this editor
     * 
     * @returns {module:bajaux/Widget}
     */
    _inherits(GenericFieldEditor, _spandrel);
    return _createClass(GenericFieldEditor, [{
      key: "getContent",
      value: function getContent() {
        return this.queryWidget('editor');
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this2 = this;
        return _superPropGet(GenericFieldEditor, "doLoad", this, 3)(arguments).then(function () {
          var ed = _this2.getContent(),
            buttonGroup = _this2.queryWidget('commands');

          //no double popup required for when the PropertySheet is used
          if (!ed || !buttonGroup || ed instanceof PropertySheet) {
            return;
          }
          var cmdGroup = new CommandGroup({
            commands: [new PopOutCommand(ed)]
          });
          return buttonGroup.load(cmdGroup);
        });
      }
    }, {
      key: "doRead",
      value: function doRead() {
        var content = this.getContent();
        return content && content.read().then(function (value) {
          if (value instanceof ComplexDiff) {
            return value.apply(content.value().newCopy(true));
          }
          return value;
        });
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var content = this.getContent();
        return content && content.save();
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyStyles();
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.$lastKnownValue = undefined;
        return _superPropGet(GenericFieldEditor, "doDestroy", this, 3)(arguments);
      }

      /**
       * Get only the text input inside the field editor content.
       * 
       * @returns {Element|null}
       */
    }, {
      key: "$getContentTextElement",
      value: function $getContentTextElement() {
        var content = this.getContent();
        return content && content.jq().children('input')[0];
      }

      /**
       * Apply only to text input for now matching wb 
       */
    }, {
      key: "$applyStyles",
      value: function $applyStyles() {
        var contentTextEl = this.$getContentTextElement();
        if (contentTextEl) {
          var background = this.properties().getValue('background');
          var foreground = this.properties().getValue('foreground');
          background.applyBackgroundToElement(contentTextEl);
          foreground.applyForegroundToElement(contentTextEl);
        }
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    if (rootElement) {
      rootElement.classList.add('hx-bajaux-fe');
      rootElement.classList.add('ux-fg');
    }
    var value = model.getValue();
    if (!baja.hasType(value)) {
      //TODO: NCCB-48876: caching `$lastKnownValue` is used to workaround the value disappearing
      if (this.$lastKnownValue === undefined) {
        return '<div/>'; // no value ready to load yet
      } else {
        value = this.$lastKnownValue;
      }
    }
    this.$lastKnownValue = value;

    // If an appropriate mini editor is not found for the value then fallback to PropertySheet
    return fe.getDefaultConstructor(value.getType(), {
      formFactors: ['mini']
    }).then(function (ctor) {
      return ctor || value.getType().isComplex() && PropertySheet;
    }).then(function (Editor) {
      return {
        editor: {
          dom: '<div class="hx-bajaux-editor" />',
          properties: properties,
          value: value,
          type: Editor
        },
        commands: {
          dom: '<div/>',
          properties: {
            toolbar: true,
            onDisabled: 'hide'
          },
          type: CommandButtonGroup
        }
      };
    });
  }, {
    manager: fe.getWidgetManager()
  }));
});
