function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* jshint browser: true */ /* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/PopupBinding
 */
define(['baja!', 'baja!gx:Size,gx:Point', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'log!uxMedia', 'css!nmodule/kitPx/rc/kitPx'], function (baja, types, Binding, profileUtils, log) {
  'use strict';

  var logFine = log.fine.bind(log),
    logWarning = log.warning.bind(log),
    logSevere = log.severe.bind(log);
  var modalPopups = {};

  /**
   * BajaScript implementation of a `kitPx:PopupBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/PopupBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function PopupBinding() {
      _classCallCheck(this, PopupBinding);
      return _callSuper(this, PopupBinding, arguments);
    }
    _inherits(PopupBinding, _Binding);
    return _createClass(PopupBinding, [{
      key: "addListeners",
      value:
      /**
       * Add event listeners for the widget:
       *
       * - on click, popup
       * - add CSS to indicate cursor
       *
       * @param {module:bajaux/Widget} widget
       */
      function addListeners(widget) {
        var _this = this;
        this.addWidgetEvents(widget, {
          click: function click(e) {
            var ord = _this.get('ord');
            if (ord.isNull()) {
              return;
            }
            var ordTarget = _this.getOrdTarget();
            if (ordTarget && ordTarget.ord) {
              var viewQuery = profileUtils.getViewQuery(ord);
              //Avoid the `optimizedOrd` ord stored in the ord property in favor of the original ord which is usually more human-readable.
              //Optimized ords for components can handle ords and the user is more likely to want to see the original slot ord that they entered.
              ord = ordTarget.ord;
              if (viewQuery) {
                ord = baja.Ord.make({
                  base: ord,
                  child: viewQuery
                });
              }
            }
            var url = ord.toUri();
            _this.popup({
              url: url,
              popupWidth: _this.get('size').getWidth(),
              popupHeight: _this.get('size').getHeight(),
              popupX: _this.get('position').x(),
              popupY: _this.get('position').y(),
              external: isExternal(ord),
              modal: _this.get('modal'),
              title: _this.get('title')
            })["catch"](logSevere);
          },
          initialized: function initialized() {
            var ord = _this.get('ord');
            widget.jq().addClass('ux-PopupBinding').toggleClass('popup-target', !ord.isNull());
          },
          destroyed: function destroyed() {
            widget.jq().removeClass('ux-PopupBinding popup-target');
            _this.$cleanupClosedModalPopups();
          }
        });
      }

      /**
       * Open a popup to the specified dimensions and position. If dimension information is not provided, will default
       * to 90% of screen size. Make sure to set external=true for links to non-niagara websites like https://www.google.com.
       * If the link is not external, fullScreen=true will be added to the view parameters to ensure that the HxProfile chrome
       * is not present in the popup.
       * @param {Object} [obj] the Object Literal for the method's arguments.
       * @param {String} obj.url
       * @param {Number} [obj.popupWidth]
       * @param {Number} [obj.popupHeight]
       * @param {Number} [obj.popupX]
       * @param {Number} [obj.popupY]
       * @param {Boolean} [obj.external] If true, will not add the fullScreen=true view parameter to the url.
       * @param {Boolean} [obj.modal] If true, the current pop-up can only be opened one at a time.
       * @param {String} [obj.title] If provided, the initial title on the pop-up can be set,
       * @return {Promise.<boolean>} resolves to true if a new window was opened.
       */
    }, {
      key: "popup",
      value: function popup(obj) {
        var _this2 = this;
        return window.niagara.env.toHyperlink(obj.url).then(function (hyperlinkUrl) {
          var popupX = obj.popupX,
            popupY = obj.popupY,
            popupWidth = obj.popupWidth,
            popupHeight = obj.popupHeight,
            external = obj.external,
            modal = obj.modal,
            title = obj.title;
          var url = hyperlinkUrl;
          if (popupWidth === undefined) {
            var factor = 0.9;
            popupWidth = Math.floor(screen.width * factor);
            popupHeight = Math.floor(screen.height * factor);
            popupX = (screen.width - popupWidth) / 2;
            popupY = (screen.height - popupHeight) / 8; //allow extra space for toolbar and status bar
          }
          var fullUrl = url + (external ? "" : "|view:?fullScreen=true");
          var win,
            specs = "resizable=yes, " + "location=no, " + "scrollbars=yes, " + "status=no, " + "toolbar=no, " + "left=" + popupX + ", " + "top=" + popupY + ", " + "width=" + popupWidth + ", " + "height=" + popupHeight;
          var pop = modalPopups[fullUrl];
          if (pop && !pop.closed && isValidLocation(pop)) {
            //if pop-up is modal then focus original one instead of opening a new one
            pop.focus();
            return false;
          }
          win = window.open(fullUrl, 'fullScreen' + new Date().getTime(), specs, false);
          if (win) {
            setLoadedTitle(win, title);
          } else {
            logWarning("Pop-ups must be enabled...");
            return false;
          }
          _this2.$cleanupClosedModalPopups();
          if (modal) {
            modalPopups[fullUrl] = win;
          }
          return true;
        });
      }
      /**
       * cleanup the closed modal dialogs
       */
    }, {
      key: "$cleanupClosedModalPopups",
      value: function $cleanupClosedModalPopups() {
        Object.keys(modalPopups).forEach(function (name) {
          var oldPop = modalPopups[name];
          if (oldPop && oldPop.closed) {
            //references to closed modal dialogs are no longer required
            delete modalPopups[name];
          }
        });
      }

      /**
       * cleanup all modal dialogs
       */
    }, {
      key: "$cleanupAllModalPopups",
      value: function $cleanupAllModalPopups() {
        modalPopups = {};
      }
    }]);
  }(Binding);

  /**
   * Attempt to set the popup window title after it has loaded, but this doesn't prevent the window from changing its title after load.
   *
   * @param {DOMWindow} popupWindow
   * @param {String} [title]
   * @return {boolean}
   */
  function setLoadedTitle(popupWindow, title) {
    if (!title) {
      return;
    }
    try {
      popupWindow.addEventListener('load', function () {
        formatTitle(title).then(function (titleFormat) {
          if (titleFormat) {
            popupWindow.document.title = titleFormat;
          }
        })["catch"](logFine);
      });
    } catch (err) {
      //if an error is provided, its likely that the page title cannot be set because of its a cross-origin frame.
      logFine(err);
    }
    return true;
  }

  /**
   * For better localization support, treat the title as a BFormat. If any error is presented, fallback to original string behavior.
   * @param {String} [title]
   * @return {Promise<string>}
   */
  function formatTitle(title) {
    return baja.Format.format({
      pattern: title
    }).then(function (titleFormat) {
      if (!titleFormat || titleFormat.indexOf('%err:') > -1) {
        return title;
      }
      return titleFormat;
    })["catch"](function (e) {
      logFine(e);
      return title;
    });
  }
  function isValidLocation(popupWindow) {
    try {
      return popupWindow.location && popupWindow.location.href;
    } catch (err) {
      //if an error is provided, its likely that the page is still open and the site
      //prevents a cross-origin frame. When the page is closed, there should be no error
      logFine(err);
    }
    return true;
  }

  /**
   * Determine if the Ord is External or not.
   * @param {baja.Ord} ord
   * @return {boolean}
   */
  function isExternal(ord) {
    var queries = baja.Ord.make(ord).parse(),
      i,
      external = false;
    for (i = 0; i < queries.size(); ++i) {
      if (queries.get(i).getSchemeName() === "http" || queries.get(i).getSchemeName() === "https") {
        external = true;
      } else if (external && queries.get(i).getSchemeName() === "view") {
        var params = queries.get(i).getParameters();
        if (params['external'] === 'false') {
          external = false;
        }
      }
    }
    return external;
  }
});
