/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnetAws/rc/wb/mgr/commands/BacnetCommandSheet
 */
define(['nmodule/webEditors/rc/wb/PropertySheet'], function (PropertySheet) {

  'use strict';

  /**
   * BacnetCommandSheet provides support for BacnetAws Commands
   * @class
   * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/BacnetCommandSheet
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   */
  var BacnetCommandSheet = function BacnetCommandSheet() {
    PropertySheet.apply(this, arguments);
  };

  BacnetCommandSheet.prototype = Object.create(PropertySheet.prototype);
  BacnetCommandSheet.prototype.constructor = BacnetCommandSheet;

  BacnetCommandSheet.prototype.doInitialize = function (dom) {
    dom.addClass("BacnetCommandSheet");
    return PropertySheet.prototype.doInitialize.apply(this, arguments);
  };

  BacnetCommandSheet.prototype.doDestroy = function () {
    var jq = this.jq();
    if (jq) {
      jq.removeClass("BacnetCommandSheet");
    }
    return PropertySheet.prototype.doDestroy.apply(this, arguments);
  };

  return BacnetCommandSheet;
});
