/**
 * @copyright 2015, Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webChart/rc/command/StopCommand
 */
define([
    'jquery',
    'baja!',
    'lex!',
    'dialogs',
    'nmodule/webChart/rc/webChartUtil',
    'nmodule/webChart/rc/choiceUtil',
    'bajaux/commands/Command',
    'nmodule/webChart/rc/tab/TabbedEditor',
    'nmodule/webChart/rc/tab/Tab',
    'nmodule/webChart/rc/chartEvents',
    'nmodule/webChart/rc/fe/SimplePropertySheet',
    'nmodule/webChart/rc/fe/color/ColorEditor',
    'baja!' +
    'baja:Boolean,' +
    'baja:AbsTime,' +
    'baja:AbsTimeRange,' +
    'baja:TimeRange,' +
    'baja:Weekday,' +
    'baja:User,' +
    'webChart:WebChartTimeRange,' +
    'webChart:WebChartTimeRangeType,' +
    'bql:DynamicTimeRangeType'

  ],
  function($,
    baja,
    lex,
    dialogs,
    webChartUtil,
    choiceUtil,
    Command,
    TabbedEditor,
    Tab,
    chartEvents,
    SimplePropertySheet) {
    "use strict";

    /**
     * StopCommand is a Command that provides access to Stop the Chart Model from loading
     *
     * @private
     * @class
     * @alias module:nmodule/webChart/rc/command/StopCommand
     * @extends module:bajaux/commands/Command
     * @param {module:nmodule/webChart/rc/ChartWidget} widget
     */

    var StopCommand = function StopCommand(widget) {

      var that = this;
      Command.call(that, {
        module: "webChart",
        lex: "webChart.stopCommand",
        selected: false,
        func: function() {
          var model = widget.model();
          if(!model.isStopped()){
            model.stop();
          }else{
            model.reloadAll();
          }
        }
      });
    };

    StopCommand.prototype = Object.create(Command.prototype);
    StopCommand.prototype.constructor = StopCommand;

    return StopCommand;
  });
