/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/util/util
 */
define([
    'baja!',
    'baja!ndriver:NNetwork,ndriver:NDevice,driver:PointDeviceExt',
    'lex!',
    'nmodule/webEditors/rc/fe/baja/util/compUtils',
    'nmodule/webEditors/rc/wb/table/model/Column'
  ], function (
    baja,
    types,
    lex,
    compUtils
  ) {

  'use strict';

  var closest = compUtils.closest;

  /**
   * A general purpose utility class for ndriver
   *
   * API Status: **Private**
   * @exports nmodule/ndriver/rc/util/util
   */
  var exports = {};

  /**
   * Returns the lexicon value for the moduleName/lexiconKey, returns blank if not found
   *
   * @param {String} moduleName
   * @param {String} lexiconKey
   */
  exports.getLexiconForModule = function (moduleName, lexiconKey) {
    return lex.module(moduleName)
    .then(function (moduleLex) {
      return  moduleLex.get(lexiconKey);
    })
    .catch(function (ignore) {
      return '';
    });
  };

  /**
   * Find the NDevice for the passed in component.
   *
   * @param {baja.Component} component
   * @returns {baja.Component}
   */
  exports.getNDevice = function (component) {
    return closest(component, 'ndriver:NDevice');
  };

  /**
   * Find the NNetwork for the passed in component.
   *
   * @param {baja.Component} component
   * @returns {baja.Component}
   */
  exports.getNNetwork = function (component) {
    return closest(component, 'ndriver:NNetwork');
  };

  /**
   * Find the NPointDeviceExt for the passed in component.
   *
   * @param {baja.Component} component
   * @returns {baja.Component}
   */
  exports.getNPointDeviceExt = function (component) {
    // Because BNPointDeviceExt implements BINDiscoveryHost (meaning the standard
    // ndriver pointDevExt assumes discovery is supported), for drivers that don't
    // support point discovery the NDriver Wizard creates a pointDeviceExt that
    // extends BPointDeviceExt (and not BNPointDevExt), so we actually need to
    // look for a BPointDeviceExt here.
    return closest(component, 'driver:PointDeviceExt');
  };

  return exports;
});
