/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/column/NTypeMgrColumn
 */
define([
    'baja!',
    'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn'
  ], function (
    baja,
    TypeMgrColumn
  ) {

  'use strict';

  /**
   * An implementation of TypeMgrColumn for ndriver that caters for using a
   * discovery object to configure a newInstance..
   *
   * @class
   * @alias module:nmodule/ndriver/rc/column/NTypeMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {Object} params
   */
  var NTypeMgrColumn = function NTypeMgrColumn(params) {
    TypeMgrColumn.apply(this, arguments);
  };

  NTypeMgrColumn.prototype = Object.create(TypeMgrColumn.prototype);
  NTypeMgrColumn.prototype.constructor = NTypeMgrColumn;

  /**
   * Returns a new instance for the selected typeInfo.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} mgrModel
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {Promise.<baja.Value>}
   */
  NTypeMgrColumn.prototype.newInstance = function (mgrModel, row) {
    // mgrModel will be an ndriver MgrModel that knows how to
    // deal with the additional params argument.
    return mgrModel.newInstance(
      row.data(TypeMgrColumn.SELECTED_TYPE_KEY), // typeInfo
      { discovery: row.data(TypeMgrColumn.DISCOVERY_DATA_KEY) } // params
    );
  };

  return (NTypeMgrColumn);
});
