/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module transfer
 * @private
 */
define(['bajaScript/comm'], function (baja) {
  
  'use strict';

  /**
   * @namespace baja.transfer
   */
  var transfer = {
    /**
     * Perform a station-side copy using the Niagara Transfer API.
     * 
     * @param {Object} config
     * @param {Array.<String|baja.Ord>} config.sourceOrds ORDs of the source
     * nodes to be copied
     * @param {Array.<String|baja.Ord>} [config.sourceBases] Base ORDs used to
     * resolve the source ORDs; any missing base ORDs will use localhost
     * @param {baja.NavNode} config.target a mounted target nav node to receive
     * the copied nodes
     * @param {Array.<String>} [config.names] desired names for the copied
     * nodes. If omitted, auto-generated names will be used.
     * @returns {Promise} promise to be resolved after the copy operation
     * completes; if the target is a Component, its component space will also be
     * synced. Promise will be resolved with an array of the node names of the
     * newly copied nodes.
     */
    copy: function (config) {
      var cb = new baja.comm.Callback();
      baja.comm.copy(config, cb);
      return cb.promise();
    }
  };
  
  baja.transfer = transfer;
  
  return baja;
});