/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* jshint browser: true *//* eslint-env browser */

define([], function () {
  'use strict';

  var ENCODER = new TextEncoder("UTF-8");
  var DECODER = new TextDecoder("UTF-8");

  /**
   * API Status: **Private**
   * @exports baja/env/mux/muxUtils
   */
  var exports = {};

  /**
   * @param {string|Uint8Array} str
   * @returns {Uint8Array}
   */
  exports.toBytes = function (str) {
    if (typeof str === 'string') {
      return ENCODER.encode(str);
    }
    return str;
  };

  /**
   * @param {Uint8Array|string} arr
   * @returns {string}
   */
  exports.fromBytes = function (arr) {
    if (typeof arr === 'string') {
      return arr;
    }
    return DECODER.decode(arr);
  };

  /**
   * @param {Uint8Array|string} arr
   * @returns {module:baja/env/mux/BoxEnvelope~BoxFragment}
   */
  exports.decodeFragment = function (arr) {
    var isString = typeof arr === 'string';
    var delimiter = isString ? ';' : ';'.charCodeAt(0);

    var i = 0;
    function token() {
      var index = i;
      while (arr[index] !== delimiter) { index++; }
      var str = toToken(arr, i, index);
      i = index + 1;
      return str;
    }

    var fragmentMarker = token();
    if (fragmentMarker !== 'F') {
      throw new Error('unrecognized fragment marker "' + fragmentMarker + '"');
    }

    var boxVersion = token();
    if (boxVersion !== '2.2.1') {
      // shrug
    }
    var sessionId = token();
    var envelopeId = +token();
    var fragmentCount = +token();
    var fragmentIndex = +token();
    var unsolicited = token() === 'u';
    var payload = exports.toBytes(toToken(arr, i, arr.length));

    return {
      sessionId: sessionId,
      envelopeId: envelopeId,
      fragmentCount: fragmentCount,
      fragmentIndex: fragmentIndex,
      unsolicited: unsolicited,
      payload: payload
    };
  };


  /**
   * @param {Uint8Array|string} arr
   * @param {number} start
   * @param {number} end
   * @returns {string}
   */
  function toToken(arr, start, end) {
    if (typeof arr === 'string') {
      return arr.substring(start, end);
    } else {
      return exports.fromBytes(arr.slice(start, end));
    }
  }

  return exports;
});
