/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jshint browser: true *//* eslint-env browser */

/**
 * Workbench Connection.
 *
 * API Status: **Private**
 * @module baja/env/WorkbenchConnection
 */
define([ "bajaScript/comm",
        "bajaScript/env/Connection",
        "bajaScript/baja/comm/Callback" ], function (
        baja, 
        Connection,
        Callback) {

  "use strict";

  /**
   * A connection that uses Workbench's Java/JavaScript interop.
   *
   * @class
   * @extends module:baja/env/Connection
   * @alias module:baja/env/WorkbenchConnection
   * @param {module:baja/env/Connection~ConnectionEvents} handlers handlers
   * for connection events.
   * @param {module:baja/env/ConnectionManager} connectionManager the connection
   * manager responsible for processing BoxFrames via incoming websocket
   * messages
   */
  var WorkbenchConnection = function (handlers, connectionManager) {
    baja.callSuper(WorkbenchConnection, this, arguments);
  };

  baja.subclass(WorkbenchConnection, Connection);

  /**
   * No-op as Workbench handles authentication internally.
   */
  WorkbenchConnection.prototype.doAuthenticate = function () {
    
  };

  /**
   * Shim in a WebSocket double that operates via JS/Java interop, and use it
   * to create a new server session.
   */
  WorkbenchConnection.prototype.start = function () {
    var oldMakeServerSession = baja.comm.makeServerSession,
      that = this,
      wbSocket;

    window.wbSocket = wbSocket = that.$internalConnection = {
      send: function (data) {
        window.niagara_wb_util_sendBox(data);
      },
      close: function () {},
      setServerSessionId: function (id) {
        window.niagara_wb_util_setServerSessionId(id);
      },
      onMessageStr: function (msgStr) {
        this.onmessage({ data: msgStr });
      },
      onmessage: that.$handlers.message,
      onerror: that.$handlers.error,
      readyState: Connection.WS_OPEN // A Workbench Web Socket is always open.
    };

    baja.comm.makeServerSession = function (cb) {
      cb.addOk(function (ok, fail, id) {
        wbSocket.setServerSessionId(id);
        ok(id);
      });
      // Invoke the old method
      oldMakeServerSession.apply(baja.comm, arguments);
    };

    // If available just use the Workbench Web Socket (Workbench Web Browser only).
    baja.runAsync(that.$handlers.open);

    var cb = new Callback();
    baja.comm.makeServerSession(cb);
    return cb.promise();
  };

  /**
   * Workbench does not support navigator.sendBeacon, but it also has no
   * restrictions on sync XHRs - so just send it as a normal POST.
   *
   * @param {module:baja/env/Connection~FrameData} frameData
   */
  WorkbenchConnection.prototype.sendBeacon = function (frameData) {
    return this.send(frameData);
  };


  return WorkbenchConnection;
});
