/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * Http-only connection that will not attempt to use a web socket.
 *
 * API Status: **Private**
 * @module baja/env/HttpOnlyConnection
 */
define([ "bajaScript/comm",
        "bajaScript/env/Connection",
        "bajaScript/baja/comm/Callback" ], function (
         baja,
         Connection,
         Callback) {

  "use strict";

  /**
   * A connection that does not attempt to use a WebSocket for communication.
   * It will perform authentication and nothing else.
   *
   * @class
   * @alias module:baja/env/HttpOnlyConnection
   * @extends module:baja/env/Connection
   */
  var HttpOnlyConnection = function () {
    baja.callSuper(HttpOnlyConnection, this, arguments);
  };
  baja.subclass(HttpOnlyConnection, Connection);

  /**
   * Authenticates by creating a new server session.
   * @returns {Promise}
   */
  HttpOnlyConnection.prototype.doAuthenticate = function () {
    var cb = new Callback();
    baja.comm.makeServerSession(cb);
    return cb.promise();
  };

  /**
   * Always returns false to indicate that the caller should send the data over
   * HTTP.
   */
  HttpOnlyConnection.prototype.send = function () {
    return false;
  };

  return HttpOnlyConnection;
});  
