/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.VirtualComponentSpace}.
 * @module baja/virt/VirtualComponentSpace
 */
define(["bajaScript/sys",
        "bajaScript/baja/boxcs/BoxComponentSpace",
        "bajaScript/baja/ord/Ord"], 
        function (baja, BoxComponentSpace, Ord) {

  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper,
      strictArg = baja.strictArg;
  
  /**
   * Represents a `baja:VirtualComponentSpace` in BajaScript.
   *
   * @class
   * @alias baja.VirtualComponentSpace
   * @extends baja.BoxComponentSpace
   */  
  var VirtualComponentSpace = function VirtualComponentSpace(gateway) {
    callSuper(VirtualComponentSpace, this, ["virtual"]);
    this.$gateway = strictArg(gateway);
  };
  
  subclass(VirtualComponentSpace, BoxComponentSpace);
  
  /**
   * Return absolute ORD for the Component Space.
   *
   * @returns {baja.Ord}
   */
  VirtualComponentSpace.prototype.getAbsoluteOrd = function () {
    return Ord.make(this.$gateway.getNavOrd().toString() + "|virtual:");
  };

  /**
   * Return the navigation ORD for the Component Space.
   *

   * @returns {baja.Ord}
   */
  VirtualComponentSpace.prototype.getNavOrd = function () {
    return this.getAbsoluteOrd();
  };
  
  /**
   * Private framework handler for a Component Space.
   * 
   * This is a private internal method for framework developers.
   *
   * @private
   */
  VirtualComponentSpace.prototype.$fw = function (x, a, b, c) {    
    if (x === "unmount") {
      // When a Virtual Component is removed then reset the parent broker properties loaded flag 
      var parent = a.getParent();
      if (parent) {
        parent.$bPropsLoaded = false;
      }
    }
    callSuper("$fw", VirtualComponentSpace, this, arguments);
  };  
  
  return VirtualComponentSpace;
});