/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/tag/BasicEntity
 */
define(["bajaScript/sys",
        "bajaScript/baja/tag/Id",
        "bajaScript/baja/tag/TagSet",
        "bajaScript/baja/tag/RelationSet",
        "bajaPromises"], function (
        baja,
        Id,
        TagSet,
        RelationSet,
        Promise) {
  
  "use strict";
     
  /**
   * An entity is an object that can be tagged and related to other entities.
   *
   * @class
   * @alias module:baja/tag/BasicEntity
   */  
  var BasicEntity = function BasicEntity(ord, tags, relations) {
    var that = this;
    that.$ord = typeof ord === "string" ? baja.Ord.make(ord) : (ord || baja.Ord.DEFAULT);
    that.$tags = tags || new TagSet();
    that.$relations = relations || new RelationSet();
  };

  /**
   * @returns {baja.Ord} Return an ORD to the Entity.
   */
  BasicEntity.prototype.getOrdToEntity = function() {
    return this.$ord;
  };

  /**
   * @returns {Promise} Return a promise that resolves to a relations object.
   */
  BasicEntity.prototype.relations = function() {
    return Promise.resolve(this.$relations);
  };

  /**
   * @returns {Promise} Return a promise that resolves to a tags object.
   */
  BasicEntity.prototype.tags = function() {
    return Promise.resolve(this.$tags);
  };

  return BasicEntity;
});