/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.AsyncCursor}.
 * @module baja/sys/structures/AsyncCursor
 */
define(["bajaScript/baja/sys/inherit",
		"bajaScript/baja/sys/structures/Cursor"], function (
         inherit,
         Cursor) {
  
  "use strict";
  
  var subclass = inherit.subclass;
  
  /** 
   * An asynchronous generic cursor used for iteration.
   * 
   * An Async Cursor may fetch its results asynchronously (i.e. across a network).
   *
   * @class
   * @alias baja.AsyncCursor
   * @extends baja.Cursor
   */
  var AsyncCursor = function AsyncCursor() {
  };
  
  subclass(AsyncCursor, Cursor);
  
  return AsyncCursor;
});