/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Value}.
 * @module baja/obj/Value
 */
define(["bajaScript/sys",
        "bajaScript/baja/obj/Object"], 
        function (baja, BObject) {
  
  'use strict';
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Represents `baja:Value` in BajaScript.
   * 
   * Since this Constructor represents an abstract class, it should never
   * be directly used to create a new Object.
   *
   * @class
   * @alias baja.Value
   * @extends baja.Object
   */
  var Value = function Value() {
    callSuper(Value, this, arguments);
  };
  
  subclass(Value, BObject);
  
  /**
   * Every value may be cloned using the `newCopy` method.
   * 
   * Please note that `Simple`s are immutable so they don't
   * allocate a new instance.   
   *
   * @see baja.Simple
   *
   * @param {Boolean} [exact] true if an exact copy of the value should be 
   * made (only valid in the Component architecture).
   * @returns a copy of the value (or the same instance if the value is a 
   * `Simple`).
   */
  Value.prototype.newCopy = function (exact) {
    return this;
  };
        
  return Value;
});