/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * Defines {@link baja.DefaultSimple}.
 * @module baja/obj/Password
 */
define(["bajaScript/sys", "bajaScript/baja/obj/DefaultSimple"],
  function (baja, DefaultSimple) {

    'use strict';

    var subclass  = baja.subclass,
        callSuper = baja.callSuper;

    /**
     * @class Password
     * @private
     * @extends baja.DefaultSimple
     */
    var Password = function Password(val) {
      callSuper(Password, this, arguments);
    };

    subclass(Password, DefaultSimple);

    /**
     * Default 'Password' instance.
     * @type {Password}
     */
    Password.DEFAULT = new Password();

    /**
     * Decode a `Password` from a `String`.
     *
     * @param {String} str
     * @returns {Password}
     */
    Password.prototype.decodeFromString = function (str) {
      var s;
      if (str) {
        s = new Password(str);
        s.getType = this.getType;
        return s;
      }
      return Password.DEFAULT;
    };

    /**
     * Override toString() to return a default string representation for passwords
     * @returns {String} Default string representation
     */
    Password.prototype.toString = function () {
      return "--password--";
    };

    return Password;
  });
