/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.FileNavContainer}.
 * @module baja/nav/FileNavContainer
 */
define(["bajaScript/sys",
        "bajaScript/baja/nav/NavNodeContainer"], function (
        baja,
        NavNodeContainer) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Represents a Station's root File System in BajaScript.
   *
   * @class
   * @alias module:baja/nav/FileNavContainer
   * @extends baja.NavContainer
   */   
  var FileNavContainer = function FileNavContainer() {
    callSuper(FileNavContainer, this, [{
      navName: "file",
      icon: "module://icons/x16/drive.png",
      ord: "local:|file:^"
    }]);
  };
  
  subclass(FileNavContainer, NavNodeContainer);

  return FileNavContainer;
});