/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jslint white: true */
/*global define */

define(["bajaScript/comm",
        "bajaScript/baja/comm/Callback",
        "bajaPromises"], function (baja, Callback, Promise) {
  
  "use strict";
    
  function setContextInOkCallback(comp, cb) {
    cb.addOk(function (ok, fail, resp) {
      ok.call(comp, resp);
    });
  }
  
  function setContextInFailCallback(comp, cb) {
    cb.addFail(function (ok, fail, err) {
      fail.call(comp, err);
    });
  }
  
  function unlease(comp) { 
    // Reset lease
    comp.$lease = false;
    comp.$leaseTicket.cancel();
  
    if (comp.$subDf) {
      comp.$subDf.promise().finally(function () {
        if (canUnsubscribe(comp)) {
          delete comp.$subDf;
          comp.$space.getCallbacks().unsubscribe(["h:" + comp.$handle], new Callback());
        } 
      });
    }
  }

  function canUnsubscribe(comp) {
    return comp.$subDf &&
           !Promise.isRejected(comp.$subDf.promise()) &&
           !comp.isSubscribed() &&
            comp.isMounted() &&
            comp.$space.hasCallbacks();
  }
  
  return {
    setContextInOkCallback: setContextInOkCallback,
    setContextInFailCallback: setContextInFailCallback,
    unlease: unlease,
    canUnsubscribe: canUnsubscribe
  };
});