/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Struct}.
 * @module baja/comp/Struct
 */
define(["bajaScript/sys",
        "bajaScript/baja/comp/Complex"], 
        function (baja, Complex) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Represents a `baja:Struct` in BajaScript.
   * 
   * `Struct` is the base class for a component which has
   * one or more properties.  `Struct`s must only declare
   * properties which are typed as boolean, int, float,
   * String, Simple, or other `Struct`s.  This means
   * that a `Struct` may never have a `Component` property.
   * `Struct`s only support `Property` slots, never `Action`s or `Topic`s.
   * 
   * A `Struct` can only contain frozen Slots. A frozen Slot is defined
   * at compile time (usually hard coded in Java).
   *
   * @see baja.Component
   * @class
   * @alias baja.Struct
   * @extends baja.Complex
   */
  var Struct = function Struct() {  
    callSuper(Struct, this, arguments); 
  };
  
  subclass(Struct, Complex);
  
  return Struct;
});