/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines a `PropertyAction` (not exposed on `baja` namespace).
 * @module baja/comp/PropertyAction
 */
define(["bajaScript/sys",
        "bajaScript/baja/comp/DynamicProperty"], 
        function (baja, DynamicProperty) {
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * `PropertyAction` Slot.
   * 
   * A `Property` that is also an `Action`. Typically this is used for dynamic Actions.
   * 
   * A new object should never be directly created with this Constructor. All Slots are 
   * created internally by BajaScript.
   * 
   * @class
   * @alias module:baja/comp/PropertyAction
   * @extends module:baja/comp/DynamicProperty
   */
  var PropertyAction = function PropertyAction(slotName, displayName, display, flags, facets, value) {
    callSuper(PropertyAction, this, arguments);
  };
  
  subclass(PropertyAction, DynamicProperty);
   
  /**
   * Is the Slot an Action? Yes.
   *
   * @returns {Boolean}
   */   
  PropertyAction.prototype.isAction = function () {
    return true;
  };
  
  /**
   * Return the Action's parameter Type.
   *
   * @returns {Type} the parameter type (or null if the Action doesn't have a parameter).
   */
  PropertyAction.prototype.getParamType = function () {
    return this.$val.getParamType();
  };
  
  /**
   * Return the Action's parameter default value.
   *
   * @returns {baja.Value} the parameter default value (or null if the 
   * Action doesn't have a parameter).
   */
  PropertyAction.prototype.getParamDefault = function () {
    return this.$val.getParamDefault();
  };
  
  /**
   * Return the Action's return Type.
   *
   * @returns {Type} the return type (or null if the Action doesn't have a return Type).
   */
  PropertyAction.prototype.getReturnType = function () {
    return this.$val.getReturnType();
  }; 

  return PropertyAction;
});