/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Host}.
 * @module baja/comp/Host
 */
define(["bajaScript/nav"], function (baja) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Represents a `baja:Host` in BajaScript.
   * 
   * @class
   * @alias baja.Host
   * @extends baja.NavContainer
   */  
  var Host = function Host() { 
    callSuper(Host, this, arguments);
  };
  
  subclass(Host, baja.NavContainer);
  
  /**
   * Return a `Host`'s Absolute ORD. May be session-aware.
   *
   * @private
   *
   * @param {object} [params]
   * @param {boolean} [params.sessionAware]
   * @returns {baja.Ord}
   * @see baja.NavContainer#getNavOrd
   */
  Host.prototype.getAbsoluteOrd = function (params) {
    /*
     * This differs from the Java version. In Java, getAbsoluteOrd gets
     * overridden per host. In practice, there is no difference between absolute
     * and nav ORD for a Host. But in BajaScript we need the sessionAware flag,
     * so baja.nav.localhost could be "local:" if we only care about the
     * browser, or "ip:1.2.3.4" if we are in Workbench and want to know what
     * station we're talking to. So we appropriate the sessionAware flag from
     * NavContainer#getNavOrd so we can make this distinction.
     */
    return this.getNavOrd(params);
  };
  
  return Host;
});
