/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.comm.ServerError}.
 * @module baja/comm/ServerError
 */
define(["bajaScript/baja/sys/inherit"], function (inherit) {
  "use strict";
  
  var subclass = inherit.subclass,
      defaultErrorMessage = "Default Message";
  
  /**
   * A Server Error.
   * 
   * @class
   * @alias baja.comm.ServerError
   * @private
   * @extends Error
   * @param [message] the error message
   */ 
   var ServerError = function ServerError(message) {
     Error.call(this, message);
     this.name = "ServerError";
     this.message = message || defaultErrorMessage;
   };
   
   subclass(ServerError, Error);
   
   return ServerError;
});