/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jslint white: true */
/*global define */

/**
 * @module baja/boxcs/RemoveRelationKnobOp
 * @private
 */
define(["bajaScript/sys",
        "bajaScript/baja/boxcs/SyncOp"], 
        function (baja, SyncOp) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * @class Remove Relation Knob SyncOp.
   *
   * @name RemoveRelationKnobOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function RemoveRelationKnobOp() {
    callSuper(RemoveRelationKnobOp, this, arguments);
    throw new Error("Unsupported");
  }
  
  subclass(RemoveRelationKnobOp, SyncOp); 
  
  RemoveRelationKnobOp.id = "n";
  
  /**
   * Decode and commit the SyncOp.
   *
   * @private
   *
   * @param comp the Component the knob will be added too.
   * @param sp the syncOp data structure to be decoded.
   */
  RemoveRelationKnobOp.decodeAndCommit = function (comp, sp) {  
    if (comp !== null) {
      comp.$fw("uninstallRelationKnob", sp.id, { 
        commit: true, 
        serverDecode: true 
      });    
    }
  };
  
  return RemoveRelationKnobOp;
});