/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/LoadOp
 * @private
 */
define(["bajaScript/bson",
        "bajaScript/baja/boxcs/SyncOp",
        "bajaScript/baja/boxcs/syncUtil"], 
        function (baja, SyncOp, syncUtil) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper,
      
      serverDecodeContext = baja.$serverDecodeContext,
      importUnknownTypes = baja.bson.importUnknownTypes,
      bsonDecodeValue = baja.bson.decodeValue,
      
      syncComp = syncUtil.syncComp;
  
  /**
   * @class Load a Component's Slots SyncOp.
   *
   * @name LoadOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function LoadOp() {
    callSuper(LoadOp, this, arguments);   
  }
  
  subclass(LoadOp, SyncOp); 
  
  LoadOp.id = "l";
  
  /**
   * Decode and commit the SyncOp.
   *
   * @name LoadOp.decodeAndCommit
   * @function
   * @private
   *
   * @param comp the Component to be loaded.
   * @param sp the syncOp data structure to be decoded.
   */
  LoadOp.decodeAndCommit = function (comp, sp) {  
    if (comp !== null) {
      return importUnknownTypes(sp.b)
        .then(function () {
          // Synchronize the two components together      
          syncComp(bsonDecodeValue(sp.b, serverDecodeContext), comp);
        });
    }
  };
  
  return LoadOp;
});