/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/BogSpace
 * @private
 */
define([
  "bajaScript/bson",
  "bajaScript/baja/boxcs/BoxComponentSpace",
  "bajaScript/baja/comm/Callback",
  "bajaScript/baja/comp/compUtil" ], function (
    baja,
    BoxComponentSpace,
    Callback,
    compUtil) {
  
  "use strict";
  
  /**
   * BOG Component Space.
   *
   * A Component Space that's loaded from a BOG file.
   * 
   * @class
   * @name baja.BogSpace
   * @extends baja.BoxComponentSpace
   * @private
   *
   * @param {String} name
   * @param {String} ordInSession
   * @param host
   */  
  function BogSpace(name, ordInSession, host) {
    baja.callSuper(BogSpace, this, arguments);
  }
  
  baja.subclass(BogSpace, BoxComponentSpace); 

  /**
   * Save the BOG file.
   *
   * @param {Object} [obj] An object literal containing the method arguments.
   * @param {Function} [obj.ok] (Deprecated: use Promise) The ok callback. This
   * function is called once the BOG file has been saved.
   * @param {Function} [obj.fail] (Deprecated: use Promise) The fail callback.
   * This function is called if the BOG file fails to save.
   * @param {baja.comm.Batch} [obj.batch] if defined, any network calls will be
   * batched into this object.
   * @returns {Promise} A promise that's resolved after the BOG file is saved.
   */
  BogSpace.prototype.save = function (obj) {
    obj = baja.objectify(obj);

    var cb = new Callback(obj.ok, obj.fail, obj.batch),
        that = this;

    // Ensure 'this' is Component in callbacks...
    compUtil.setContextInOkCallback(that, cb);
    compUtil.setContextInFailCallback(that, cb);

    baja.comm.serverHandlerCall(that, "save", null, cb);

    return cb.promise();
  };

  return BogSpace;
});
