/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetNullEditor
 */
define([
  'baja!',
  'nmodule/webEditors/rc/fe/baja/BaseEditor',
  'jquery',
  'Promise',
  'nmodule/webEditors/rc/fe/fe',
  'bajaux/events'], function
  (baja,
   BaseEditor,
   $,
   Promise,
   fe,
   events) {

  'use strict';

  var NULL_STR = 'NULL';

  var DESTROY_EVENT    = events.DESTROY_EVENT,
      INITIALIZE_EVENT = events.INITIALIZE_EVENT,
      LOAD_EVENT       = events.LOAD_EVENT,
      ENABLE_EVENT     = events.ENABLE_EVENT,
      DISABLE_EVENT    = events.DISABLE_EVENT,
      MODIFY_EVENT     = events.MODIFY_EVENT,
      READONLY_EVENT   = events.READONLY_EVENT,
      WRITABLE_EVENT   = events.WRITABLE_EVENT;

  /**
   * View an object of bacnet:BacnetNull as a read only text field with the value NULL
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/bacnet/rc/fe/BacnetNullEditor
   */
  var BacnetNullEditor = function BacnetNullEditor() {
    BaseEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  BacnetNullEditor.prototype             = Object.create(BaseEditor.prototype);
  BacnetNullEditor.prototype.constructor = BacnetNullEditor;

  /**
   * Initialize the editor with a string field contaning a read-only 'NULL' value.
   *
   * @param {dom} element the DOM element into which to load this widget
   */
  BacnetNullEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on([
      DESTROY_EVENT,
      INITIALIZE_EVENT,
      LOAD_EVENT,
      ENABLE_EVENT,
      DISABLE_EVENT,
      READONLY_EVENT,
      WRITABLE_EVENT
    ].join(' '), '.editor', false);

    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });

    return Promise.resolve(fe.buildFor({
      value: NULL_STR,
      dom: $('<div class="js-null"/>').appendTo(dom),
      readonly: true,
      formFactor: 'mini'
    }));
  };

  /**
   * Enables or disables the editor.
   *
   * @param {Boolean} enabled
   */
  BacnetNullEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  BacnetNullEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Returns the BacnetNull editor widget
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the null editor
   */
  BacnetNullEditor.prototype.$getNullEditor = function () {
    return this.jq().children('.js-null').data('widget');
  };

  return BacnetNullEditor;
});
