/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/datatypes/BacnetAny
 */
define(['baja!'], function (
        baja) {

  'use strict';

  var Component = baja.Component,

      // [0] Choice
      // [1] Type
      // [2] Lex - lex lookup entry
      // [3] Text - default text if no lex entry is found
      TYPE_MAP = [
        [ 0, 'bacnet:BacnetNull', 'bacnetAny.BacnetNull', 'NULL'],
        [ 1, 'baja:Boolean', 'bacnetAny.Boolean', 'BOOLEAN'],
        [ 2, 'bacnet:BacnetUnsigned', 'bacnetAny.BacnetUnsigned', 'Unsigned'],
        [ 3, 'baja:Integer', 'bacnetAny.Integer', 'INTEGER'],
        [ 4, 'baja:Float', 'bacnetAny.Float', 'REAL'],
        [ 5, 'baja:Double', 'bacnetAny.Double', 'Double'],
        [ 6, 'bacnet:BacnetOctetString', 'bacnetAny.BacnetOctetString', 'OCTET STRING'],
        [ 7, 'baja:String', 'bacnetAny.String', 'CharacterString'],
        [ 8, 'bacnet:BacnetBitString', 'bacnetAny.BacnetBitString', 'BIT STRING'],
        [ 9, 'baja:DynamicEnum', 'bacnetAny.DynamicEnum', 'ENUMERATED'],
        [ 10, 'bacnet:BacnetDate', 'bacnetAny.BacnetDate', 'Date'],
        [ 11, 'bacnet:BacnetTime', 'bacnetAny.BacnetTime', 'Time'],
        [ 12, 'bacnet:BacnetObjectIdentifier', 'bacnetAny.BacnetObjectIdentifier', 'BacnetObjectIdentifier']
      ];

  /**
   * BajaScript representation of a `bacnet:BacnetAny`.
   * @class
   * @alias module:nmodule/bacnet/rc/datatypes/BacnetAny
   * @extends baja.Component
   */
  var BacnetAny = function BacnetAny() {
    Component.apply(this, arguments);
  };
  BacnetAny.prototype = Object.create(Component.prototype);
  BacnetAny.prototype.constructor = BacnetAny;

  /**
   * Return the toString of the value slot.
   *
   * @returns {String}
   */
  BacnetAny.prototype.toString = function () {
    var value = this.get('value');
    return String(value);
  };

  BacnetAny.prototype.TYPE_MAP = TYPE_MAP;

  return BacnetAny;
});
