/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetAveraging
 */
define(['nmodule/bacnet/rc/baja/BacnetObject',
        'nmodule/webEditors/rc/baja/bajaUtils'], function (
         BacnetObject,
         bajaUtils) {

  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetAveraging` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/BacnetObject}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetAveraging}
   */
  var BacnetAveraging = function BacnetAveraging() {
    BacnetObject.apply(this, arguments);
    proxySlotFacets(this, {
      '^(minimum|average|maximum|variance)Value$': 'facets'
    });
  };
  BacnetAveraging.prototype = Object.create(BacnetObject.prototype);
  BacnetAveraging.prototype.constructor = BacnetAveraging;

  return BacnetAveraging;
});
