/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetAnalogOutput
 */
define(['nmodule/bacnet/rc/baja/config/BacnetAnalog',
        'nmodule/webEditors/rc/baja/bajaUtils'], function (
         BacnetAnalog,
         bajaUtils) {

  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetAnalogOutput` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/config/BacnetAnalog}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetAnalogOutput}
   */
  var BacnetAnalogOutput = function BacnetAnalogOutput() {
    BacnetAnalog.apply(this, arguments);
    proxySlotFacets(this, {
      '^priorityArray|relinquishDefault$': 'facets'
    });
  };
  BacnetAnalogOutput.prototype = Object.create(BacnetAnalog.prototype);
  BacnetAnalogOutput.prototype.constructor = BacnetAnalogOutput;

  return BacnetAnalogOutput;
});
