/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Raymond A. Richards
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 * @since Niagara 4.2
 */

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("nmodule/bacnet/rc/util/BacnetConst",["lex!bacnet"],function(e){"use strict";var t={},n=e[0];return t.ASN_NULL=0,t.ASN_BOOLEAN=1,t.ASN_UNSIGNED=2,t.ASN_INTEGER=3,t.ASN_REAL=4,t.ASN_DOUBLE=5,t.ASN_OCTECT_STRING=6,t.ASN_CHARACTER_STRING=7,t.ASN_BIT_STRING=8,t.ASN_ENUMERATED=9,t.ASN_DATE=10,t.ASN_TIME=11,t.ASN_OBJECT_IDENTIFIER=12,t.ASHRAE_RESERVED_13=13,t.ASHRAE_RESERVED_14=14,t.ASHRAE_RESERVED_15=15,t.ASN_CONSTRUCTED_DATA=-1,t.ASN_BACNET_ARRAY=-2,t.ASN_BACNET_LIST=-3,t.ASN_ANY=-4,t.ASN_CHOICE=-5,t.ASN_UNKNOWN_PROPRIETARY=-6,t.ASHRAE_PREFIX=n.get("enum.ashrae"),t.PROPRIETARY_PREFIX=n.get("enum.proprietary"),t}),define("nmodule/bacnet/rc/baja/enums/BacnetObjectType",["baja!","underscore","nmodule/bacnet/rc/util/BacnetConst"],function(e,t,n){"use strict";var r=e.FrozenEnum,o=[],a=t.range(0,25).concat([40,46]),i=function(){r.apply(this,arguments)};return i.prototype=Object.create(r.prototype),i.prototype.constructor=i,i.make=function(){var e=i.DEFAULT;return e.make.apply(e,arguments)},i.DEFAULT=new i,i.getObjectIdFacets=function(n){if(!e.hasType(n,"baja:Number"))throw new Error("ordinal required");if(!t.contains(a,n))return null;var r=o[n];if(!r){var c=i.DEFAULT.getRange().getTag(n);r=e.Facets.make({range:e.EnumRange.make({ordinals:[n],tags:[c]})}),o[n]=r}return r},i.isProprietary=function(e){return e>127&&e<=1023},i.isAshrae=function(e){var t=i.DEFAULT.getRange(),n=t.getOrdinals();return e>n[n.length-1]&&e<=127},i.tagForId=function(e){return i.DEFAULT.getRange().isOrdinal(e)?i.DEFAULT.make(e).getTag():i.isAshrae(e)?n.ASHRAE_PREFIX+e:i.isProprietary(e)?n.PROPRIETARY_PREFIX+e:"INVALID:"+e},i.idForTag=function(e){return i.DEFAULT.getRange().isTag(e)?i.DEFAULT.make(e).getOrdinal():0===e.indexOf(n.ASHRAE_PREFIX)?parseInt(e.substring(n.ASHRAE_PREFIX.length),10):0===e.indexOf(n.PROPRIETARY_PREFIX)?parseInt(e.substring(n.PROPRIETARY_PREFIX.length),10):-1},i}),define("nmodule/bacnet/rc/baja/util/BacnetBitStringUtil",["baja!","lex!bacnet","underscore"],function(e,t,n){"use strict";function r(t){var r=["bsName"],a=[t],i=parseInt(o.get(t+".numBits"),10);return isNaN(i)?null:(n.each(n.range(0,i),function(e){r.push("bit"+e),a.push(o.get(t+".bit"+e))}),e.Facets.make(r,a))}var o=t[0],a={},i={};return i.getBitStringFacets=function(e){var t=a[e];return t||(t=a[e]=r(e)),t},i.getNumBits=function(e,t){return t&&"bsName"in t?parseInt(o.get(t.bsName+".numBits"),10):e.getNumBits()},i.getBitLabel=function(e,t,n){var r="bit"+n;if(t){if(r in t)return t[r];if("bsName"in t)return o.get(t.bsName+"."+r)}return r},i}),define("nmodule/bacnet/rc/baja/BacnetObject",["baja!","underscore","nmodule/bacnet/rc/baja/enums/BacnetObjectType","nmodule/bacnet/rc/baja/util/BacnetBitStringUtil","nmodule/webEditors/rc/baja/bajaUtils","nmodule/webEditors/rc/fe/baja/util/compUtils"],function(e,t,n,r,o,a){"use strict";function i(e){return e.get("enumerationList").get("objectTypeFacets")}var c=e.Component,s=r.getBitStringFacets,u=o.proxySlotFacets,d=a.closest,l=t.once(function(){return{statusFlags:s("BacnetStatusFlags"),eventEnable:s("BacnetEventTransitionBits"),ackedTransitions:s("BacnetEventTransitionBits"),limitEnable:s("BacnetLimitEnable")}}),p=function(){c.apply(this,arguments),u(this,l())};return p.prototype=Object.create(c.prototype),p.prototype.constructor=p,p.prototype.device=function(){var t=d(this,"bacnet:BacnetConfigDeviceExt");if(t){var n=t.getParent();if(e.hasType(n,"bacnet:BacnetDevice"))return n}return null},p.prototype.getFacets=function(e){var t,r;switch(String(e)){case"objectId":if(this.isMounted()){if(t=n.getObjectIdFacets(this.get("objectType").getOrdinal()))return t;if(r=this.device())return i(r)}break;case"objectType":if(r=this.device())return i(r)}return c.prototype.getFacets.apply(this,arguments)},p}),define("nmodule/bacnet/rc/baja/config/BacnetAnalog",["nmodule/bacnet/rc/baja/BacnetObject","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^presentValue|highLimit|lowLimit|deadband|resolution|covIncrement$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetAnalogOutput",["nmodule/bacnet/rc/baja/config/BacnetAnalog","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^priorityArray|relinquishDefault$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetAveraging",["nmodule/bacnet/rc/baja/BacnetObject","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^(minimum|average|maximum|variance)Value$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetBinary",["nmodule/bacnet/rc/baja/BacnetObject","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^(alarm|feedback|present)Value|relinquishDefault$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetBinaryOutput",["nmodule/bacnet/rc/baja/config/BacnetBinary","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^priorityArray$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetMultistate",["nmodule/bacnet/rc/baja/BacnetObject","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^presentValue$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/config/BacnetSchedule",["nmodule/bacnet/rc/baja/BacnetObject","nmodule/webEditors/rc/baja/bajaUtils"],function(e,t){"use strict";var n=t.proxySlotFacets,r=function(){e.apply(this,arguments),n(this,{"^presentValue$":"facets"})};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r}),define("nmodule/bacnet/rc/baja/datatypes/BacnetAddress",["baja!","bajaScript/baja/obj/objUtil","underscore"],function(e,t,n){"use strict";function r(e){e=255&(e||0);var t=e.toString(16);return 1===t.length&&(t="0"+t),t.toUpperCase()}function o(e,t){return e=e||[],n.map(e,r).join(t)}function a(e){return e<0}var i=e.Struct,c=/^([0-9A-Fa-f]{1,2}[:-]){5}([0-9A-Fa-f]{1,2})$/,s=/^(-)?\d+$/,u=new RegExp(["^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}","(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(:0x[0-9A-Fa-f]{1,4})?$"].join("")),d=function(){i.apply(this,arguments)};return d.prototype=Object.create(i.prototype),d.prototype.constructor=d,d.bytesToString=function(e,t){if(!t||!t.length)return"null";switch(e){case 1:if(6!==t.length)throw new Error("Invalid Ethernet MAC address!");return o(t,":");case 2:if(t.length<4||t.length>4&&6!==t.length)throw new Error("Invalid IP MAC address!");var r,a="";return t.length>=4&&(a=n.map(t.slice(0,4),function(e){return 255&e}).join(".")),6===t.length&&(r=(255&t[4])<<8|255&t[5],a=a+":0x"+r.toString(16).toUpperCase()),a;default:return 1===t.length?(255&t[0]).toString():o(t," ")}},d.stringToBytes=function(e,t,r){if(!r||!r.length||"null"===r)return null;var o,i;switch(e){case 1:if(!r.match(c))throw new Error("Invalid Ethernet MAC Address!");if(o=r.split(/[:\s]/),6!==o.length)throw new Error("Invalid Ethernet MAC Address!");if(i=n.map(o,function(e){return parseInt(e,16)}),n.some(i,a))throw new Error("Invalid Ethernet MAC Address!");return i;case 2:if(!r.match(u))throw new Error("Invalid BACnet/IP MAC Address!");if(o=r.split(/[.:\s]/),o.length!==t)throw new Error("Invalid BACnet/IP MAC Address!");if(o.length>=4){if(i=n.map(o.slice(0,4),function(e){return parseInt(e,10)}),n.some(i,a))throw new Error("Invalid BACnet/IP MAC Address!");switch(o.length){case 4:return i;case 5:var d=parseInt(o[4],16);if(d<0)throw new Error("Invalid BACnet/IP MAC Address!");return i.concat([d>>8&255,255&d]);default:throw new Error("Invalid length for conversion of BACnet/IP MAC address!")}}break;default:if(o=r.split(/[:\s]/),1===o.length){if(!r.match(s))throw new Error("Invalid BACnet/IP MSTP Address!");return[255&parseInt(o[0],10)]}return n.map(o,function(e){return parseInt(e,16)})}},d.convertMacAddress=function(e,t){if(!t||"null"===t)return t;var a;switch(e){case 1:return-1===t.indexOf(".")?n.map(t.split(/[:\s]/),function(e){return e.toUpperCase()}).join(":"):(a=t.split(/[.:\s]/),a.length<5?t:n.map(a,function(e,t){if(4===t){var n=parseInt(e,16);return o([n>>8,255&n],":")}return r(parseInt(e,10))}).join(":"));case 2:if(-1===t.indexOf(".")){if(a=t.split(/[:\s]/),a.length<6)return t;var i=n.map(a.slice(0,4),function(e){return parseInt(e,16)}).join(".");i+=":0x";var c=(255&parseInt(a[4],16))<<8;return c|=255&parseInt(a[5],16),i+=c.toString(16).toUpperCase()}return t;default:return-1===t.indexOf(".")?(a=t.split(/[:\s]/),n.map(a,function(e){return e.toUpperCase()}).join(" ")):(a=t.split(/[.:]/),a.length<5?t:n.map(a,function(e,t){if(4===t){var n=parseInt(e,16);return o([n>>8&255,255&n]," ").toUpperCase()}return r(parseInt(e)).toUpperCase()}).join(" "))}},d.prototype.toString=function(){function e(e){return 255&e}var t=this,r=t.getNetworkNumber()+":",a=t.getMacAddress().getBytes();if(0===a.length)r+="null";else switch(t.getAddressType()){case 2:r+=n.map(a.slice(0,4),function(t){return e(t)}).join(".")+":"+(e(a[4])<<8|e(a[5]));break;case 3:case 0:case 1:r+=o(a," ").toLowerCase()}return r},d.MAC_TYPE_UNKNOWN=0,d.MAC_TYPE_ETHERNET=1,d.MAC_TYPE_IP=2,d.MAC_TYPE_MSTP=3,e.registerType("bacnet:BacnetAddress",function(){return d}),d}),define("nmodule/bacnet/rc/baja/datatypes/BacnetAny",["baja!"],function(e){"use strict";var t=e.Component,n=[[0,"bacnet:BacnetNull","bacnetAny.BacnetNull","NULL"],[1,"baja:Boolean","bacnetAny.Boolean","BOOLEAN"],[2,"bacnet:BacnetUnsigned","bacnetAny.BacnetUnsigned","Unsigned"],[3,"baja:Integer","bacnetAny.Integer","INTEGER"],[4,"baja:Float","bacnetAny.Float","REAL"],[5,"baja:Double","bacnetAny.Double","Double"],[6,"bacnet:BacnetOctetString","bacnetAny.BacnetOctetString","OCTET STRING"],[7,"baja:String","bacnetAny.String","CharacterString"],[8,"bacnet:BacnetBitString","bacnetAny.BacnetBitString","BIT STRING"],[9,"baja:DynamicEnum","bacnetAny.DynamicEnum","ENUMERATED"],[10,"bacnet:BacnetDate","bacnetAny.BacnetDate","Date"],[11,"bacnet:BacnetTime","bacnetAny.BacnetTime","Time"],[12,"bacnet:BacnetObjectIdentifier","bacnetAny.BacnetObjectIdentifier","BacnetObjectIdentifier"]],r=function(){t.apply(this,arguments)};return r.prototype=Object.create(t.prototype),r.prototype.constructor=r,r.prototype.toString=function(){var e=this.get("value");return String(e)},r.prototype.TYPE_MAP=n,r}),define("nmodule/bacnet/rc/baja/datatypes/BacnetBitString",["baja!"],function(e){"use strict";var t=e.Simple,n=function(){t.apply(this,arguments)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.make=function(e,t){var r=new n;return r.$bits=void 0===e?"":e,r.$tags=void 0===t?"":t,r},n.prototype.make=function(){return n.make.apply(n,arguments)},n.prototype.decodeFromString=function(e){if(!e||""===e)return n.DEFAULT;var t=e.split(":");return n.make.apply(null,t)},n.prototype.encodeToString=function(){return this.$bits+":"+this.$tags},n.prototype.toString=function(e){return this.$bits},n.prototype.getNumBits=function(){return this.$bits.length},n.prototype.isBitSet=function(e){return"1"===this.$bits.charAt(e)},n.DEFAULT=n.make(),e.registerType("bacnet:BacnetBitString",function(){return n}),n}),define("nmodule/bacnet/rc/baja/datatypes/BacnetDate",["baja!","underscore","bajaScript/baja/obj/objUtil","lex!bacnet"],function(e,t,n,r){"use strict";function o(e,t,n){return!isNaN(e)&&(e>=t&&e<=n||e===i)}var a=e.Simple,i=-1,c=r[0],s=n.cacheDecode,u=n.cacheEncode,d=["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],l=function(){a.apply(this,arguments)};return l.prototype=Object.create(a.prototype),l.prototype.constructor=l,l.make=function(e,t,n,r){if(e=parseInt(e,10),t=parseInt(t,10),n=parseInt(n,10),r=parseInt(r,10),!o(e,1900,2154))throw new Error(c.get("BacnetDate.invalid.year",e));if(!o(t,1,14))throw new Error(c.get("BacnetDate.invalid.month",t));if(!o(n,1,34))throw new Error(c.get("BacnetDate.invalid.dom",n));if(!o(r,1,7))throw new Error(c.get("BacnetDate.invalid.dow"));var a=new l;return a.$year=e,a.$month=t,a.$dayOfMonth=n,a.$dayOfWeek=r,a},l.prototype.make=function(){return l.make.apply(l,arguments)},l.prototype.getYear=function(){return this.$year===i?i:this.$year},l.prototype.getMonth=function(){return this.$month},l.prototype.getDayOfMonth=function(){return this.$dayOfMonth},l.prototype.getDayOfWeek=function(){return this.$dayOfWeek},l.prototype.equals=function(t){return!!e.hasType(t,"bacnet:BacnetDate")&&(this.getYear()===t.getYear()&&this.getMonth()===t.getMonth()&&this.getDayOfMonth()===t.getDayOfMonth()&&this.getDayOfWeek()===t.getDayOfWeek())},l.makeFromJsDate=function(e){if(e){var t=e.getFullYear(),n=e.getMonth()+1,r=e.getDate(),o=e.getDay()||7;return l.make(t,n,r,o)}return l.DEFAULT},l.prototype.getJsDate=function(){return this.$isAnyUnspecified()||this.$isSpecialDay()||this.$isSpecialMonth()?new Date:new Date(this.getYear(),this.getMonth()-1,this.getDayOfMonth())},l.prototype.decodeFromString=s(function(e){var t=/\*/;if(!e||"****-**-**-***"===e)return l.DEFAULT;var n=e.split("-");if(4!==n.length)throw new Error("Incorrect Encoding: "+e);var r=n[0];r=r.match(t)?i:parseInt(n[0],10);var o=n[1].toUpperCase();o=o.match(t)?i:"EV"===o?14:"OD"===o?13:parseInt(n[1],10);var a=n[2].toUpperCase();a=a.match(t)?i:"LD"===a?32:"OD"===a?33:"ED"===a?34:parseInt(n[2],10);var c=n[3];return c=c.match(t)?i:l.weekday(n[3]),l.make(r,o,a,c)}),l.prototype.encodeToString=u(function(){var e="",t=this.getYear(),n=this.getMonth(),r=this.getDayOfMonth(),o=this.getDayOfWeek();return e+=t===i?"****-":t+"-",e+=n===i?"**-":14===n?"EV-":13===n?"OD-":n<10?"0"+n+"-":n+"-",e+=r===i?"**-":32===r?"LD-":33===r?"OD-":34===r?"ED-":r<0?"0"+r+"-":r+"-",e+=o===i?"***":d[o-1]}),l.DEFAULT=l.make(i,i,i,i),l.weekday=function(e){return t.indexOf(d,e)+1},l.prototype.$isAnyUnspecified=function(){return this.$year===i||this.$month===i||this.$dayOfMonth===i||this.$dayOfWeek===i},l.prototype.$isSpecialMonth=function(){var e=this.$month;return 13===e||14===e},l.prototype.$isSpecialDay=function(){var e=this.$dayOfMonth;return 33===e||34===e||32===e},l}),define("nmodule/bacnet/rc/baja/datatypes/BacnetObjectIdentifier",["baja!","bajaScript/baja/obj/objUtil","nmodule/bacnet/rc/baja/enums/BacnetObjectType","lex!bacnet","baja!bacnet:BacnetObjectType"],function(e,t,n,r){"use strict";var o=r[0],a=e.Simple,i=t.cacheDecode,c=t.cacheEncode,s=function(){a.apply(this,arguments)};return s.prototype=Object.create(a.prototype),s.prototype.constructor=s,s.make=function(e,t){var n=parseInt(e,10),r=parseInt(t,10);if(isNaN(n)||n<0)throw new Error(o.get("BacnetObjectIdentifier.invalid.objectType"));if(isNaN(r)||r>4194303)throw new Error(o.get("bacnetObjectIdentifier.invalidInstanceNumber"));var a=new s;return a.$objType=n,a.$inst=r,a},s.prototype.make=function(){return s.make.apply(s,arguments)},s.prototype.decodeFromString=i(function(e){if(!e)return s.DEFAULT;var t=e.split(":");return s.make(n.idForTag(t[0]),t[1])}),s.prototype.encodeToString=c(function(){return n.tagForId(this.$objType)+":"+this.$inst}),s.prototype.getObjectType=function(){return this.$objType},s.prototype.getInstanceNumber=function(){return this.$inst},s.DEFAULT=s.make(0,-1),e.registerType("bacnet:BacnetObjectIdentifier",function(){return s}),s}),define("nmodule/bacnet/rc/baja/datatypes/BacnetOctetString",["baja!","bajaScript/baja/obj/objUtil","underscore"],function(e,t,n){"use strict";function r(e){e=255&(e||0);var t=e.toString(16);return 1===t.length&&(t="0"+t),t}function o(e,t){return e=e||[],n.map(e,r).join(t)}function a(e){return parseInt(e,16)}var i=e.Simple,c=function(e){i.apply(this,arguments),this.$bytes=e||[]};return c.prototype=Object.create(i.prototype),c.prototype.constructor=c,c.make=function(e){return new c(e)},c.prototype.make=function(e){return c.make(e)},c.prototype.encodeToString=function(){return this.$bytes.length?o(this.$bytes," "):"null"},c.prototype.decodeFromString=function(e){if(!e||"null"===e)return c.DEFAULT;var t=n.map(e.split(" "),a);return new c(t)},c.prototype.getBytes=function(){return n.clone(this.$bytes)},c.DEFAULT=new c,e.registerType("bacnet:BacnetOctetString",function(){return c}),c}),define("nmodule/bacnet/rc/baja/datatypes/BacnetRecipient",["baja!"],function(e){"use strict";var t=e.Struct,n=function(){t.apply(this,arguments)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.prototype.toString=function(){var e=this;return 0===e.get("choice").valueOf()?e.get("device").toString():e.get("address").toString()},n.DEVICE=0,n.ADDRESS=1,n}),define("nmodule/bacnet/rc/baja/datatypes/BacnetScale",["baja!"],function(e){"use strict";function t(e){return e%1==0}var n=e.Struct,r=function(){n.apply(this,arguments)};return r.prototype=Object.create(n.prototype),r.prototype.constructor=r,r.prototype.toString=function(){var e=this.get("choice").valueOf(),n=this.get("scale");return 0===e?t(n)?n+".0":String(n):n.valueOf().toFixed(0)},r}),define("nmodule/bacnet/rc/baja/datatypes/BacnetTime",["baja!","bajaScript/baja/obj/objUtil"],function(e,t){"use strict";function n(e,t){return!isNaN(e)&&(e>=i&&e<=t||255===e)}var r=e.Simple,o=t.cacheDecode,a=t.cacheEncode,i=-1,c=function(){r.apply(this,arguments)};return c.prototype=Object.create(r.prototype),c.prototype.constructor=c,c.make=function(e,t,r,o){if(e=parseInt(e,10),t=parseInt(t,10),r=parseInt(r,10),o=parseInt(o,10),!n(e,23))throw new Error("BBacnetTime: invalid hour:"+e);if(!n(t,59))throw new Error("BBacnetTime: invalid minute:"+t);if(!n(r,59))throw new Error("BBacnetTime: invalid second:"+r);if(!n(o,99))throw new Error("BBacnetTime: invalid hundredth:"+o);var a=new c;return a.$hour=e,a.$minute=t,a.$second=r,a.$hundredth=o,a},c.prototype.make=function(){return c.make.apply(c,arguments)},c.prototype.decodeFromString=o(function(e){if(!e||""===e||"**:**:**.**"===e)return c.DEFAULT;if(!/^(\*{2}|\d|0\d|1?\d|2[0-3]):(\*{2}|([0-5]?\d)):(\*{2}|([0-5]?\d)).(\*{2}|(\d?\d))$/.test(e))throw new Error("Incorrect encoding");var t=e.split(":"),n="**"===t[0]?i:t[0],r="**"===t[1]?i:t[1],o=t[2].split("."),a="**"===o[0]?i:o[0],s="**"===o[1]?i:o[1];return c.make(n,r,a,s)}),c.prototype.encodeToString=a(function(){var e="";return e+=this.$hour===i?"**:":(this.$hour<10?"0"+this.$hour:this.$hour)+":",e+=this.$minute===i?"**:":(this.$minute<10?"0"+this.$minute:this.$minute)+":",e+=this.$second===i?"**.":(this.$second<10?"0"+this.$second:this.$second)+".",e+=this.$hundredth===i?"**":this.$hundredth<10?"0"+this.$hundredth:this.$hundredth}),c.prototype.getHour=function(){return this.$hour},c.prototype.getMinute=function(){return this.$minute},c.prototype.getSecond=function(){return this.$second},c.prototype.getHundredth=function(){return this.$hundredth},c.DEFAULT=c.make(i,i,i,i),e.registerType("bacnet:BacnetTime",function(){return c}),c}),define("nmodule/bacnet/rc/baja/datatypes/BacnetUnsigned",["baja!"],function(e){"use strict";var t=e.Simple,n=function n(r){if(!e.hasType(r,"baja:Number")||isNaN(r.valueOf()))throw new Error("Number required");if(r>n.MAX_VALUE)throw new Error("Value must be <= "+n.MAX_VALUE);t.apply(this,arguments),this.$long=Math.floor(r)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.make=function(e){switch(Math.floor(e)){case 0:return n.DEFAULT;case 1:return n.ONE;case 2:return n.TWO;default:return new n(e)}},n.prototype.make=function(e){return n.make(e)},n.prototype.encodeToString=function(){return String(this.$long)},n.prototype.decodeFromString=function(e){return new n(parseInt(e))},n.prototype.valueOf=function(){return this.$long},n.prototype.toString=function(t){var n=t&&t.range;return n?e.SlotPath.unescape(n.getTag(this.$long)):String(this.valueOf())},n.DEFAULT=new n(0),n.ONE=new n(1),n.TWO=new n(2),n.MIN_VALUE=0,n.MAX_VALUE=4294967295,n}),define("nmodule/bacnet/rc/baja/datatypes/DiscoveryNetworks",["baja!","underscore"],function(e,t){"use strict";var n=e.Simple,r=function(){n.apply(this,arguments)};return r.prototype=Object.create(n.prototype),r.prototype.constructor=r,r.make=function(e,t){var n=new r;return n.$nets=t?t.slice():[],n.$all=!!e,n},r.prototype.encodeToString=function(){return(this.$all?"all;":"-;")+this.$nets.join(",")},r.prototype.decodeFromString=function(e){var n,o,a;return e?(n=/^all;/.test(e),a=e.match(/^(?:all|-);(.+)/),a&&a.length>1&&(o=t.map(a[1].split(","),function(e){return parseInt(e)})),r.make(n,o)):r.DEFAULT},r.prototype.isAllNetworks=function(){return this.$all},r.prototype.getNetworks=function(){return this.$nets.slice()},r.prototype.contains=function(e){return t.indexOf(this.$nets,e)>-1},r.DEFAULT=r.make(!1,[]),r}),define("nmodule/bacnet/rc/baja/enums/BacnetPropertyIdentifier",["baja!","nmodule/bacnet/rc/util/BacnetConst"],function(e,t){"use strict";function n(){var e=o.DEFAULT.getRange().getOrdinals();return e[e.length-1]}var r=e.FrozenEnum,o=function(){r.apply(this,arguments)};return o.prototype=Object.create(r.prototype),o.prototype.constructor=o,o.make=function(){var e=o.DEFAULT;return e.make.apply(e,arguments)},o.DEFAULT=new o,o.isProprietary=function(e){return e>511&&e<=4194303},o.isAshrae=function(e){return e>n()&&e<=511},o.isValid=function(e){return e<=4194303},o.isFixed=function(e){return e<=n()},o.tagForId=function(e){return o.DEFAULT.getRange().isOrdinal(e)?o.DEFAULT.getRange().getTag(e):o.isAshrae(e)?t.ASHRAE_PREFIX+e:o.isProprietary(e)?t.PROPRIETARY_PREFIX+e:"Invalid ID"},o.idForTag=function(e){return o.DEFAULT.getRange().isTag(e)?o.DEFAULT.make(e).getOrdinal():0===e.indexOf(t.ASHRAE_PREFIX)?parseInt(e.substring(t.ASHRAE_PREFIX.length),10):0===e.indexOf(t.PROPRIETARY_PREFIX)?parseInt(e.substring(t.PROPRIETARY_PREFIX.length),10):-1},o}),define("nmodule/bacnet/rc/baja/enums/ExtensibleEnumList",["baja!","baja!bacnet:BacnetErrorClass,bacnet:BacnetErrorCode,bacnet:BacnetAbortReason,bacnet:BacnetDeviceStatus,bacnet:BacnetEngineeringUnits,bacnet:BacnetEventState,bacnet:BacnetEventType,bacnet:BacnetLifeSafetyMode,bacnet:BacnetLifeSafetyOperation,bacnet:BacnetLifeSafetyState,bacnet:BacnetMaintenance,bacnet:BacnetObjectType,bacnet:BacnetProgramError,bacnet:BacnetPropertyIdentifier,bacnet:BacnetReliability,bacnet:BacnetRejectReason,bacnet:BacnetSilencedState,bacnet:BacnetVtClass"],function(e){"use strict";function t(e){return e.get("range")}var n=e.Struct,r=function(){n.apply(this,arguments)};return r.prototype=Object.create(n.prototype),r.prototype.constructor=r,r.prototype.getEnumRange=function(e){var n=this;if(e)switch(String(e)){case"bacnet:BacnetErrorClass":return t(n.getErrorClassFacets());case"bacnet:BacnetErrorCode":return t(n.getErrorCodeFacets());case"bacnet:BacnetAbortReason":return t(n.getAbortReasonFacets());case"bacnet:BacnetDeviceStatus":return t(n.getDeviceStatusFacets());case"bacnet:BacnetEngineeringUnits":return t(n.getEngineeringUnitsFacets());case"bacnet:BacnetEventState":return t(n.getEventStateFacets());case"bacnet:BacnetEventType":return t(n.getEventTypeFacets());case"bacnet:BacnetLifeSafetyMode":return t(n.getLifeSafetyModeFacets());case"bacnet:BacnetLifeSafetyOperation":return t(n.getLifeSafetyOperationFacets());case"bacnet:BacnetLifeSafetyState":return t(n.getLifeSafetyStateFacets());case"bacnet:BacnetMaintenance":return t(n.getMaintenanceFacets());case"bacnet:BacnetObjectType":return t(n.getObjectTypeFacets());case"bacnet:BacnetProgramError":return t(n.getProgramErrorFacets());case"bacnet:BacnetPropertyIdentifier":return t(n.getPropertyIdFacets());case"bacnet:BacnetReliability":return t(n.getReliabilityFacets());case"bacnet:BacnetRejectReason":return t(n.getRejectReasonFacets());case"bacnet:BacnetSilencedState":return t(n.getSilencedStateFacets());case"bacnet:BacnetVtClass":return t(n.getVtClassFacets());default:return null}return null},r}),define("nmodule/bacnet/rc/baja/job/DiscoveryPoint",["baja!","underscore","nmodule/bacnet/rc/baja/enums/BacnetPropertyIdentifier"],function(e,t,n){"use strict";var r=function(){e.Component.apply(this,arguments)};return r.prototype=Object.create(e.Component.prototype),r.prototype.constructor=r,r.prototype.getPropertyId=function(){var e=this.getPropertyIdentifier();if(!e)return-1;try{return n.idForTag(e)}catch(e){return-1}},r.prototype.getPropertyArrayIndex=function(){var e,t=this.getIndex();return t?(e=parseInt(t),isNaN(e)?-1:e):-1},r.prototype.hasChildren=function(){var e=this.getPointType();return 0===e||2===e},r.prototype.getPoints=function(){return this.getSlots().properties().is("bacnet:DiscoveryPoint").toValueArray()},r.prototype.toString=function(){var e=this;return"DiscPt:"+e.getObjectName()+"["+e.getObjectId()+"]:"+e.getPropertyIdentifier()+"{"+e.getIndex()+"}="+e.getValue()+"; f="+e.getFacets()+"; t="+e.getPointType()},r}),define("nmodule/bacnet/rc/baja/point/BacnetProxyExt",["nmodule/driver/rc/baja/ProxyExt","nmodule/webEditors/rc/fe/baja/util/compUtils"],function(e,t){"use strict";var n=t.closest,r=function(){e.apply(this,arguments)};return r.prototype=Object.create(e.prototype),r.prototype.constructor=r,r.prototype.getFacets=function(t){if(this.isMounted()){var r=n(this,"bacnet:BacnetDevice");if(r){var o=r.get("enumerationList");switch(String(t)){case"objectId":return o.get("objectTypeFacets");case"propertyId":return o.get("propertyIdFacets")}}}return e.prototype.getFacets.apply(this,arguments)},r}),define("nmodule/bacnet/rc/baja/util/BacnetDateUtil",["lex!baja","underscore"],function(e,t){"use strict";var n=e[0],r=["monday.short","tuesday.short","wednesday.short","thursday.short","friday.short","saturday.short","sunday.short"],o=["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],a={};return a.getDisplayBacnetDateString=function(e){if(e){var n=e.substring(e.lastIndexOf("-")+1),i=e.substring(0,e.lastIndexOf("-")),c=t.findIndex(o,function(e){return e===n});if(-1!==c)return i+"-"+a.$getLocalizedShortDayOfWeek(r[c])}return e},a.$getLocalizedShortDayOfWeek=function(e){return n.get(e)},a.getEncodedBacnetDateString=function(e){if(e){var n=e.substring(e.lastIndexOf("-")+1),i=e.substring(0,e.lastIndexOf("-")),c=t.findIndex(r,function(e){return a.$getLocalizedShortDayOfWeek(e)===n});if(-1!==c)return i+"-"+o[c]}return e},a}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetAddressEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<table>\n    <tr>\n        <td class="netLabel">'+e.escapeExpression((a=null!=(a=i(n,"netLabel")||(null!=t?i(t,"netLabel"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"netLabel",hash:{},data:o,loc:{start:{line:3,column:29},end:{line:3,column:41}}}):a))+"</td>\n        <td class="+e.escapeExpression((a=null!=(a=i(n,"networkNumber")||(null!=t?i(t,"networkNumber"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"networkNumber",hash:{},data:o,loc:{start:{line:4,column:18},end:{line:4,column:35}}}):a))+'></td>\n    </tr>\n    <tr>\n        <td class="macLabel">'+e.escapeExpression((a=null!=(a=i(n,"macLabel")||(null!=t?i(t,"macLabel"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"macLabel",hash:{},data:o,loc:{start:{line:7,column:29},end:{line:7,column:41}}}):a))+"</td>\n        <td class="+e.escapeExpression((a=null!=(a=i(n,"macAddress")||(null!=t?i(t,"macAddress"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"macAddress",hash:{},data:o,loc:{start:{line:8,column:18},end:{line:8,column:32}}}):a))+'></td>\n    </tr>\n    <tr>\n        <td class="styleLabel">'+e.escapeExpression((a=null!=(a=i(n,"styleLabel")||(null!=t?i(t,"styleLabel"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"styleLabel",hash:{},data:o,loc:{start:{line:11,column:31},end:{line:11,column:45}}}):a))+"</td>\n        <td class="+e.escapeExpression((a=null!=(a=i(n,"addressType")||(null!=t?i(t,"addressType"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"addressType",hash:{},data:o,loc:{start:{line:12,column:18},end:{line:12,column:33}}}):a))+"></td>\n    </tr>\n</table>\n\n"},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetAddressEditor",t),t}),define("nmodule/bacnet/rc/fe/MacAddressEditor",["baja!","baja!bacnet:BacnetOctetString","lex!bacnet","jquery","Promise","underscore","nmodule/webEditors/rc/fe/baja/StringEditor","nmodule/bacnet/rc/baja/datatypes/BacnetAddress","nmodule/bacnet/rc/baja/datatypes/BacnetOctetString"],function(e,t,n,r,o,a,i,c,s){"use strict";var u=c.stringToBytes,d=c.bytesToString,l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.$getMacAddress=function(){return this.$getTextElement().val()},l.prototype.doLoad=function(t){var n,r,a;return e.hasType(t,"bacnet:BacnetOctetString")?(n=t.getBytes(),r=this.properties().getValue("addressType"),a=null!==r?d(r,n):"",i.prototype.doLoad.call(this,a)):o.reject("Expected type bacnet:BacnetOctetString")},l.prototype.doRead=function(){var e,t,n,r,o=this.properties().getValue("addressType"),a=this.$getMacAddress();return null!==o?(e=o===c.MAC_TYPE_IP,t=e&&-1!==a.indexOf(":"),n=t?5:e?4:0,r=u(o,n,a),s.make(r)):s.make()},l}),define("nmodule/bacnet/rc/fe/BacnetAddressEditor",["baja!","baja!bacnet:BacnetAddress,bacnet:BacnetOctetString","bajaux/events","hbs!nmodule/bacnet/rc/fe/templates/BacnetAddressEditor","jquery","lex!bacnet","nmodule/bacnet/rc/baja/datatypes/BacnetAddress","nmodule/bacnet/rc/baja/datatypes/BacnetOctetString","nmodule/bacnet/rc/fe/MacAddressEditor","nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor","nmodule/webEditors/rc/fe/baja/OrderedMapEditor","nmodule/webEditors/rc/fe/fe","Promise","underscore"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m){"use strict";var g=a[0],b=g.get({key:"bacnetAddress.networkNumber",def:"Network Number"}),f=g.get({key:"bacnetAddress.macAddress",def:"MAC Address"}),y=g.get({key:"bacnetAddress.macStyle",def:"MAC Address Style"}),h=i.MAC_TYPE_UNKNOWN,v=i.MAC_TYPE_MSTP,E=[{key:"bacnetAddress.macType.Unknown",def:"Unknown"},{key:"bacnetAddress.macType.Ethernet",def:"Ethernet"},{key:"bacnetAddress.macType.IP",def:"IP"},{key:"bacnetAddress.macType.MSTP",def:"MSTP/Other"}],T=m.map(E,function(e){return g.get(e)}),j=function(){u.apply(this,arguments)};return j.prototype=Object.create(u.prototype),j.prototype.constructor=j,j.prototype.$getNetworkNumberLabel=function(){return this.jq().find(".netLabel").text()},j.prototype.$getMacAddressLabel=function(){return this.jq().find(".macLabel").text()},j.prototype.$getMacStyleLabel=function(){return this.jq().find(".styleLabel").text()},j.prototype.$getNetworkNumberEditor=function(){return this.jq().find(".networkNumber").data("widget")},j.prototype.$getMacAddressEditor=function(){return this.jq().find(".macAddress").data("widget")},j.prototype.$getMacStyleEditor=function(){return this.jq().find(".addressType").data("widget")},j.prototype.doInitialize=function(e){var t=this;return e.addClass("BacnetAddressEditor").html(r({netLabel:b,macLabel:f,styleLabel:y,networkNumber:"networkNumber",macAddress:"macAddress",addressType:"addressType"})),e.on(n.MODIFY_EVENT,".addressType",function(e,n){var r,o=n,a=o&&o.getSelectedValue(),c=t.$getMacAddressEditor(),s=c&&c.$getMacAddress();null!==s&&null!==a&&(c.properties().setValue("addressType",a),r=i.convertMacAddress(a,s),c.$getTextElement().val(r),c.setModified(!0))}),
u.prototype.doInitialize.apply(this,arguments)},j.prototype.doLoad=function(t){if(!e.hasType(t,"bacnet:BacnetAddress"))throw new Error("editor must be loaded with bacnet:BacnetAddress");var n=this,r=t.getMacAddress(),o=t.getAddressType(),a=r.getBytes(),i=a.length?1===a.length?v:o:h;return u.prototype.doLoad.apply(this,arguments).then(function(){n.$getMacStyleEditor().setSelectedValue(i)})},j.prototype.doRead=function(){var e=this;return u.prototype.doRead.apply(this,arguments).then(function(t){return t.apply(e.value().newCopy())})},j.prototype.getSlotFilter=function(){return["networkNumber",{slot:"macAddress",type:s},{slot:"addressType",type:d}]},j.prototype.makeBuilder=function(){var t=this,n=u.prototype.makeBuilder.apply(this,arguments),r=n.getValueFor,o=new e.OrderedMap;return m.each(T,function(e,t){o.put(e,t)}),n.getDomFor=function(e){return t.jq().find("."+e)},n.getValueFor=function(e){switch(e){case"addressType":return o;case"macAddress":var t=this.getEditorFor(e),n=this.getDataSource(),a=n.getAddressType(),i=n.getMacAddress();return t&&t.properties().add("addressType",a),i;default:return r.apply(this,arguments)}},n},j}),define("nmodule/bacnet/rc/fe/BacnetAnyEditor",["baja!","bajaux/events","bajaux/mixin/batchSaveMixin","bajaux/mixin/subscriberMixIn","lex!bacnet","nmodule/bacnet/rc/baja/datatypes/BacnetAny","nmodule/webEditors/rc/fe/fe","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/OrderedMapEditor","Promise","underscore","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i,c,s,u,d){"use strict";var l=o[0],p=a.prototype.TYPE_MAP,m=t.MODIFY_EVENT,g=function(){var t=new e.OrderedMap;return d.each(p,function(e){var n=e[0],r=e[2],o=e[3];t.put(l.get({key:r,def:o}),n)}),t}(),b=function(){c.apply(this,arguments),n(this),r(this)};return b.prototype=Object.create(c.prototype),b.prototype.constructor=b,b.prototype.doInitialize=function(t){var n=this;return t.html('<div class="js-choice"/><div class="js-value"/>'),t.on(m,".editor",function(){return n.setModified(!0),!1}),t.on(m,".js-choice",function(){var t=n.$getChoiceEditor().getSelectedValue();n.$getValueEditor().read().then(function(e){return n.$loadAny(t,e)}).catch(e.error)}),i.buildFor({dom:t.children(".js-choice"),formFactor:"mini",type:s,value:g})},b.prototype.doLoad=function(e){return this.$loadAny(e.get("choice"),e.get("value"))},b.prototype.doRead=function(){return this.getChildEditors().readAll().spread(function(t,n){return e.$("bacnet:BacnetAny",{choice:t,value:n})})},b.prototype.doSave=function(e,t){var r=this,o=r.value(),a=t&&t.batch,i=t&&t.progressCallback,c=u.all([o.set({slot:"choice",value:e.get("choice"),batch:a}),o.set({slot:"value",value:e.get("value"),batch:a})]);return i&&i(n.COMMIT_READY),c},b.prototype.doEnabled=function(e){return this.getChildEditors().setAllEnabled(e)},b.prototype.doReadonly=function(e){return this.getChildEditors().setAllReadonly(e)},b.prototype.doDestroy=function(){return this.getChildEditors().destroyAll()},b.prototype.$loadAny=function(t,n){var r=this,o=r.$getValueEditor(),a=p[t][1];t=t.valueOf();var c=e.hasType(n,a)?n:e.importTypes([a]).then(function(){return e.$(a)});return u.join(c,o&&o.destroy()).spread(function(e){return r.$getChoiceEditor().setSelectedValue(t,!0),i.buildFor({value:e,formFactor:"mini",dom:r.$getValueElement()})})},b.prototype.$getChoiceEditor=function(){return this.$getChoiceElement().data("widget")},b.prototype.$getValueEditor=function(){return this.$getValueElement().data("widget")},b.prototype.$getChoiceElement=function(){return this.jq().children(".js-choice")},b.prototype.$getValueElement=function(){return this.jq().children(".js-value")},b}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetBitStringEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){return'<table class="ux-table no-stripe">\n  <tbody>\n  </tbody>\n</table>\n'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetBitStringEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetBitStringEditor",["baja!","bajaux/Widget","jquery","underscore","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor","nmodule/bacnet/rc/baja/datatypes/BacnetBitString","nmodule/bacnet/rc/baja/util/BacnetBitStringUtil","hbs!nmodule/bacnet/rc/fe/templates/BacnetBitStringEditor","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i,c,s){"use strict";var u=function(e){var r=this;r.$bitIds=[],o.call(r,n.extend({keyName:"BacnetBitStringEditor"},e)),r.getFormFactor()===t.formfactor.mini&&r.$makeDisplayOnly()};return u.prototype=Object.create(o.prototype),u.prototype.constructor=u,u.prototype.$makeDisplayOnly=function(){a.$mixin(this)},u.prototype.doInitialize=function(e){var t=this;e.html(s({})),e.on("change","input",function(){t.setModified(!0)})},u.prototype.doLoad=function(e){var t=this,o=this.properties(),a=c.getNumBits(e,o.toValueMap()),i=t.jq().children("table").children("tbody");t.$numBits=a,r.each(r.range(a),function(r){var a=t.generateId(),s=n('<input type="checkbox">').prop("id",a).prop("checked",e.isBitSet(r)),u=n("<label></label>").prop("for",a).text(c.getBitLabel(e,o.toValueMap(),r));t.$bitIds[r]=a,i.append(n("<tr>").append(n("<td>").append(s.add(u))))})},u.prototype.doRead=function(){var e=this,t="";return e.jq().children("table").find("input").each(function(e){var n=this.checked?"1":"0";t+=n}),i.make(t)},u.prototype.valueToString=function(e){return String(e)},u.prototype.setBit=function(e,t,n){void 0===t&&(t=!0);var r=this.jq().find("#"+this.$getBitId(e)),o=r.prop("checked",!!t);n&&o.trigger("change")},u.prototype.$getBitId=function(e){return this.$bitIds[e]},u.prototype.getLabelElement=function(e){return this.jq().children("table").find('label[for="'+this.$getBitId(e)+'"]')},u.prototype.doEnabled=function(e){this.jq().children("table").find("input").prop("disabled",this.isReadonly()||!e)},u.prototype.doReadonly=function(e){this.jq().children("table").find("input").prop("disabled",!this.isEnabled()||e)},u}),define("nmodule/bacnet/rc/fe/BacnetWeekNDayEditor",["baja!","lex!bacnet","underscore","nmodule/bacnet/rc/baja/datatypes/BacnetOctetString","nmodule/webEditors/rc/fe/CompositeEditor","nmodule/webEditors/rc/fe/baja/OrderedMapEditor","nmodule/webEditors/rc/fe/config/CompositeBuilder","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i){"use strict";var c=t[0],s=["month","week","day"],u=function(t){var r;"month"===t&&(r=[-1].concat(n.range(1,15))),"week"===t&&(r=[-1].concat(n.range(1,7))),"day"===t&&(r=[-1].concat(n.range(1,8)));var o=s.indexOf(t),a=new e.OrderedMap;return n.each(r,function(e){a.put(c.get("weekNDay.b"+o+"."+e),e)}),a},d=n.once(function(){return u("month")}),l=n.once(function(){return u("week")}),p=n.once(function(){return u("day")}),m=function(){o.apply(this,arguments)};return m.prototype=Object.create(o.prototype),m.prototype.constructor=m,m.prototype.makeBuilder=function(){var e=this,t=new i;return t.getDomFor=function(t){return e.jq().children(".js-"+t)},t.getKeys=function(){return s.slice()},t.getValueFor=function(e){switch(e){case"month":return d();case"week":return l();case"day":return p()}},t.getConfigFor=function(e){return{type:a}},t},m.prototype.doInitialize=function(e){return e.html('<span class="js-month"/><span class="js-week"/><span class="js-day"/>'),o.prototype.doInitialize.apply(this,arguments)},m.prototype.doLoad=function(e){var t=this,r=e.getBytes().length;if(r<3)throw new Error("Invalid bit string length for WeekNDay: "+r);return o.prototype.doLoad.apply(t,arguments).then(function(){var r=t.getChildWidgets(),o=e.getBytes();n.each(r,function(e,t){e.setSelectedValue(o[t])})})},m.prototype.doRead=function(){return this.getChildWidgets().readAll().then(r.make)},m}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetCalendarEntryEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<div class="editors bce">\n  <div class="bce-option toggleCommandGrp" />\n  <hr>\n  <div class="bce-date">\n    <div style="display:inline-block">'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"date"):a,t))+':</div>\n    <div class="bce-dt"></div>\n  </div>\n  <div class="bce-dr">\n    <table>\n      <tbody>\n        <tr><td class="bce-dt-lbl">'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"startDate"):a,t))+':</td><td><div class="bce-dr-ds"/></td></tr>\n        <tr><td class="bce-dt-lbl">'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"endDate"):a,t))+':</td><td><div class="bce-dr-de"/></td></tr>\n      </tbody>\n    </table>\n  </div>\n  <div class="bce-wad" />\n</div>'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetCalendarEntryEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetCalendarEntryEditor",["Promise","baja!","jquery","bajaux/Widget","bajaux/events","bajaux/mixin/batchSaveMixin","nmodule/webEditors/rc/util/htmlUtils","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/fe/fe","bajaux/util/CommandButtonGroup","bajaux/commands/ToggleCommandGroup","nmodule/bacnet/rc/fe/BacnetWeekNDayEditor","lex!bacnet","hbs!nmodule/bacnet/rc/fe/templates/BacnetCalendarEntryEditor"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m,g,b){"use strict";var f=i.escapeHtml,y=u.bulkCopy,h=g[0],v=o.DESTROY_EVENT,E=o.INITIALIZE_EVENT,T=o.LOAD_EVENT,j=o.ENABLE_EVENT,w=o.DISABLE_EVENT,S=o.MODIFY_EVENT,A=o.READONLY_EVENT,B=o.WRITABLE_EVENT,N=function(e){var t=this;c.apply(this,arguments),t.getFormFactor()===r.formfactor.mini?s.$mixin(this):(a(this),t.$toggleCmdGrp=new p({onChange:function(e){t.$toggleDisplay(e)},commands:[{module:"bacnet",lex:"BacnetCE.commands.toggle.date",value:0},{module:"bacnet",lex:"BacnetCE.commands.toggle.dateRange",value:1},{module:"bacnet",lex:"BacnetCE.commands.toggle.weekNDay",value:2}]}))};return N.prototype=Object.create(c.prototype),N.prototype.constructor=N,N.prototype.valueToString=function(e){var n="";if(t.hasType(e,"bacnet:BacnetCalendarEntry")){var r=e.getDisplay();if(r)n=r.substring(r.indexOf(":")+3);else switch(e.getChoice()){case 0:n=e.getDate().encodeToString();break;case 1:var o=e.getDateRange();n=o.getStartDate().encodeToString()+";"+o.getEndDate().encodeToString();break;case 2:n=e.getWeekNDay().encodeToString()}}return f(n||"")},N.prototype.$getToggleCommandGroup=function(){return this.$toggleCmdGrp},N.prototype.$getDateToggleCommand=function(){return this.$getToggleCommandGroup().get(0)},N.prototype.$getDateRangeToggleCommand=function(){return this.$getToggleCommandGroup().get(1)},N.prototype.$getWeeknDayToggleCommand=function(){return this.$getToggleCommandGroup().get(2)},N.prototype.doInitialize=function(r){var o=this;return r.on([v,E,T,j,w,A,B].join(" "),".editor",!1),r.on(S,".bajaux-initialized",function(){return o.setModified(!0),!1}),r.html(b({labels:{date:h.get("BacnetCE.editor.label.date"),startDate:h.get("BacnetCE.editor.label.startDate"),endDate:h.get("BacnetCE.editor.label.endDate")}})),e.join(d.buildFor({dom:n(".toggleCommandGrp",r),type:l,value:o.$getToggleCommandGroup(),initializeParams:{toggleGroup:!0},formFactor:"mini"}),d.buildFor({value:t.$("bacnet:BacnetDate"),dom:o.jq().find(".bce-dt"),formFactor:"mini"}),d.buildFor({value:t.$("bacnet:BacnetDate"),dom:o.jq().find(".bce-dr-ds"),formFactor:"mini"}),d.buildFor({value:t.$("bacnet:BacnetDate"),dom:o.jq().find(".bce-dr-de"),formFactor:"mini"}),d.buildFor({value:t.$("bacnet:BacnetOctetString",[0,0,0]),type:m,dom:o.jq().find(".bce-wad"),formFactor:"mini"}))},N.prototype.doLoad=function(e){var t=this,n=e&&e.getChoice();switch(t.$toggleDisplay(n),n){case 0:return t.$getDateToggleCommand().setSelected(!0),t.$loadDate(e.getDate());case 1:return t.$getDateRangeToggleCommand().setSelected(!0),t.$loadDateRange(e.getDateRange());case 2:return t.$getWeeknDayToggleCommand().setSelected(!0),t.$loadWeeknDay(e.getWeekNDay())}},N.prototype.$loadDate=function(e){return this.jq().find(".bce-dt").data("widget").load(e||t.$("bacnet:BacnetDate"))},N.prototype.$loadDateRange=function(n){return e.join(this.jq().find(".bce-dr-ds").data("widget").load(n.getStartDate()||t.$("bacnet:BacnetDate")),this.jq().find(".bce-dr-de").data("widget").load(n.getEndDate()||t.$("bacnet:BacnetDate")))},N.prototype.$loadWeeknDay=function(e){return this.jq().find(".bce-wad").data("widget").load(t.$("bacnet:BacnetOctetString",e.getBytes())||t.$("bacnet:BacnetOctetString",[0,0,0]))},N.prototype.doRead=function(){var e=this,n=parseInt(e.$getToggleCommandGroup().getSelectedValue(),10);return e.getChildEditors().readAll().spread(function(e,r,o,a){var i=t.$("bacnet:BacnetCalendarEntry");switch(n){case 0:i.setDate(e),i.setChoice(0);break;case 1:i.getDateRange().setStartDate(r),i.getDateRange().setEndDate(o),i.setChoice(1);break;case 2:i.setWeekNDay(a),i.setChoice(2)}return i})},N.prototype.doSave=function(t,n){var r,o,i=n&&n.batch,c=this.value(),s=n&&n.progressCallback,u=t,d=c;switch(t.get("choice").valueOf()){case 0:r=["date"];break;case 1:u=t.get("dateRange"),d=c.get("dateRange"),r=["startDate","endDate"];break;case 2:r=["weekNDay"]}return o=e.join(y(t,c,["choice"],i),y(u,d,r,i)),s&&s(a.COMMIT_READY),o},N.prototype.$toggleDisplay=function(e){var t=this.jq().find(".bce-date"),n=this.jq().find(".bce-dr"),r=this.jq().find(".bce-wad");switch(e){case 0:n.hide(),r.hide(),t.show();break;case 1:t.hide(),r.hide(),n.show();break;case 2:t.hide(),n.hide(),r.show()}},N.prototype.doReadonly=function(e){return this.getChildWidgets().setAllReadonly(e)},N.prototype.doEnabled=function(e){return this.getChildWidgets().setAllEnabled(e)},N.prototype.doDestroy=function(){return this.getChildWidgets().destroyAll()},N}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetDateEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){return'<div class="editors">\n  <div class="js-bacDate editor"></div>\n  <div class="commands"/>\n</div>\n'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetDateEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetDateEditor",["baja!","jquery","Promise","underscore","nmodule/bacnet/rc/baja/datatypes/BacnetDate","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/fe","bajaux/events","bajaux/commands/Command","bajaux/util/CommandButtonGroup","nmodule/webEditors/rc/wb/commands/DatePickerPopupCommand","hbs!nmodule/bacnet/rc/fe/templates/BacnetDateEditor","nmodule/bacnet/rc/baja/util/BacnetDateUtil","css!nmodule/bacnet/rc/bacnet","baja!baja:Weekday"],function(e,t,n,r,o,a,i,c,s,u,d,l,p){"use strict";var m=c.DESTROY_EVENT,g=c.INITIALIZE_EVENT,b=c.LOAD_EVENT,f=c.ENABLE_EVENT,y=c.DISABLE_EVENT,h=c.MODIFY_EVENT,v=c.READONLY_EVENT,E=c.WRITABLE_EVENT,T=function(e){s.call(this,{module:"bacnet",lex:"BacnetEd.asteriskCommand",func:function(){return e.setModified(!0),e.doLoad(o.DEFAULT)}})};T.prototype=Object.create(s.prototype),T.prototype.constructor=T;var j=function(t){d.call(this);var n=this.getFunction();this.setFunction(function(){return n().then(function(n){return e.Date.make({jsDate:n}).toDateString({textPattern:"YYYY-MM-DD-W"}).then(function(e){return t.setModified(!0),t.$getDateInput().load(e)})})})};j.prototype=Object.create(s.prototype),j.prototype.constructor=j;var w=function(){var e=this;a.apply(this,arguments),e.getCommandGroup().add(new T(e),new j(e))};return w.prototype=Object.create(a.prototype),w.prototype.constructor=w,w.prototype.$getDateInput=function(){return this.jq().find(".js-bacDate").data("widget")},w.prototype.$getAsteriskCommand=function(){return this.getCommandGroup().get(0)},w.prototype.$getCalendarCommand=function(){return this.getCommandGroup().get(1)},w.prototype.$getBacnetDateDisplayString=function(e){return p.getDisplayBacnetDateString(e.encodeToString())},w.prototype.doInitialize=function(e){var r=this;return e.html(l()),e.on([m,g,b,f,y,v,E].join(" "),".editor",!1),e.on(h,".editor",function(){return r.setModified(!0),!1}),n.join(i.buildFor({dom:t(".js-bacDate",r.jq()),value:o.DEFAULT.encodeToString(),properties:{uxFieldEditor:"webEditors:StringEditor"},formFactor:"mini"}),i.buildFor({dom:t(".commands",r.jq()),type:u,value:this.getCommandGroup(),properties:{toolbar:!0},formFactor:"mini"}))},w.prototype.doLoad=function(e){return this.$getDateInput().load(this.$getBacnetDateDisplayString(e))},w.prototype.doRead=function(){return this.$getDateInput().read().then(function(e){return e?o.DEFAULT.decodeFromString(p.getEncodedBacnetDateString(e)):o.DEFAULT})},w.prototype.doEnabled=function(e){return this.getChildWidgets().setAllEnabled(e)},w.prototype.doReadonly=function(e){return this.getChildWidgets().setAllReadonly(e)},w.prototype.doDestroy=function(){return this.getChildWidgets().destroyAll()},w}),define("nmodule/bacnet/rc/fe/BacnetNullEditor",["baja!","nmodule/webEditors/rc/fe/baja/BaseEditor","jquery","Promise","nmodule/webEditors/rc/fe/fe","bajaux/events"],function(e,t,n,r,o,a){"use strict";var i=a.DESTROY_EVENT,c=a.INITIALIZE_EVENT,s=a.LOAD_EVENT,u=a.ENABLE_EVENT,d=a.DISABLE_EVENT,l=a.MODIFY_EVENT,p=a.READONLY_EVENT,m=a.WRITABLE_EVENT,g=function(){t.apply(this,arguments)};return g.prototype=Object.create(t.prototype),g.prototype.constructor=g,g.prototype.doInitialize=function(e){var t=this;return e.on([i,c,s,u,d,p,m].join(" "),".editor",!1),e.on(l,".editor",function(){return t.setModified(!0),!1}),r.resolve(o.buildFor({value:"NULL",dom:n('<div class="js-null"/>').appendTo(e),readonly:!0,formFactor:"mini"}))},g.prototype.doEnabled=function(e){return this.getChildEditors().setAllEnabled(e)},g.prototype.doDestroy=function(){return this.getChildEditors().destroyAll()},g.prototype.$getNullEditor=function(){return this.jq().children(".js-null").data("widget")},g}),define("nmodule/bacnet/rc/fe/BacnetObjectIdEditor",["baja!","jquery","nmodule/webEditors/rc/fe/baja/BaseEditor","underscore","Promise","nmodule/webEditors/rc/fe/fe","nmodule/bacnet/rc/baja/datatypes/BacnetObjectIdentifier","bajaux/events","baja!bacnet:BacnetObjectType"],function(e,t,n,r,o,a,i,c){"use strict";var s=c.DESTROY_EVENT,u=c.INITIALIZE_EVENT,d=c.LOAD_EVENT,l=c.ENABLE_EVENT,p=c.DISABLE_EVENT,m=c.MODIFY_EVENT,g=c.READONLY_EVENT,b=c.WRITABLE_EVENT,f=function(){n.apply(this,arguments)};return f.prototype=Object.create(n.prototype),f.prototype.constructor=f,f.prototype.doInitialize=function(n){var r=this;return n.on([s,u,d,l,p,g,b].join(" "),".editor",!1),n.on(m,".editor",function(){return r.setModified(!0),!1}),o.join(a.buildFor({dom:t('<span class="js-objType" />').appendTo(n),value:e.DynamicEnum.make({range:e.$("bacnet:BacnetObjectType").getRange()}),formFactor:"mini"}),a.buildFor({dom:t('<span class="js-instance" />').appendTo(n),value:e.Integer.DEFAULT,formFactor:"mini"}))},f.prototype.doLoad=function(t){var n,r=this,a=this.properties().getValue("range");return n=a?e.DynamicEnum.make({ordinal:t.getObjectType(),range:a}):e.DynamicEnum.make({ordinal:t.getObjectType(),range:e.$("bacnet:BacnetObjectType").getRange()}),o.join(r.$getSelect().load(n),r.$getInstanceInput().load(t.getInstanceNumber()))},f.prototype.doRead=function(){return o.join(this.$getSelect().read(),this.$getInstanceInput().read()).spread(function(t,n){return e.$("bacnet:BacnetObjectIdentifier",t.getOrdinal(),n)})},f.prototype.doReadonly=function(e){return o.join(this.$getSelect().setReadonly(e),this.$getInstanceInput().setReadonly(e))},f.prototype.doEnabled=function(e){return o.join(this.$getSelect().setEnabled(e),this.$getInstanceInput().setEnabled(e))},f.prototype.doDestroy=function(){return this.getChildWidgets().destroyAll()},f.prototype.$getSelect=function(){return this.jq().children(".js-objType").data("widget")},f.prototype.$getInstanceInput=function(){return this.jq().children(".js-instance").data("widget")},f}),define("nmodule/bacnet/rc/fe/BacnetPriorityValueEditor",["baja!","lex!bacnet","bajaux/events","bajaux/mixin/batchSaveMixin","jquery","Promise","underscore","nmodule/js/rc/switchboard/switchboard","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/util/typeUtils","nmodule/webEditors/rc/fe/fe","nmodule/webEditors/rc/servlets/registry","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i,c,s,u,d,l){"use strict";var p={"bacnet:BacnetNull":"NULL","baja:Float":"Real","baja:Double":"Double","bacnet:BacnetBinaryPv":"Binary","bacnet:BacnetUnsigned":"Integer","baja:String":"String"},m=function(){s.apply(this,arguments),r(this),c(this,{$initSubEditor:{allow:"oneAtATime",onRepeat:"preempt"}})};return m.prototype=Object.create(s.prototype),m.prototype.constructor=m,m.prototype.doInitialize=function(t){var r=this,a=i.map(p,function(e,t){return o('<option class="ux-option"/>').val(t).text(e)});t.append('<select class="ux-select js-type"/>'),t.append('<div class="js-subEditor"/>'),r.$getSelect().html(a),t.on("change","select.js-type",function(){return r.setModified(!0),r.$initSubEditor().catch(e.error),!1}),t.on(n.MODIFY_EVENT,".editor",function(){return r.setModified(!0),!1})},m.prototype.$initSubEditor=function(){var t=this,n=t.$getSubEditor();return a.join(u.importTypes(t.$getSelect().val()),n&&n.destroy()).spread(function(n){return d.buildFor({value:e.$(n),dom:o(".js-subEditor",t.jq()),formFactor:"mini"})})},m.prototype.doLoad=function(e){var t=this,n=e.get("value").getType().getTypeSpec();if(!p[n])throw new Error("Cannot load BacnetPriorityValue, unsupported primitive type: "+n);return t.$getSelect().val(n),t.$initSubEditor().then(function(){var n=t.$getSubEditor();return n&&n.load(e.get("value"))})},m.prototype.doRead=function(){return this.$getSubEditor().read().then(function(t){return e.$("bacnet:BacnetPriorityValue",{value:t})})},m.prototype.doSave=function(e,t){var n=t&&t.batch,o=t&&t.progressCallback,a=this.value().set({slot:"value",value:e.get("value"),batch:n});return o&&o(r.COMMIT_READY),a},m.prototype.doDestroy=function(){return this.getChildEditors().destroyAll()},m.prototype.doEnabled=function(e){return this.$getSelect().prop("disabled",this.isReadonly()||!e),this.$getSubEditor().setEnabled(e)},m.prototype.doReadonly=function(e){return this.$getSelect().prop("disabled",!this.isEnabled()||e),this.$getSubEditor().setReadonly(e)},m.prototype.$getSubEditor=function(){return this.jq().children(".js-subEditor").data("widget")},m.prototype.$getSelect=function(){return this.jq().children("select")},m}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetRecipientEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){return'<div class="key-commands ux-toggle-btn-group" />\n<hr>\n<div class="key-device" />\n<div class="key-address" />\n\n\x3c!-- TODO: Remove class="ux-toggle-btn-group" when NCCB-20233 is fixed--\x3e'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetRecipientEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetRecipientEditor",["baja!","baja!bacnet:BacnetRecipient","bajaux/mixin/batchSaveMixin","bajaux/commands/ToggleCommandGroup","bajaux/util/CommandButtonGroup","bajaux/Widget","css!nmodule/bacnet/rc/bacnet","hbs!nmodule/bacnet/rc/fe/templates/BacnetRecipientEditor","nmodule/bacnet/rc/baja/datatypes/BacnetRecipient","nmodule/webEditors/rc/fe/CompositeEditor","nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/fe/config/CompositeBuilder","Promise"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m){"use strict";var g=s.DEVICE,b=s.ADDRESS,f=l.bulkCopy,y=function(){u.apply(this,arguments),n(this),this.getFormFactor()===a.formfactor.mini&&d.$mixin(this)};return y.prototype=Object.create(u.prototype),y.prototype.constructor=y,y.prototype.doInitialize=function(e){var t=this;return e.html(c()),t.$toggleCommandGroup=new r({onChange:function(e){t.$toggleDisplay(e)},commands:[{module:"bacnet",lex:"BacnetRecipientEditor.commands.toggle.device",value:g},{module:"bacnet",lex:"BacnetRecipientEditor.commands.toggle.address",value:b}]}),u.prototype.doInitialize.apply(t,arguments)},y.prototype.makeBuilder=function(){var e=this,t=new p;return t.getKeys=function(){return["commands","device","address"]},t.getDomFor=function(t){return e.jq().children(".key-"+t)},t.getValueFor=function(t){var n=this.getDataSource();switch(t){case"commands":return e.$toggleCommandGroup;case"device":return n.get("device");case"address":return n.get("address")}},t.getConfigFor=function(e){switch(e){case"commands":return{type:o,formFactor:"mini"};default:return{formFactor:"mini"}}},t},y.prototype.doLoad=function(e){var t=this,n=e&&e.getChoice();return u.prototype.doLoad.apply(t,arguments).then(function(){t.$toggleDisplay(n),t.$getAddressToggleCommand().setSelected(n===b),t.$getDeviceToggleCommand().setSelected(n===g)})},y.prototype.doRead=function(){var t=this;return m.all([t.$getDeviceEditor().read(),t.$getAddressEditor().read()]).spread(function(n,r){return e.$("bacnet:BacnetRecipient",{choice:e.Integer.make(t.$getToggleCommandGroup().getSelectedValue()),device:n,address:r})})},y.prototype.doSave=function(e,t){var r=this.value(),o=t&&t.batch,a=t&&t.progressCallback,i=[],c=e.get("choice"),s=e.get("device"),u=e.get("address");i.push(r.set({slot:"choice",value:c,batch:o})),c.valueOf()===g?i.push(r.set({slot:"device",value:s,batch:o})):i.push(f(u,r.get("address"),["addressType","networkNumber","macAddress"],o));var d=m.all(i);return a&&a(n.COMMIT_READY),d},y.prototype.$getToggleCommandGroup=function(){return this.$toggleCommandGroup},y.prototype.$getDeviceToggleCommand=function(){return this.$toggleCommandGroup.get(g)},y.prototype.$getAddressToggleCommand=function(){return this.$toggleCommandGroup.get(b)},y.prototype.$getCommandButtonGroup=function(){return this.getBuilder().getEditorFor("commands")},y.prototype.$getDeviceEditor=function(){return this.getBuilder().getEditorFor("device")},y.prototype.$getAddressEditor=function(){return this.getBuilder().getEditorFor("address")},y.prototype.$getDeviceElement=function(){return this.jq().find(".key-device")},y.prototype.$getAddressElement=function(){return this.jq().find(".key-address")},y.prototype.$toggleDisplay=function(e){var t=this;t.$getDeviceElement().toggle(e===g),t.$getAddressElement().toggle(e===b)},y}),define("nmodule/bacnet/rc/fe/BacnetScaleEditor",["baja!","lex!bacnet","bajaux/events","bajaux/mixin/batchSaveMixin","Promise","nmodule/webEditors/rc/fe/fe","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/OrderedMapEditor","nmodule/webEditors/rc/fe/baja/util/compUtils","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i,c,s){"use strict";var u=t[0],d=s.bulkCopy,l=n.MODIFY_EVENT,p=function(){var t=new e.OrderedMap;return t.put(u.get({key:"bacnetScale.float",def:"Float"}),0),t.put(u.get({key:"bacnetScale.int",def:"Int"}),1),t}(),m=function(){i.apply(this,arguments),r(this)};return m.prototype=Object.create(i.prototype),m.prototype.constructor=m,m.prototype.doInitialize=function(t){var n=this;return t.html('<div class="js-choice"/><div class="js-scale"/>'),t.on(l,".editor",function(){return n.setModified(!0),!1}),t.on(l,".js-choice",function(){var t=n.$getChoiceEditor().getSelectedValue();n.$getScaleEditor().read().then(function(e){return n.$loadScale(t,e)}).catch(e.error)}),a.buildFor({dom:t.children(".js-choice"),type:c,value:p,formFactor:"mini"})},m.prototype.doLoad=function(e){return this.$loadScale(e.get("choice"),e.get("scale"))},m.prototype.doRead=function(){return this.getChildEditors().readAll().spread(function(t,n){return e.$("bacnet:BacnetScale",{choice:t,scale:n})})},m.prototype.doSave=function(e,t){var n=t&&t.batch,o=t&&t.progressCallback,a=d(e,this.value(),["choice","scale"],n);return o&&o(r.COMMIT_READY),a},m.prototype.doEnabled=function(e){return this.getChildEditors().setAllEnabled(e)},m.prototype.doReadonly=function(e){return this.getChildEditors().setAllReadonly(e)},m.prototype.doDestroy=function(){return this.getChildEditors().destroyAll()},m.prototype.$loadScale=function(t,n){var r=this,i=r.$getScaleEditor();return t=t.valueOf(),n=n.valueOf(),0!==t&&(n=e.Integer.make(n)),o.resolve(i&&i.destroy()).then(function(){return r.$getChoiceEditor().setSelectedValue(t,!0),a.buildFor({value:n,dom:r.$getScaleElement(),formFactor:"mini"})})},m.prototype.$getChoiceEditor=function(){return this.jq().children(".js-choice").data("widget")},m.prototype.$getScaleEditor=function(){return this.$getScaleElement().data("widget")},m.prototype.$getScaleElement=function(){return this.jq().children(".js-scale")},m}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<div class="editors"><span class="time-part time-part-'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"h"):a,t))+'" data-key="'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"h"):a,t))+'"></span><span>:</span><span class="time-part time-part-'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"m"):a,t))+'" data-key="'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"m"):a,t))+'"></span><span>:</span><span class="time-part time-part-'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"s"):a,t))+'" data-key="'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"s"):a,t))+'"></span><span>.</span><span class="time-part time-part-'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"hs"):a,t))+'" data-key="'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"hs"):a,t))+'"></span><div class="commands"/></div>'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetTimeEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetTimeEditor",["baja!","nmodule/webEditors/rc/fe/CompositeEditor","nmodule/webEditors/rc/fe/config/CompositeBuilder","Promise","jquery","nmodule/bacnet/rc/baja/datatypes/BacnetTime","nmodule/webEditors/rc/fe/fe","hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeEditor","bajaux/commands/Command","bajaux/util/CommandButtonGroup","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i,c,s,u){"use strict";var d=["h","m","s","hs"],l=function(e){s.call(this,{module:"bacnet",lex:"BacnetEd.asteriskCommand",func:function(){return e.setModified(!0),e.doLoad(a.DEFAULT)}})};l.prototype=Object.create(s.prototype),l.prototype.constructor=l;var p=function(){var e=this;t.apply(this,arguments),e.getCommandGroup().add(new l(e))};return p.prototype=Object.create(t.prototype),p.prototype.constructor=p,p.prototype.makeBuilder=function(){var t=this,r=new n;return r.getDomFor=function(e){return o(".time-part-"+e,t.jq())},r.getKeys=function(){return d},r.getValueFor=function(e){var t=this.getDataSource();switch(e){case"h":var n=t.getHour();return-1===n?"**":n;case"m":var r=t.getMinute();return-1===r?"**":r;case"s":var o=t.getSecond();return-1===o?"**":o;case"hs":var a=t.getHundredth();return-1===a?"**":a}return"**"},r.getConfigFor=function(){return{value:e.Integer.DEFAULT,properties:{uxFieldEditor:"webEditors:StringEditor"},formFactor:"mini"}},r},p.prototype.doInitialize=function(e){var n=this;return e.html(c({labels:{h:"h",m:"m",s:"s",hs:"hs"}})),r.join(i.buildFor({dom:o(".commands",n.jq()),type:u,value:this.getCommandGroup(),properties:{toolbar:!0},formFactor:"mini"}),t.prototype.doInitialize.apply(this,arguments)).then(function(){n.jq().find("button").removeClass("ux-btn"),n.jq().find("button").addClass("ux-btn-tb")})},p.prototype.doRead=function(){return this.getBuilder().readAll().spread(function(e,t,n,r){var o="**"===e?-1:e,i="**"===t?-1:t,c="**"===n?-1:n,s="**"===r?-1:r;return a.make(o,i,c,s)})},p.prototype.doDestroy=function(){return this.getChildWidgets().destroyAll()},p.prototype.doReadonly=function(e){return this.getChildWidgets().setAllReadonly(e)},
p.prototype.doEnabled=function(e){return this.getChildWidgets().setAllEnabled(e)},p.prototype.$getEditorsElement=function(){return this.jq().find(".editors")},p.prototype.$getAsteriskCommand=function(){return this.getCommandGroup().get(0)},p}),define("nmodule/bacnet/rc/fe/BacnetUnsignedEditor",["baja!","bajaux/Properties","nmodule/bacnet/rc/baja/datatypes/BacnetUnsigned","nmodule/webEditors/rc/fe/CompositeEditor","nmodule/webEditors/rc/fe/config/CompositeBuilder"],function(e,t,n,r,o){"use strict";var a=function(){r.apply(this,arguments)};return a.prototype=Object.create(r.prototype),a.prototype.constructor=a,a.prototype.makeBuilder=function(){var r=this,a=new o;return a.getDomFor=function(e){return r.jq().children()},a.getKeys=function(){return["value"]},a.getValueFor=function(t){var n=this.getDataSource(),o=n.valueOf(),a=r.properties().getValue("range");return a?e.DynamicEnum.make({ordinal:o,range:a}):e.Long.make(o)},a.getConfigFor=function(e){var o=r.properties();if(o.getValue("range"))return{properties:o,formFactor:"mini"};var a=(o.getValue("radix")||10).valueOf(),i=(o.getValue("min")||n.MIN_VALUE).valueOf(),c=(o.getValue("max")||n.MAX_VALUE).valueOf(),s=(o.getValue("units")||"").toString(),u="";return s&&(u+=s),10!==a&&(u.length>0&&(u+=" "),u+="Base "+a),i===n.MIN_VALUE&&c===n.MAX_VALUE||(u.length>0&&(u+=" "),u+="["+i.toString(a)+" - "+c.toString(a)+"]"),{properties:t.extend({postlabel:u},o),formFactor:"mini"}},a},a.prototype.doInitialize=function(e){return e.html("<div/>"),r.prototype.doInitialize.apply(this,arguments)},a.prototype.doRead=function(){return this.getChildEditors()[0].read().then(function(t){var n=t;return e.hasType(t,"baja:Enum")&&(n=t.getOrdinal()),e.$("bacnet:BacnetUnsigned",n)})},a}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeStampEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<div class="editors bacTS">\n  <div class="bacTS-option toggleCommandGrp" />\n  <hr>\n  <div class="bacTS-time">\n    <div style="display:inline-block">'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"time"):a,t))+':</div>\n    <div class="bts-time"></div>\n  </div>\n  <div class="bacTS-seq"/>\n  <div class="date-time">\n    <table>\n    <tbody>\n      <tr><td rowSpan="2">'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"dt"):a,t))+':</td><td><div class="bacTS-dtd"/></td></tr>\n      <tr><td><div class="bacTS-dtt"/></td></tr>\n    </tbody>\n    </table>\n  </div>\n</div>'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetTimeStampEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetTimeStampEditor",["baja!","jquery","underscore","Promise","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/util/htmlUtils","nmodule/bacnet/rc/fe/BacnetUnsignedEditor","hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeStampEditor","bajaux/util/CommandButtonGroup","bajaux/commands/ToggleCommandGroup","nmodule/webEditors/rc/fe/fe","bajaux/Widget","bajaux/events","bajaux/mixin/batchSaveMixin","lex!bacnet","nmodule/bacnet/rc/baja/util/BacnetDateUtil","baja!bacnet:BacnetTime","baja!bacnet:BacnetDate"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m,g,b,f,y){"use strict";var h=c.escapeHtml,v=i.bulkCopy,E=f[0],T=g.DESTROY_EVENT,j=g.INITIALIZE_EVENT,w=g.LOAD_EVENT,S=g.ENABLE_EVENT,A=g.DISABLE_EVENT,B=g.MODIFY_EVENT,N=g.READONLY_EVENT,D=g.WRITABLE_EVENT,I=function(){var e=this;o.apply(e,arguments),e.getFormFactor()===m.formfactor.mini?a.$mixin(e):(b(e),e.$toggleCmdGrp=new l({onChange:function(t){e.$toggleDisplay(t)},commands:[{module:"bacnet",lex:"BacnetTS.commands.toggle.time",value:0},{module:"bacnet",lex:"BacnetTS.commands.toggle.seqNum",value:1},{module:"bacnet",lex:"BacnetTS.commands.toggle.dateTime",value:2}]}))};return I.prototype=Object.create(o.prototype),I.prototype.constructor=I,I.prototype.valueToString=function(t){var n="";if(e.hasType(t,"bacnet:BacnetTimeStamp")){var r=t.getDisplay();if(null!==r)n=r.substring(r.indexOf(":")+1);else switch(t&&t.getChoice()){case 0:n=t.getTime().encodeToString();break;case 1:n=t.getSequenceNumber().encodeToString();break;case 2:var o=t.getDateTime();n=y.getDisplayBacnetDateString(o.getDate().encodeToString())+"_"+o.getTime().encodeToString()}}else n=t&&t.getTime().encodeToString();return h(n||"")},I.prototype.doInitialize=function(n){var o=this;return n.on([T,j,w,S,A,N,D].join(" "),".editor",!1),n.on(B,".bajaux-initialized",function(){return o.setModified(!0),!1}),n.html(u({labels:{time:E.get("BacnetTS.editor.label.time"),seq:E.get("BacnetTS.editor.label.seqNumber"),dt:E.get("BacnetTS.editor.label.dateTime")}})),r.join(p.buildFor({dom:t(".toggleCommandGrp",n),type:d,value:o.$getToggleCommandGroup(),initializeParams:{toggleGroup:!0}}),p.buildFor({value:0,type:s,dom:o.jq().find(".bacTS-seq"),properties:{prelabel:E.get("BacnetTS.editor.label.seqNumber")+":",precision:0},formFactor:"mini"}),p.buildFor({value:e.$("bacnet:BacnetTime"),dom:o.jq().find(".bts-time"),properties:{prelabel:E.get("BacnetTS.editor.label.time")},formFactor:"mini"}),p.buildFor({value:e.$("bacnet:BacnetDate"),dom:o.jq().find(".bacTS-dtd"),formFactor:"mini"}),p.buildFor({value:e.$("bacnet:BacnetTime"),dom:o.jq().find(".bacTS-dtt"),formFactor:"mini"}))},I.prototype.doLoad=function(e){var t=this,n=e&&e.getChoice();switch(t.$toggleDisplay(n),n){case 0:return t.$getTimeToggleCommand().setSelected(!0),t.$loadTime(e.getTime());case 1:return t.$getSeqToggleCommand().setSelected(!0),t.$loadSeqNum(e.getSequenceNumber());case 2:return t.$getDtTmToggleCommand().setSelected(!0),t.$loadDateTime(e.getDateTime())}},I.prototype.$loadTime=function(t){return this.jq().find(".bts-time").data("widget").load(t||e.$("bacnet:BacnetTime"))},I.prototype.$loadSeqNum=function(e){return this.jq().find(".bacTS-seq").data("widget").load(e||0)},I.prototype.$loadDateTime=function(t){var n=t&&t.getDate(),o=t&&t.getTime();return r.join(this.jq().find(".bacTS-dtd").data("widget").load(n||e.$("bacnet:BacnetDate")),this.jq().find(".bacTS-dtt").data("widget").load(o||e.$("bacnet:BacnetTime")))},I.prototype.doRead=function(){var t=this,n=parseInt(t.$getToggleCommandGroup().getSelectedValue(),10);return this.getChildEditors().readAll().then(function(t){var r=e.$("bacnet:BacnetTimeStamp");switch(n){case 0:r.setTime(t[0]),r.setChoice(0);break;case 1:r.setSequenceNumber(t[1]),r.setChoice(1);break;case 2:r.getDateTime().setTime(t[3]),r.getDateTime().setDate(t[2]),r.setChoice(2)}return r})},I.prototype.doSave=function(e,t){var n,o,a=t&&t.batch,i=t&&i,c=this.value(),s=e,u=c;switch(e.get("choice").valueOf()){case 0:n=["time"];break;case 1:n=["sequenceNumber"];break;case 2:s=e.get("dateTime"),u=c.get("dateTime"),n=["date","time"]}return o=r.join(v(s,u,n,a),v(e,c,["choice"],a)),i&&i(b.COMMIT_READY),o},I.prototype.$getToggleCommandGroup=function(){return this.$toggleCmdGrp},I.prototype.$getSeqToggleCommand=function(){return this.$getToggleCommandGroup().get(1)},I.prototype.$getTimeToggleCommand=function(){return this.$getToggleCommandGroup().get(0)},I.prototype.$getDtTmToggleCommand=function(){return this.$getToggleCommandGroup().get(2)},I.prototype.doDestroy=function(){return this.getChildWidgets().destroyAll()},I.prototype.doReadonly=function(e){return this.getChildWidgets().setAllReadonly(e)},I.prototype.doEnabled=function(e){return this.getChildWidgets().setAllEnabled(e)},I.prototype.$toggleDisplay=function(e){var t=this.jq().find(".bacTS-seq"),n=this.jq().find(".bacTS-time"),r=this.jq().find(".date-time");switch(e){case 0:t.hide(),r.hide(),n.show();break;case 1:n.hide(),r.hide(),t.show();break;case 2:n.hide(),t.hide(),r.show()}},I}),define("hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeValueEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<div class="btv-time">\n  <span><label>'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"time"):a,t))+':</label></span>\n  <div class="js-time" />\n</div>\n<div class="btv-any">\n  <span><label>'+e.escapeExpression(e.lambda(null!=(a=null!=t?i(t,"labels"):t)?i(a,"value"):a,t))+':</label></span>\n  <div class="js-any" />\n</div>'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/BacnetTimeValueEditor",t),t}),define("nmodule/bacnet/rc/fe/BacnetTimeValueEditor",["baja!","jquery","Promise","bajaux/events","bajaux/Widget","bajaux/mixin/batchSaveMixin","bajaux/mixin/subscriberMixIn","nmodule/webEditors/rc/fe/baja/util/DepthSubscriber","nmodule/webEditors/rc/fe/baja/BaseEditor","nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor","nmodule/webEditors/rc/fe/fe","nmodule/bacnet/rc/fe/BacnetAnyEditor","lex!bacnet","hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeValueEditor"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m){"use strict";var g=p[0],b=r.DESTROY_EVENT,f=r.INITIALIZE_EVENT,y=r.LOAD_EVENT,h=r.ENABLE_EVENT,v=r.DISABLE_EVENT,E=r.MODIFY_EVENT,T=r.READONLY_EVENT,j=r.WRITABLE_EVENT,w=function(e){var t=this;s.apply(t,arguments),t.getFormFactor()===o.formfactor.mini?u.$mixin(t):a(t),t.$subscriber=new c(2),i(t)};return w.prototype=Object.create(s.prototype),w.prototype.constructor=w,w.prototype.valueToString=function(t){var n="";return e.hasType(t,"bacnet:BacnetTimeValue")&&((n=t.getDisplay())||(n=t.getTime().encodeToString()+";"+t.getValue().toString())),n},w.prototype.doInitialize=function(r){var o=this;return r.on([b,f,y,h,v,T,j].join(" "),".editor",!1),r.on(E,".editor",function(){return o.setModified(!0),!1}),r.html(m({labels:{time:g.get("BacnetTV.editor.label.time"),value:g.get("BacnetTV.editor.label.value")}})),n.join(d.buildFor({value:e.$("bacnet:BacnetTime"),dom:t(".js-time",r),formFactor:"mini"}),d.buildFor({value:e.$("bacnet:BacnetAny"),type:l,dom:t(".js-any",r),formFactor:"mini"}))},w.prototype.doLoad=function(e){var t=this;return n.all([t.$getTimeEditor().load(e.getTime()),t.$getValueEditor().load(e.getValue())])},w.prototype.doRead=function(){return this.getChildEditors().readAll().spread(function(t,n){var r=e.$("bacnet:BacnetTimeValue");return r.setTime(t),r.setValue(n),r})},w.prototype.doSave=function(e,t){var r,o=t&&t.batch,i=t&&t.progressCallback,c=this.value();return r=n.join(c.set({slot:"time",value:e.get("time"),batch:o}),this.$getValueEditor().save(t)),i&&i(a.COMMIT_READY),r},w.prototype.$getTimeEditor=function(){return this.jq().find(".js-time").data("widget")},w.prototype.$getValueEditor=function(){return this.jq().find(".js-any").data("widget")},w.prototype.doReadonly=function(e){return this.getChildEditors().setAllReadonly(e)},w.prototype.doEnabled=function(e){return this.getChildEditors().setAllEnabled(e)},w.prototype.doDestroy=function(){return this.getChildEditors().destroyAll()},w}),define("hbs!nmodule/bacnet/rc/fe/templates/DiscoveryNetworksEditor",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return"<div>\n  <div class='discovery-networks-btn-container'>\n    <label for='"+e.escapeExpression((a=null!=(a=i(n,"sendGlobalId")||(null!=t?i(t,"sendGlobalId"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"sendGlobalId",hash:{},data:o,loc:{start:{line:3,column:16},end:{line:3,column:32}}}):a))+"'><input type='checkbox' class='discovery-networks-send-global' id='"+e.escapeExpression((a=null!=(a=i(n,"sendGlobalId")||(null!=t?i(t,"sendGlobalId"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"sendGlobalId",hash:{},data:o,loc:{start:{line:3,column:100},end:{line:3,column:116}}}):a))+"'>"+e.escapeExpression((a=null!=(a=i(n,"sendGlobal")||(null!=t?i(t,"sendGlobal"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"sendGlobal",hash:{},data:o,loc:{start:{line:3,column:118},end:{line:3,column:132}}}):a))+"</label>\n    <button class='discovery-networks-select-all ux-btn'>"+e.escapeExpression((a=null!=(a=i(n,"selectAll")||(null!=t?i(t,"selectAll"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"selectAll",hash:{},data:o,loc:{start:{line:4,column:57},end:{line:4,column:70}}}):a))+"</button>\n    <button class='discovery-networks-clear-all ux-btn'>"+e.escapeExpression((a=null!=(a=i(n,"clearAll")||(null!=t?i(t,"clearAll"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"clearAll",hash:{},data:o,loc:{start:{line:5,column:56},end:{line:5,column:68}}}):a))+"</button>\n  </div>\n  <div class='discovery-networks-list-container'>\n    <table class='discovery-networks-table'>\n      <tbody>\n      </tbody>\n    </table>\n  </div>\n</div>"},useData:!0});return e.registerPartial("nmodule/bacnet/rc/fe/templates/DiscoveryNetworksEditor",t),t}),define("nmodule/bacnet/rc/fe/DiscoveryNetworksEditor",["baja!","lex!bacnet","jquery","underscore","nmodule/bacnet/rc/baja/datatypes/DiscoveryNetworks","nmodule/webEditors/rc/fe/baja/BaseEditor","hbs!nmodule/bacnet/rc/fe/templates/DiscoveryNetworksEditor","css!nmodule/bacnet/rc/bacnet"],function(e,t,n,r,o,a,i){"use strict";function c(e){return e.find(".discovery-networks-select-all")}function s(e){return e.find(".discovery-networks-clear-all")}function u(e){return e.find(".discovery-network-cb")}function d(e){return e.find(".discovery-networks-send-global")}var l=t[0],p=function(e){a.call(this,r.extend({keyName:"DiscoveryNetworksEditor",moduleName:"bacnet"},e))};return p.prototype=Object.create(a.prototype),p.prototype.constructor=p,p.prototype.doInitialize=function(e){var t=this;e.html(i({sendGlobalId:this.generateId(),sendGlobal:l.get("discoveryNetworks.global"),selectAll:l.get("discoveryNetworks.selectAll"),clearAll:l.get("discoveryNetworks.clearAll")})),c(e).on("click",function(){u(e).prop("checked",!0),t.setModified(!0)}),s(e).on("click",function(){d(e).prop("checked",!1),u(e).prop("checked",!1),t.setModified(!0)}),e.on("change","input:checkbox",function(){t.setModified(!0)})},p.prototype.doLoad=function(e){var t,o=this,a=o.jq(),i=e.getNetworks(),c=a.find(".discovery-networks-table tbody").first();r.each(i,function(e,r){var a,i,s=o.generateId(),u=n("<td>");a=n('<input type="checkbox" class="discovery-network-cb">').prop("id",s).prop("checked",!0).data("net-number",e),i=n("<label>"+e+"</label>").prop("for",s),r%5==0&&(t=n("<tr>"),c.append(t)),u.append(a).append(i),t.append(u)}),e.isAllNetworks()&&d(a).prop("checked",!0)},p.prototype.doRead=function(){var e=this.jq(),t=[],r=d(e).prop("checked");return u(e).each(function(e,r){var o=n(r);o.prop("checked")&&t.push(o.data("net-number"))}),o.make(r,t)},p.prototype.doEnabled=function(e){var t=this.isReadonly()||!e,n=this.jq();d(n).prop("disabled",t),u(n).prop("disabled",t),c(n).prop("disabled",t),s(n).prop("disabled",t)},p.prototype.doReadonly=function(e){var t=!this.isEnabled()||e,n=this.jq();d(n).prop("disabled",t),u(n).prop("disable",t),c(n).prop("disabled",t),s(n).prop("disabled",t)},p.prototype.doDestroy=function(){var e=this.jq();c(e).off(),s(e).off(),e.find("input:checkbox").off()},p}),define("nmodule/bacnet/rc/util/PropertyInfo",["lex!bacnet","underscore","nmodule/bacnet/rc/util/BacnetConst"],function(e,t,n){"use strict";function r(e){return i.get(e)}function o(e,t,n){var r=e.getAttribute(t);return"string"==typeof r?r:n}function a(e){return"true"===String(e).toLowerCase()}var i=e[0],c={},s={};c[n.ASN_NULL]="bacnet:BacnetNull",c[n.ASN_BOOLEAN]="baja:Boolean",c[n.ASN_UNSIGNED]="bacnet:BacnetUnsigned",c[n.ASN_INTEGER]="baja:Integer",c[n.ASN_REAL]="baja:Float",c[n.ASN_DOUBLE]="baja:Double",c[n.ASN_OCTET_STRING]="bacnet:BacnetOctetString",c[n.ASN_CHARACTER_STRING]="baja:String",c[n.ASN_BIT_STRING]="bacnet:BacnetBitString",c[n.ASN_DATE]="bacnet:BacnetDate",c[n.ASN_TIME]="bacnet:BacnetTime",c[n.ASN_OBJECT_IDENTIFIER]="bacnet:BacnetObjectIdentifier",c[n.ASN_ANY]="bacnet:BacnetAny",s[n.ASN_NULL]=r("asn.null"),s[n.ASN_BOOLEAN]=r("asn.boolean"),s[n.ASN_UNSIGNED]=r("asn.unsigned"),s[n.ASN_INTEGER]=r("asn.integer"),s[n.ASN_REAL]=r("asn.real"),s[n.ASN_DOUBLE]=r("asn.double"),s[n.ASN_OCTET_STRING]=r("asn.octetString"),s[n.ASN_CHARACTER_STRING]=r("asn.characterString"),s[n.ASN_BIT_STRING]=r("asn.bitString"),s[n.ASN_ENUMERATED]=r("asn.enumerated"),s[n.ASN_DATE]=r("asn.date"),s[n.ASN_TIME]=r("asn.time"),s[n.ASN_OBJECT_IDENTIFIER]=r("asn.objectId"),s[n.ASHRAE_RESERVED_13]=r("asn.reserved13"),s[n.ASHRAE_RESERVED_14]=r("asn.reserved14"),s[n.ASHRAE_RESERVED_15]=r("asn.reserved15"),s[n.ASN_CONSTRUCTED_DATA]=r("asn.constructed"),s[n.ASN_BACNET_ARRAY]=r("asn.array"),s[n.ASN_BACNET_LIST]=r("asn.list"),s[n.ASN_ANY]=r("asn.any"),s[n.ASN_CHOICE]=r("asn.choice"),s[n.ASN_UNKNOWN_PROPRIETARY]=r("asn.unknown");var u=function(e){e&&(e.name&&(this.$name=e.name),void 0!==e.id&&(this.$id=e.id),void 0!==e.asnType&&(this.$asnType=e.asnType))};return u.prototype.constructor=u,u.$makeFromXmlElement=function(e){var t=new u,r=o(e,"a");return t.$id=parseInt(o(e,"i")),t.$name=o(e,"n"),t.$asnType=r?parseInt(r):n.ASN_UNKNOWN_PROPRIETARY,t.$type=c[t.$asnType],t.$facet=a(o(e,"f","false")),t.$facetControl=o(e,"c","no"),t.isEnum()?(t.$extensible=a(o(e,"e","false")),t.$type=o(e,"t"),t.$facetControl="enum"):t.isBitString()?t.$bs=o(e,"b"):t.isConstructed()||t.isList()||t.isChoice()?t.$type=o(e,"t"):t.isArray()&&(t.$type=o(e,"t"),t.$size=o(e,"s","-1")),t},u.$makeFromCachedProperties=function(e){return t.extend(new u,e)},u.prototype.getName=function(){return this.$name},u.prototype.getId=function(){return this.$id},u.prototype.getType=function(){return this.$type},u.prototype.getAsnType=function(){return this.$asnType},u.prototype.isFacet=function(){return!!this.$facet},u.prototype.getFacetControl=function(){return this.$facetControl},u.prototype.getDataType=function(){return s[String(this.$asnType)]||"???"},u.prototype.isExtensible=function(){if(!this.isEnum())throw new Error("enum property required");return this.$extensible},u.prototype.isEnum=function(){return this.$asnType===n.ASN_ENUMERATED},u.prototype.isBitString=function(){return this.$asnType===n.ASN_BIT_STRING},u.prototype.isConstructed=function(){return this.$asnType===n.ASN_CONSTRUCTED_DATA},u.prototype.isArray=function(){return this.$asnType===n.ASN_BACNET_ARRAY},u.prototype.isList=function(){return this.$asnType===n.ASN_BACNET_LIST},u.prototype.isChoice=function(){return this.$asnType===n.ASN_CHOICE},u.prototype.isAws=function(){return this.$type&&this.$type.indexOf("Aws")>=0},u}),define("nmodule/bacnet/rc/util/ObjectTypeList",["baja!","jquery","Promise","underscore","nmodule/bacnet/rc/util/BacnetConst","nmodule/bacnet/rc/util/PropertyInfo"],function(e,t,n,r,o,a){"use strict";function i(e,t){return e.getAttribute(t)}function c(e){return n.resolve(t.ajax(e.getReadUri()+"?snoop=false",{dataType:"text"}))}function s(t){return e.rpc("type:web:FileRpc","readTextFile",t.getNavOrd().toString())}function u(t){return e.isOffline()?s(t):c(t)}function d(e){return u(e).then(function(e){return f(e)})}function l(t){return e.Ord.make(t).get().then(function(e){return d(e)})}function p(){return l(h,!0).catch(function(){return l(v,!0)})}function m(e){return l(e,!1)}function g(e){return e?m(e):p()}function b(e){var n={};return t(e).find("property").each(function(e,t){var r=a.$makeFromXmlElement(t);n[r.getId()]=r}),n}function f(e){var n=t.parseXML(e),r={};return t(n).find("object").each(function(e,t){var n={$name:i(t,"n"),$typeId:i(t,"t"),$properties:b(t)};r[n.$typeId]=n}),r}var y=[],h="file:!defaults/bacnetObjectTypes.xml",v="module://bacnet/com/tridium/bacnet/objectTypes.xml",E=function(){};return E.make=function(e){var t=e&&e.ord,r=t?String(t):"__default__";if(y[r])return n.resolve(y[r]);var o=new E;return g(t).then(function(e){return o.$objects=e,y[r]=o,o})},E.prototype.getPropertyInfo=function(e,t){var n=this.$objects[e];return n&&n.$properties[t]||null},E.prototype.isObjectTypeKnown=function(e){return!!this.$objects[e]},E}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetConfigLearnModel",["lex!bacnet","nmodule/webEditors/rc/wb/table/model/columns/IconColumn","nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn","nmodule/webEditors/rc/wb/table/tree/TreeTableModel"],function(e,t,n,r){"use strict";var o=e[0],a=function(){t.apply(this,arguments)};a.prototype=Object.create(t.prototype),a.prototype.constructor=a,a.prototype.getValueFor=function(e){return e.getSubject().getIcon()};var i=[new a,new n("objectName",{displayName:o.get("configManager.objectName")}),new n("objectId",{displayName:o.get("learn.objectId")}),new n("value",{displayName:o.get("configManager.value")}),new n("description",{displayName:o.get("configManager.description")})],c={};return c.make=function(){return r.make({columns:i})},c}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetConfigMgrModel",["baja!","baja!bacnet:BacnetObject","lex!bacnet","underscore","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/wb/mgr/model/folderMgrModelMixin","nmodule/webEditors/rc/wb/mgr/model/MgrModel","nmodule/webEditors/rc/wb/mgr/MgrTypeInfo","nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn","nmodule/webEditors/rc/wb/table/model/Column"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m){"use strict";function g(e){return y(e,"bacnet:BacnetConfigDeviceExt").invoke({slot:"getConfigTypes"}).then(function(e){return c.make(r.without(e.split(";"),"bacnet:BacnetDeviceObject"))}).then(function(e){return e.sort(c.BY_DISPLAY_NAME)})}function b(){return[new s,new d({flags:v|E}),new u({flags:h}),new p({flags:h|v}),new j("value",{displayName:f.get("configManager.value")}),new l("objectId",{displayName:f.get("learn.objectId"),flags:h,type:T}),new l("objectName",{displayName:f.get("configManager.objectName"),type:T}),new l("description",{displayName:f.get("configManager.description"),getDefaultValue:r.constant("")}),new l("pollFrequency",{flags:h|v,type:T})]}var f=n[0],y=o.closest,h=m.flags.EDITABLE,v=m.flags.UNSEEN,E=m.flags.READONLY,T=e.lt("bacnet:BacnetObject"),j=function(){l.apply(this,arguments)};j.prototype=Object.create(l.prototype),j.prototype.constructor=j,j.prototype.getValueFor=function(e){return String(e.getSubject())};var w={};return w.make=function(e){return g(e).then(function(t){var n=new i({columns:b(),componentSource:e,newTypes:t});return a(n,{folderType:"bacnet:BacnetConfigFolder"}),n.getNavDisplayName=function(){return e.getNavDisplayName()},n})},w}),define("nmodule/bacnet/rc/wb/mgr/BacnetConfigUxManager",["baja!","baja!bacnet:BacnetAnalogInput,bacnet:BacnetConfigDeviceExt,bacnet:BacnetConfigFolder,bacnet:DiscoveryConfig,bacnet:BacnetObject","Promise","underscore","nmodule/bacnet/rc/wb/mgr/model/BacnetConfigLearnModel","nmodule/bacnet/rc/wb/mgr/model/BacnetConfigMgrModel","nmodule/driver/rc/wb/mgr/DriverMgr","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/wb/mgr/MgrLearn","nmodule/webEditors/rc/wb/mgr/MgrTypeInfo","nmodule/webEditors/rc/wb/tree/TreeNode"],function(e,t,n,r,o,a,i,c,s,u,d){"use strict";function l(e){var t=e.getObjectName(),n=new d(t,t);return n.getIcon=r.constant(g),n.mayHaveKids=r.constant(!1),n.value=r.constant(e),n}function p(e){var t=e.getLearnModel(),r=t.getRows().length,o=t.getRootNode();return n.map(e.$discoveries||[],function(e){return l(e)}).then(function(e){return n.map(o.getKids(),function(e){return o.remove(e)}).then(function(){return n.map(e,function(e){return o.add(e)})}).then(function(){return(r?t.removeRows(0,r):n.resolve()).then(function(){return t.insertRows(e,0)})})})}var m=c.closest,g=e.Icon.make(["module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png"]),b=function(t){i.call(this,r.extend({moduleName:"bacnet",keyName:"BacnetConfigUxManager",folderType:"bacnet:BacnetConfigFolder",editableTypes:[e.lt("bacnet:BacnetObject")],subscriptionDepth:2},t)),s(this)};return b.prototype=Object.create(i.prototype),b.prototype.constructor=b,b.prototype.doInitialize=function(t){var n=this;return n.on("jobcomplete",function(t){t.getType().is("bacnet:BacnetDiscoverConfigJob")&&n.$discoveryJobComplete(t,n).catch(e.error)}),i.prototype.doInitialize.apply(n,arguments)},b.prototype.makeModel=function(e){return a.make(e)},b.prototype.makeLearnModel=function(){return o.make()},b.prototype.getDeviceExt=function(){return m(this.value(),"bacnet:BacnetConfigDeviceExt")},b.prototype.$discoveryJobComplete=function(e){var t=this;return e.loadSlots().then(function(){var n=e.getSlots().properties();return t.$discoveries=n.is("bacnet:DiscoveryConfig").toValueArray(),p(t)})},b.prototype.doDiscover=function(){var t=this;return t.getDeviceExt().submitConfigDiscoveryJob().then(function(n){return n=e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}),t.setJob(n)})},b.prototype.getTypesForDiscoverySubject=function(e){return u.make(e.getTypeSpecs())},b.prototype.getProposedValuesFromDiscovery=function(e){return{name:e.get("objectName"),values:{objectId:e.get("objectId"),value:e.get("value"),description:e.get("description")}}},b.prototype.isExisting=function(e,t){return e.get("objectId").equals(t&&t.get("objectId"))},b.prototype.saveStateForOrd=function(){var t=this,n={};return t.$discoveries&&(n.$discoveries=r.map(t.$discoveries,function(t){return e.bson.encodeValue(t)})),n},b.prototype.restoreStateForOrd=function(t){return t.$discoveries?(this.$discoveries=r.map(t.$discoveries,function(t){return e.bson.decodeValue(t)}),p(this)):n.resolve()},b}),define("nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn",["baja!","lex!bacnet","underscore","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn","nmodule/webEditors/rc/wb/table/model/Column","baja!bacnet:BacnetDeviceObject"],function(e,t,n,r,o){"use strict";var a=t[0],i=function(){r.call(this,"config/deviceObject/objectId",{displayName:a.get("deviceManager.deviceId"),type:e.lt("bacnet:BacnetDeviceObject"),flags:o.flags.EDITABLE})};return i.prototype=Object.create(r.prototype),i.prototype.constructor=i,i.prototype.getConfigFor=function(t){var n=r.prototype.getConfigFor.apply(this,arguments);return n.properties.add("range",e.EnumRange.make({ordinals:[8],tags:["Device"]})),n},i}),define("nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand",["baja!","lex!bacnet","jquery","Promise","underscore","dialogs","bajaux/commands/Command","nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn","nmodule/webEditors/rc/fe/feDialogs","nmodule/webEditors/rc/wb/mgr/BatchComponentEditor","nmodule/webEditors/rc/wb/mgr/mgrUtils","nmodule/webEditors/rc/wb/mgr/model/MgrModel","nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn","nmodule/webEditors/rc/wb/table/model/Column","nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource","baja!bacnet:ChangeDeviceIdConfig"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m,g){"use strict";function b(e,t,n){return e.length&&(e+=";"),e+t+"->"+n}function f(t){var n=e.$("bacnet:ChangeDeviceIdConfig"),r=t.getColumn("objectId"),a="";return o.map(t.getRows(),function(t){var o=r.getValueFor(t),i=r.getProposedValueFor(t);a=b(a,o,i),n.add({slot:"currentId?",value:o,flags:e.Flags.READONLY}),n.add({slot:"changeTo?",value:i,flags:e.Flags.READONLY})}),n.setValue(a),n}function y(e){var t;return"success"===e.getJobState().getTag()?h.getSafe("changeId.success"):(t=e.get("failureCause")||"",h.getSafe({key:"changeId.fail",args:[t]}))}var h=t[0],v=d.getMainTableSelectedSubjects,E=function(){u.apply(this,arguments)};E.prototype=Object.create(u.prototype),E.prototype.constructor=E,E.prototype.doInitialize=function(e){return e.addClass("ChangeIdBatchComponentEditor"),u.prototype.doInitialize.apply(this,arguments)},E.prototype.doSave=function(){return r.resolve()},E.makeEditModel=function(t){var n=[new p({flags:m.flags.READONLY|m.flags.EDITABLE}),new c("config/deviceObject/objectId",{displayName:h.get("deviceManager.deviceId"),type:e.lt("bacnet:BacnetDeviceObject"),flags:m.flags.EDITABLE})];return new l({componentSource:new g(t),columns:n})};var T=function(t){var n=this;i.call(this,{displayName:h.get("changeId.label"),description:h.get("changeId.description"),icon:h.get("changeId.icon"),enabled:!1,func:function(){var n=t.getNetwork();a.showYesNo({title:h.get("changeId.title"),content:h.getSafe("changeId.confirm"),yes:function(){var r,o=v(t);o.length&&o[0].getType().is("bacnet:BacnetDevice")&&(r=E.makeEditModel(o),t.getOrdBase().then(function(e){return s.showFor({value:r,properties:{ordBase:e},type:E})}).then(function(r){if(r){var o=f(r);return n.submitDeviceManagerJob(o).then(function(n){t.setJob(e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}))})}}).catch(e.error))}})}}),t.on("jobcomplete",function(e){e.getType().is("bacnet:ChangeDeviceIdJob")&&n.complete(e)})};return T.prototype=Object.create(i.prototype),T.prototype.constructor=T,T.prototype.complete=function(e){a.showOk({title:h.get("changeId.title"),content:y(e)})},T}),define("nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand",["baja!","lex!bacnet","jquery","Promise","underscore","dialogs","bajaux/commands/Command","nmodule/webEditors/rc/fe/feDialogs","nmodule/webEditors/rc/wb/PropertySheet","baja!bacnet:TimeSynchConfig,bacnet:TimeSynchJob,bacnet:BacnetNetwork"],function(e,t,n,r,o,a,i,c,s){"use strict";function u(){var t=e.DynamicEnum.make({range:e.EnumRange.make({ordinals:[0,1],tags:[e.SlotPath.escape(p.get("timeSynchType.local")),e.SlotPath.escape(p.get("timeSynchType.utc"))]})}),n=e.DynamicEnum.make({range:e.EnumRange.make({ordinals:[0,1],tags:[e.SlotPath.escape(p.get("timeSynchRange.local")),e.SlotPath.escape(p.get("timeSynchRange.global"))]})}),r=e.$("baja:Component",{timeSynchType:t,addressRange:n});return r.add({slot:"displayNames",value:e.NameMap.make({timeSynchType:p.get("timeSynchType.title"),addressRange:p.get("timeSynchRange.title")}),flags:e.Flags.HIDDEN}).then(function(){return r})}function d(e){return c.showFor({title:p.get("timeSynch.title"),type:s,value:e,properties:{showHeader:!1,showFooter:!1}})}function l(e){a.showOk({title:p.get("timeSynch.title"),content:p.getSafe("timeSynch.fail").replace("{0}",e||"")})}var p=t[0],m=function(t){var n=this;i.call(this,{displayName:p.get("timeSynch.label"),description:p.get("timeSynch.description"),icon:p.get("timeSynch.icon"),enabled:!0,func:function(){var n=t.getNetwork();a.showYesNo({title:p.get("timeSynch.title"),content:p.getSafe("timeSynch.confirm"),yes:function(){var r;u().then(function(e){return r=e,d(r)}).then(function(o){if(o){var a=e.$("bacnet:TimeSynchConfig",{timeSynchType:!!r.get("timeSynchType").getOrdinal(),addressRange:!!r.get("addressRange").getOrdinal()});return n.submitDeviceManagerJob(a).then(function(n){t.setJob(e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}))})}return null}).catch(l)}})}}),t.on("jobcomplete",function(e){e.getType().is("bacnet:TimeSynchJob")&&n.complete(e)})};return m.prototype=Object.create(i.prototype),m.prototype.constructor=m,m.prototype.complete=function(e){var t,n;"success"===e.getJobState().getTag()?t=p.getSafe("timeSynch.success"):(n=e.get("failureCause")||"",t=p.getSafe({key:"timeSynch.fail",args:[n]})),a.showOk({title:p.getSafe("timeSynch.title"),content:t})},m}),define("nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand",["baja!","lex!bacnet","jquery","Promise","underscore","dialogs","bajaux/commands/Command","nmodule/webEditors/rc/fe/feDialogs","nmodule/webEditors/rc/wb/PropertySheet","nmodule/webEditors/rc/wb/mgr/commands/MgrCommand","baja!bacnet:WhoHasConfig"],function(e,t,n,r,o,a,i,c,s,u){"use strict";var d=t[0],l=function(t){var n=this;i.call(n,{
displayName:d.get("whoHas.label"),icon:d.get("whoHas.icon"),enabled:!0,func:function(){var n=t.getNetwork();return t.makeDiscoveryNetworks(n).then(function(r){var o=e.$("bacnet:WhoHasConfig");return o.setNetworks(r),c.showFor({title:d.get("whoHas.description"),type:s,value:o,properties:{showHeader:!1,showFooter:!1}}).then(function(r){if(r)return r.apply(o).then(function(){return n.submitDeviceManagerJob(o)}).then(function(n){t.setJob(e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}))})})})}}),u(n),n.setShowInActionBar(!1),t.on("jobcomplete",function(e){e.getType().is("bacnet:WhoHasJob")&&n.complete(e)})};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.complete=function(e){return e.loadSlots().then(function(){var t=e.getSlots().properties().is("baja:String").toValueArray(),n="I-Have Responses for <br>"+t[0]+"<br><ul>";o.each(o.tail(t),function(e){var t=e.split("|");n=n+"<li>"+t[0]+" has object "+t[1]+" named "+t[2]+"</li>"}),n+="</ul>",a.showOk({title:d.get("whoHas.label"),content:n})})},l}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceLearnModel",["baja!","lex!bacnet","underscore","nmodule/bacnet/rc/baja/datatypes/BacnetAddress","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn","nmodule/webEditors/rc/wb/table/model/Column","nmodule/webEditors/rc/wb/table/model/columns/IconColumn","nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn","nmodule/webEditors/rc/wb/table/tree/TreeTableModel"],function(e,t,n,r,o,a,i,c,s){"use strict";function u(e){return d.get(e)}var d=t[0],l=e.Icon.make(["module://icons/x16/device.png"]),p=a.flags.UNSEEN,m=function(){i.apply(this,arguments)};m.prototype=Object.create(i.prototype),m.prototype.constructor=m,m.prototype.getValueFor=n.constant(l);var g=function(e,t){a.apply(this,arguments)};g.prototype=Object.create(a.prototype),g.prototype.constructor=g,g.prototype.getValueFor=function(e){var t=e.getSubject().get("address");return r.bytesToString(t.get("addressType").valueOf(),t.get("macAddress").getBytes())};var b=function(e,t){a.apply(this,arguments)};b.prototype=Object.create(a.prototype),b.prototype.constructor=b,b.prototype.getValueFor=function(e){var t=e.getSubject().get("listSize").valueOf();return t>0?String(t):u("deviceManager.unknown")};var f=[new m,new c("deviceName",{displayName:u("deviceManager.name")}),new c("objectId",{displayName:u("deviceManager.deviceId")}),new o("address/networkNumber",{displayName:u("deviceManager.network")}),new g("address",{displayName:u("deviceManager.mac")}),new c("vendorName",{displayName:u("deviceManager.vendorName")}),new c("modelName",{displayName:u("deviceManager.modelName")}),new c("maxApduLengthAccepted",{displayName:u("deviceManager.maxApdu"),flags:p}),new c("segmentationSupported",{displayName:u("deviceManager.segmentation"),flags:p}),new c("vendorId",{displayName:u("deviceManager.vId"),flags:p}),new b("listSize",{displayName:u("deviceManager.size")}),new c("encoding",{displayName:u("deviceManager.charSet"),flags:p}),new c("firmwareRevision",{displayName:u("deviceManager.fwRev"),flags:p}),new c("applicationSoftwareVersion",{displayName:u("deviceManager.appSwVer"),flags:p}),new c("duplicate",{displayName:u("deviceManager.dup"),flags:p})],y={};return y.make=function(){return s.make({columns:f})},y}),define("nmodule/bacnet/rc/wb/mgr/model/columns/MacAddressMgrColumn",["baja!","underscore","Promise","nmodule/bacnet/rc/baja/datatypes/BacnetAddress","nmodule/bacnet/rc/baja/datatypes/BacnetOctetString","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/MgrColumn","nmodule/js/rc/log/Log","baja!bacnet:BacnetDeviceObject"],function(e,t,n,r,o,a,i,c){"use strict";var s=function(e,t){a.call(this,e,t)};return s.prototype=Object.create(a.prototype),s.prototype.constructor=s,s.prototype.getValueFor=function(e){var t=e.getSubject().getAddress(),n=t.getMacAddress();try{return r.bytesToString(t.getAddressType(),n.getBytes())}catch(e){return c.logMessage("MacAddressMgrColumn",c.Level.FINE,"Could not parse address: "+String(e)),""}},s.$getAddressType=function(e){return e.indexOf(".")>0?2:e.indexOf(":")>0?1:"null"!==e&&e.length<=4?3:0},s.$macStringToBytes=function(e,t){var n=0;return 2===e&&(n=t.indexOf(":")>-1?5:4),r.stringToBytes(e,n,t)},s.prototype.mgrValidate=function(e,t,r){for(var o,a,i=0;i<t.length;i++)try{a=t[i],null!==a&&(o=s.$getAddressType(a),s.$macStringToBytes(o,a))}catch(e){return n.reject(new Error(e))}return n.resolve()},s.prototype.commit=function(e,t,r){var a,c,u,d=t.getSubject(),l=d.getAddress(),p=r&&r.batch,m=r&&r.progressCallback;return a=s.$getAddressType(e),c=s.$macStringToBytes(a,e),u=n.all([l.set({slot:"addressType",value:a,batch:p}),l.set({slot:"macAddress",value:o.make(c),batch:p})]),m&&m(i.COMMIT_READY),u},s}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceMgrModel",["baja!","baja!bacnet:BacnetAddress,bacnet:BacnetDevice,bacnet:BacnetDeviceObject,driver:Device","lex!bacnet","nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn","nmodule/bacnet/rc/wb/mgr/model/columns/MacAddressMgrColumn","nmodule/driver/rc/wb/mgr/DeviceMgrModel","nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn","nmodule/webEditors/rc/wb/mgr/MgrTypeInfo","nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn","nmodule/webEditors/rc/wb/table/model/Column"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m){"use strict";function g(e){return j.get(e)}var b=e.lt("bacnet:BacnetAddress"),f=e.lt("bacnet:BacnetDevice"),y=e.lt("bacnet:BacnetDeviceObject"),h=e.lt("driver:Device"),v=m.flags.EDITABLE,E=m.flags.READONLY,T=m.flags.UNSEEN,j=n[0],w=[new p,new s({flags:v}),new i("exts",{component:e.$("bacnet:BacnetDevice")}),new r,new d("status",{type:h,flags:E}),new l("address/networkNumber",{displayName:g("deviceManager.network"),type:b,flags:v}),new o("address/macAddress",{displayName:g("deviceManager.mac"),type:b,flags:v}),new l("config/deviceObject/maxAPDULengthAccepted",{displayName:g("deviceManager.maxApdu"),type:y,flags:T}),new l("config/deviceObject/segmentationSupported",{displayName:g("deviceManager.segmentation"),type:y,flags:T}),new l("config/deviceObject/vendorName",{displayName:g("deviceManager.vendorName"),type:y,flags:E}),new l("config/deviceObject/modelName",{displayName:g("deviceManager.modelName"),type:y,flags:E}),new l("config/deviceObject/firmwareRevision",{displayName:g("deviceManager.fwRev"),type:y,flags:E}),new l("config/deviceObject/applicationSoftwareVersion",{displayName:g("deviceManager.appSwVer"),type:y,flags:E}),new d("characterSet",{displayName:g("deviceManager.charSet"),type:f,flags:T}),new d("enabled",{type:h,flags:v|T}),new d("health",{type:h,flags:T}),new d("useCov",{type:f,flags:v|T}),new d("maxCovSubscriptions",{type:f,flags:v|T}),new d("covSubscriptions",{type:f,flags:T})],S={};return S.make=function(e,t,n){return c.make(t).then(function(t){return new a({columns:w,component:e,newTypes:t,folderType:n})})},S}),define("hbs!nmodule/bacnet/rc/wb/mgr/template/BacnetDeviceUxManager",["Handlebars"],function(e){var t=e.template({compiler:[8,">= 4.3.0"],main:function(e,t,n,r,o){var a,i=e.lookupProperty||function(e,t){if(Object.prototype.hasOwnProperty.call(e,t))return e[t]};return'<div class="mgr-job-bar-container ux-fg"></div>\n<div class="mgr-pane-container">\n  <div class="split-pane horizontal-percent">\n    <div class="split-pane-component mgr-pane-top">\n      <div class="mgr-discovery-pane">\n        <div class="mgr-pane-title-container ux-fg">\n          <span class="mgr-pane-title">'+e.escapeExpression((a=null!=(a=i(n,"discoveryTitle")||(null!=t?i(t,"discoveryTitle"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"discoveryTitle",hash:{},data:o,loc:{start:{line:7,column:39},end:{line:7,column:57}}}):a))+'</span>\n          <span class="showHideMenu multiPaneShowHideMenu mgr-show-hide-menu-discovery"></span>\n          <span class="mgr-pane-object-count discovery-table-object-count"></span>\n        </div>\n        <div class="discoveryTable mgr-table">\n          <div class="tableContainer"></div>\n        </div>\n      </div>\n    </div>\n    <div class="split-pane-divider mgr-split-pane-divider">\n      <div class="split-pane-divider-inner"></div>\n    </div>\n    <div class="split-pane-component mgr-pane-bottom">\n      <div class="mgr-pane-title-container ux-fg">\n        <span class="mgr-pane-title">'+e.escapeExpression((a=null!=(a=i(n,"databaseTitle")||(null!=t?i(t,"databaseTitle"):t))?a:e.hooks.helperMissing,"function"==typeof a?a.call(null!=t?t:e.nullContext||{},{name:"databaseTitle",hash:{},data:o,loc:{start:{line:21,column:37},end:{line:21,column:54}}}):a))+'</span>\n        <span class="showHideMenu multiPaneShowHideMenu mgr-show-hide-menu-main"></span>\n        <span class="mgr-pane-object-count main-table-object-count"></span>\n      </div>\n      <div class="mainTable mgr-table">\n        <div class="tableContainer"></div>\n      </div>\n    </div>\n  </div>\n</div>\n<div class="commandContainer mgr-action-bar"></div>'},useData:!0});return e.registerPartial("nmodule/bacnet/rc/wb/mgr/template/BacnetDeviceUxManager",t),t}),define("nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager",["baja!","lex!bacnet,webEditors","jquery","Promise","underscore","nmodule/bacnet/rc/baja/datatypes/BacnetAddress","nmodule/bacnet/rc/baja/datatypes/BacnetUnsigned","nmodule/bacnet/rc/baja/datatypes/DiscoveryNetworks","nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand","nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand","nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand","nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceLearnModel","nmodule/bacnet/rc/wb/mgr/model/BacnetDeviceMgrModel","nmodule/driver/rc/wb/mgr/DeviceMgr","nmodule/webEditors/rc/fe/feDialogs","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/wb/PropertySheet","nmodule/webEditors/rc/wb/mgr/componentStatusUtils","nmodule/webEditors/rc/wb/mgr/MgrTypeInfo","nmodule/webEditors/rc/wb/mgr/mgrUtils","nmodule/webEditors/rc/wb/mgr/MgrLearn","nmodule/webEditors/rc/wb/tree/TreeNode","nmodule/js/rc/log/Log","hbs!nmodule/bacnet/rc/wb/mgr/template/BacnetDeviceUxManager","css!nmodule/bacnet/rc/bacnet","baja!bacnet:BacnetDevice,bacnet:BacnetDeviceFolder,bacnet:BacnetObjectIdentifier,bacnet:BacnetObjectType,bacnet:DiscoveryDevice"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m,g,b,f,y,h,v,E,T,j,w){"use strict";function S(e){return x.get(e)}function A(e){return o.filter(e,function(e){return e.getType().is(M)})}function B(e){return o.map(A(e),function(e){return e.getConfig().getDeviceObject()})}function N(t,n){var o=t.getSubscriber();return t.getNetwork().isMounted()&&n.length?o.subscribe(n).then(function(){var t,a=new e.comm.Batch;return t=r.map(A(n),function(e){return e.getConfig().loadSlots({batch:a}).then(function(){return e.getConfig().getDeviceObject()})}),a.commit(),t.then(function(e){return o.subscribe(e)})}).catch(function(e){j.logMessage("BacnetDeviceUxManager",R.WARNING,"Could not subscribe devices: "+String(e))}):r.resolve()}function D(e){var t=String(e.deviceName),n=new T(t,t);return n.getIcon=o.constant(O),n.mayHaveKids=o.constant(!1),n.value=o.constant(e),n}function I(e){var t,n,a=e.getLearnModel(),i=a.getRows().length;return t=o.map(e.$discoveries||[],D),n=i?a.removeRows(0,i):r.resolve(),n.then(function(){return a.insertRows(t,0)})}var O=e.Icon.make(["module://icons/x16/device.png"]),C=v.getMainTableSelectedSubjects,$=y.addComponentStatusCss,x=t[0],k=t[1],M=e.lt("bacnet:BacnetDevice"),F=e.lt("bacnet:BacnetDeviceFolder"),R=j.Level,P=function(t){var n;m.call(this,o.extend({moduleName:"bacnet",keyName:"BacnetDeviceUxManager",folderType:F,subscriptionDepth:1},t)),E(this),n=this.finishDiscoveryTableRow,this.finishDiscoveryTableRow=function(t,r){return n.call(this,t,r).then(function(){return t.getSubject().getDuplicate()&&$(e.Status.fault,r),r})}};return P.prototype=Object.create(m.prototype),P.prototype.constructor=P,P.prototype.doInitialize=function(e){var t=this;return t.on("jobcomplete",function(e){e.getType().is("bacnet:BacnetDiscoverDevicesJob")&&t.$discoveryJobComplete(e,t)}),m.prototype.doInitialize.call(t,e,{html:w({databaseTitle:k.get("mgr.titlePane.database"),discoveryTitle:k.get("mgr.titlePane.discovered")})})},P.prototype.resubscribeForNewFolderDepth=function(){var e=this,t=e.getModel().getComponentSource(),n=t.getContainer(),a=e.getSubscriber(),i=t.getComponents(),c=a.getComponents();return N(e,o.difference(i,c)).then(function(){var e=i.concat(B(i)).concat(n),t=o.difference(c,e);return t.length?a.unsubscribe(t):r.resolve()})},P.prototype.componentChanged=function(e,t){if("localTime"!==t.getName())return m.prototype.componentChanged.apply(this,arguments)},P.prototype.doLoad=function(t){var n=this,r=n.getModel(),o=r.getComponentSource().getComponents();return N(n,o).then(function(){return m.prototype.doLoad.call(n,t)}).then(function(){var t=v.getMainTableSelection(n);n.$tableSelectionHandler=function(){n.onMainTableSelectionChanged(t)},t.on("changed",n.$tableSelectionHandler),n.$deviceAddedHandler=function(t){var r=this&&this.get(t);return r&&e.hasType(r,M)&&N(n,[r]),null},n.getSubscriber().attach("added",n.$deviceAddedHandler)})},P.prototype.doDestroy=function(){var e,t=this;return t.$tableSelectionHandler&&(e=v.getMainTableSelection(t),e.removeListener("changed",t.$tableSelectionHandler),delete t.$tableSelectionHandler),t.$deviceAddedHandler&&(t.getSubscriber().detach("added",t.$deviceAddedHandler),delete t.$deviceAddedHandler),m.prototype.doDestroy.apply(t,arguments)},P.prototype.onMainTableSelectionChanged=function(e){v.findCommand(this,s).setEnabled(this.isSingleDeviceSelected())},P.prototype.makeCommands=function(){return m.prototype.makeCommands.apply(this,arguments).concat([new u(this),new s(this),new d(this)])},P.prototype.getNetwork=function(){return b.closest(this.value(),e.lt("bacnet:BacnetNetwork"))},P.prototype.isSingleDeviceSelected=function(){var e=C(this);return 1===e.length&&e[0].getType().is("bacnet:BacnetDevice")},P.prototype.makeModel=function(e){return p.make(e,[M],this.getFolderType())},P.prototype.makeLearnModel=function(){return l.make()},P.prototype.$discoveryJobComplete=function(t){var n=this;t.loadSlots().then(function(){var n;return t.isMounted()&&(n=t.lease({comps:[t],time:e.RelTime.make({minutes:1})})),n}).then(function(){var e=t.getSlots().properties();return n.$discoveries=e.is("bacnet:DiscoveryDevice").toValueArray(),I(n)}).catch(e.error)},P.prototype.$getRouterTable=function(t){return e.Ord.make(String(t.getNavOrd())+"/bacnetComm/network/routerTable").get()},P.prototype.makeDiscoveryNetworks=function(e){return this.$getRouterTable(e).then(function(e){var t,n;return t=e.getSlots().properties().is("bacnet:BacnetRouterEntry").toValueArray(),n=o.invoke(t,"getDnet"),c.make(!1,n)})},P.prototype.showDiscoveryConfigDialog=function(t){var r=e.$("bacnet:DeviceDiscoveryConfig");return this.makeDiscoveryNetworks(t).then(function(e){return r.setNetworks(e),g.showFor({title:S("deviceManager.discover.description"),dom:n("<div/>"),value:r,type:f,properties:{showFooter:!1,showHeader:!1}}).then(function(e){return e?r:null})})},P.prototype.doDiscover=function(){var t=this,n=t.getNetwork();return t.showDiscoveryConfigDialog(n).then(function(r){if(r)return n.submitDeviceManagerJob(r).then(function(n){return n=e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}),t.setJob(n)})})},P.prototype.getTypesForDiscoverySubject=function(){return h.make(M)},P.prototype.getProposedValuesFromDiscovery=function(t){var n=t.getAddress(),r=n.getAddressType(),o=n.getMacAddress(),c=!!t.getServicesSupported().isBitSet(5);return{name:t.getDeviceName(),values:{objectId:t.getObjectId(),macAddress:a.bytesToString(r,o.getBytes()),networkNumber:e.Integer.make(t.getAddress().getNetworkNumber()),maxAPDULengthAccepted:i.make(t.getMaxApduLengthAccepted()),segmentationSupported:t.getSegmentationSupported(),vendorName:t.getVendorName(),modelName:t.getModelName(),firmwareRevision:t.getFirmwareRevision(),applicationSoftwareVersion:t.getApplicationSoftwareVersion(),characterSet:t.getEncoding(),useCov:c}}},P.prototype.isExisting=function(t,n){var r;return!!e.hasType(n,"bacnet:BacnetDevice")&&(r=n.getConfig(),t.getObjectId().encodeToString()===r.getDeviceObject().getObjectId().encodeToString())},P.prototype.saveStateForOrd=function(){var t=this,n={};return t.$discoveries&&(n.$discoveries=o.map(t.$discoveries,function(t){return e.bson.encodeValue(t)})),n},P.prototype.restoreStateForOrd=function(t){return t.$discoveries?(this.$discoveries=o.map(t.$discoveries,function(t){return e.bson.decodeValue(t)}),I(this)):r.resolve()},P}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetPointLearnModel",["lex!bacnet","nmodule/webEditors/rc/wb/table/model/columns/IconColumn","nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn","nmodule/webEditors/rc/wb/table/tree/TreeTableModel"],function(e,t,n,r){"use strict";function o(e){return a.get(e)}var a=e[0],i=function(){t.apply(this,arguments)};i.prototype=Object.create(t.prototype),i.prototype.constructor=i,i.prototype.getValueFor=function(e){return e.getTreeNode().$icon};var c=[new i,new n("objectName",{displayName:o("learn.objectName")}),new n("objectId",{displayName:o("learn.objectId")}),new n("propertyIdentifier",{displayName:o("pointManager.property")}),new n("index",{displayName:o("pointManager.index")}),new n("value",{displayName:o("pointManager.value")}),new n("description",{displayName:o("pointManager.description")})],s={};return s.make=function(){return r.make({columns:c})},s}),define("nmodule/bacnet/rc/wb/mgr/model/BacnetPointManagerModel",["baja!","lex!","lex!bacnet,driver","Promise","nmodule/driver/rc/wb/mgr/PointMgrModel","nmodule/webEditors/rc/fe/baja/util/typeUtils","nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn","nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn","nmodule/webEditors/rc/wb/table/model/Column","baja!bacnet:BacnetPointFolder,bacnet:BacnetObjectIdentifier,bacnet:BacnetProxyExt,bacnet:BacnetBooleanProxyExt,bacnet:BacnetEnumProxyExt,bacnet:BacnetNumericProxyExt,bacnet:BacnetStringProxyExt,control:ControlPoint,driver:ProxyExt"],function(e,t,n,r,o,a,i,c,s,u,d,l,p){"use strict";function m(e){return f.get(e)}function g(){return[new d,new c({flags:j|S}),new i({flags:w}),new l({flags:w|j}),new A("out",{displayName:y.get("out"),flags:S}),new u("proxyExt/enabled",{type:v,flags:w|j}),new u("proxyExt/objectId",{displayName:m("learn.objectId"),type:E,flags:w}),new N("proxyExt/propertyId",{displayName:m("pointManager.property"),type:E,flags:w}),new u("proxyExt/propertyArrayIndex",{displayName:m("pointManager.index"),type:E,flags:w}),new u("proxyExt/tuningPolicyName",{type:v,flags:w|j}),new u("proxyExt/dataType",{displayName:m("pointManager.dataType"),type:E,flags:w|S|j}),new u("proxyExt/readStatus",{displayName:m("pointManager.read"),type:E,flags:w|S}),new u("proxyExt/writeStatus",{displayName:m("pointManager.write"),type:E,flags:w|S}),new u("proxyExt/deviceFacets",{type:E,flags:w|j|S}),new s("facets",{type:h,flags:w|j}),new B("proxyExt/conversion",{type:v,flags:w|j}),new u("proxyExt/readValue",{type:v,flags:j}),new u("proxyExt/writeValue",{type:v,flags:j}),new u("proxyExt/faultCause",{type:v,flags:j})]}function b(t){return t.is("control:BooleanPoint")?e.Facets.make({trueText:"true",falseText:"false"}):t.is("control:NumericPoint")?e.Facets.make({units:e.Unit.NULL,precision:1,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY}):t.is("control:EnumPoint")?e.Facets.make({range:e.EnumRange.DEFAULT}):e.Facets.DEFAULT}var f=n[0],y=n[1],h=e.lt("control:ControlPoint"),v=e.lt("driver:ProxyExt"),E=e.lt("bacnet:BacnetProxyExt"),T=e.lt("bacnet:BacnetPointFolder"),j=p.flags.UNSEEN,w=p.flags.EDITABLE,S=p.flags.READONLY,A=function(e,t){p.apply(this,arguments)};A.prototype=Object.create(p.prototype),A.prototype.constructor=A,A.prototype.getValueFor=function(e){return String(e.getSubject())};var B=function(e,t){u.apply(this,arguments)};B.prototype=Object.create(u.prototype),B.prototype.constructor=B,B.prototype.buildCell=function(e,t){var n=this.getProposedValueFor(e);return a.getTypeDisplayName(n.getType()).then(function(e){t.text(e)})};var N=function(e,t){u.apply(this,arguments)};N.prototype=Object.create(u.prototype),N.prototype.constructor=N,N.prototype.buildCell=function(e,t){var n,o=this.getProposedValueFor(e),a=o.getOrdinal(),i=o.getRange();if(i.isFrozenOrdinal(a))t.text(i.getFrozenType().getDisplayTag(a));else if(n=e.getSubject().getProxyExt().getFacets("propertyId"),(i=n&&n.get("range"))&&i.isFrozenOrdinal(a))t.text(i.getFrozenType().getDisplayTag(a));else{if(i&&i.isDynamicOrdinal(a))return this.buildCellFromRangeFacets(i,a,t);t.text(String(a))}return r.resolve()},N.prototype.buildCellFromRangeFacets=function(t,n,o){var a=t.getTag(n),i=t.getOptions(),c=i&&i.get("lexicon");return c?this.getDisplayTagFromLexicon(c,a).then(function(t){o.text(t||e.SlotPath.unescape(a))}):(o.text(e.SlotPath.unescape(a)),r.resolve())},N.prototype.getDisplayTagFromLexicon=function(e,n){return t.module(e).then(function(e){return e.get(n)})};var D=function(e){o.call(this,{columns:g(),component:e.component,newTypes:e.newTypes,folderType:T})};return D.prototype=Object.create(o.prototype),D.prototype.constructor=D,D.prototype.newInstance=function(t){return t.newInstance().then(function(t){var n,r=t.getType(),o=b(r);return n=r.is("control:BooleanPoint")?e.$("bacnet:BacnetBooleanProxyExt"):r.is("control:NumericPoint")?e.$("bacnet:BacnetNumericProxyExt"):r.is("control:EnumPoint")?e.$("bacnet:BacnetEnumProxyExt"):r.is("control:StringPoint")?e.$("bacnet:BacnetStringProxyExt"):e.$("control:NullProxyExt"),t.set({slot:"facets",value:o}),t.setProxyExt(n),n.getType().is("driver:ProxyExt")&&n.setDeviceFacets(o.newCopy()),t})},D}),define("nmodule/bacnet/rc/wb/mgr/BacnetPointUxManager",["baja!","Promise","underscore","dialogs","nmodule/bacnet/rc/baja/enums/BacnetPropertyIdentifier","nmodule/bacnet/rc/wb/mgr/model/BacnetPointLearnModel","nmodule/bacnet/rc/wb/mgr/model/BacnetPointManagerModel","nmodule/bacnet/rc/util/BacnetConst","nmodule/bacnet/rc/util/ObjectTypeList","nmodule/bacnet/rc/util/PropertyInfo","nmodule/driver/rc/wb/mgr/PointMgr","nmodule/driver/rc/wb/mgr/PointMgrModel","nmodule/webEditors/rc/fe/baja/util/compUtils","nmodule/webEditors/rc/wb/mgr/MgrTypeInfo","nmodule/webEditors/rc/wb/mgr/MgrLearn","nmodule/webEditors/rc/wb/tree/TreeNode","css!nmodule/bacnet/rc/bacnet","baja!bacnet:BacnetPointFolder,bacnet:BacnetObjectType,bacnet:BacnetProxyExt,bacnet:DiscoveryPoint"],function(e,t,n,r,o,a,i,c,s,u,d,l,p,m,g,b){"use strict";function f(e,n){var r;return r=n.get("vendorObjectTypesFile"),r?s.make({ord:r}).then(function(t){return e.$vendorObjectTypeList=t,t}):t.resolve(null)}function y(e){return e.getSlots().properties().is("bacnet:DiscoveryPoint").toValueArray()}function h(e,n){var o=e.getJob().discover(n).then(function(n){return t.map(y(n),function(t){return E(e,t)})});return r.showLoading(J,o),o}function v(e,t){var n=t.getObjectId().getObjectType(),r=t.getPropertyId();return e.getPropertyInfo(n,r).then(function(e){switch(e.getAsnType()){case c.ASN_NULL:return k;case c.ASN_BOOLEAN:return M;case c.ASN_UNSIGNED:case c.ASN_INTEGER:return F;case c.ASN_REAL:case c.ASN_DOUBLE:return x;case c.ASN_OCTECT_STRING:case c.ASN_CHARACTER_STRING:case c.ASN_BIT_STRING:return k;case c.ASN_ENUMERATED:return e&&"bacnet:BacnetBinaryPv"===e.getType()?M:F;case c.ASN_DATE:case c.ASN_TIME:case c.ASN_OBJECT_IDENTIFIER:case c.ASN_CONSTRUCTED_DATA:case c.ASN_BACNET_ARRAY:case c.ASN_BACNET_LIST:case c.ASN_ANY:case c.ASN_CHOICE:case c.ASN_UNKNOWN_PROPRIETARY:return k;default:return R}})}function E(e,t){var n=t.getObjectName();return v(e,t).then(function(r){return new Z(n,t,e,r)})}function T(e){var n=e.getLearnModel(),r=n.getRows().length,o=n.getRootNode();return t.map(e.$discoveries||[],function(t){return E(e,t)}).then(function(e){return t.map(o.getKids(),function(e){return o.remove(e)}).then(function(){return t.map(e,function(e){return o.add(e)})}).then(function(){return(r?n.removeRows(0,r):t.resolve()).then(function(){return n.insertRows(e,0)})})})}function j(e,t){B(e,t,"Boolean")}function w(e,t){B(e,t,"Numeric")}function S(e,t){B(e,t,"Enum")}function A(e,t){B(e,t,"String")}function B(e,t,n){n="control:"+n,t?e.push(n+"Writable",n+"Point"):e.push(n+"Point",n+"Writable")}function N(e){return!(!e||!e.getKeys().length)}function D(e){return/^control:.+Writable$/.test(e.getType().toString())}function I(t){var n=z,r=t.toObject();return r[n]&&delete r[n],e.Facets.make(r)}function O(e,n,r){var o=e.getObjectId().getObjectType();if(D(n)){if(o===U.getOrdinal()||o===G.getOrdinal()||o===H.getOrdinal())return t.resolve(!0);if(o===q.getOrdinal()||o===Y.getOrdinal()||o===W.getOrdinal())return r.checkForPriorityArray(e.getObjectId())}return t.resolve(!1)}function C(e,n,r){var o=e.get("facets");return N(o)?t.resolve(o):r.discoverFacets(n)}function $(t,n,r,o,a){var i,c=t.get("facets");r&&(r.isEnum()&&(i=e.$(r.getType()).getRange(),r.isExtensible()&&(i=o.getEnumerationList().getEnumRange(r.getType())),i&&(n=e.Facets.make(n,{range:i}))),"all"===r.getFacetControl()?c=n:"units"===r.getFacetControl()?c=e.Facets.make({units:n.get("units")}):"no"!==r.getFacetControl()&&N(n)&&(c=n)),a.deviceFacets=c,c=I(c),a.facets=c}var x=e.Icon.make(["module://icons/x16/control/numericPoint.png"]),k=e.Icon.make(["module://icons/x16/control/stringPoint.png"]),M=e.Icon.make(["module://icons/x16/control/booleanPoint.png"]),F=e.Icon.make(["module://icons/x16/control/enumPoint.png"]),R=e.Icon.make(["module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png"]),P=e.lt("control:ControlPoint"),L=e.lt("bacnet:BacnetProxyExt"),_=e.lt("bacnet:BacnetPointFolder"),V=e.$("bacnet:BacnetObjectType"),U=V.get("analogOutput"),q=V.get("analogValue"),G=V.get("binaryOutput"),Y=V.get("binaryValue"),H=V.get("multiStateOutput"),W=V.get("multiStateValue"),z="priPV",J=500,X=n.once(function(e){return s.make(e?{ord:e}:void 0)}),K=function(e){d.call(this,n.extend({moduleName:"bacnet",keyName:"BacnetPointUxManager",folderType:_,subscriptionDepth:3},e)),g(this)};K.prototype=Object.create(d.prototype),K.prototype.constructor=K,K.prototype.doInitialize=function(e,n){var r=this,o=n&&n.objectTypeListOrd;return r.on("jobcomplete",function(e){e.getType().is("bacnet:BacnetDiscoverPointsJob")&&r.$discoveryJobComplete(e,r)}),t.all([d.prototype.doInitialize.apply(r,arguments),X(o)])},K.prototype.doLoad=function(e,n){var o,a=this,i=a.getDevice();return o=i.loadSlots().then(function(){return t.all([d.prototype.doLoad.apply(a,[e,n]),f(a,i)])}),r.showLoading(J,o),o},K.prototype.doDestroy=function(){return this.$vendorObjectTypeList&&delete this.$vendorObjectTypeList,d.prototype.doDestroy.apply(this,arguments)},K.prototype.getNewTypes=function(){return l.getDefaultNewTypes()},K.prototype.getDeviceExt=function(){return p.closest(this.value(),e.lt("bacnet:BacnetPointDeviceExt"))},K.prototype.componentChanged=function(e,t){var n,r;if(n=e.getType(),(n.is(P)||n.is(L)||n.is(_))&&!(t&&"readValue"===t.getName()&&(r=this.getModel().getColumn("readValue"))&&r.isUnseen()))return d.prototype.componentChanged.apply(this,arguments)},K.prototype.getDevice=function(){return this.getDeviceExt().getParent()},K.prototype.makeModel=function(e){return this.getNewTypes().then(function(t){return new i({component:e,newTypes:t})})};var Z=function(e,t,n,r){b.call(this,e,e),this.$discovery=t,this.$mgr=n,this.$icon=r};return Z.prototype=Object.create(b.prototype),Z.prototype.constructor=Z,Z.prototype.getIcon=function(){return this.$icon?this.$icon.getImageUris():[]},Z.prototype.$loadKids=function(e){return h(this.$mgr,this.$discovery).then(function(t){return e&&e.progressCallback&&e.progressCallback("commitReady"),t})},Z.prototype.value=function(){return this.$discovery},Z.prototype.mayHaveKids=function(){return this.$discovery.hasChildren()},K.prototype.getPropertyInfo=function(e,n){var r=this.getVendorPropertyInfo(e,n);return r?t.resolve(r):X().then(function(t){return r=t&&t.getPropertyInfo(e,n),r||(r=new u({name:o.tagForId(n),id:n,asnType:c.ASN_UNKNOWN_PROPRIETARY})),r})},K.prototype.getVendorPropertyInfo=function(e,t){return this.$vendorObjectTypeList?this.$vendorObjectTypeList.getPropertyInfo(e,t):null},K.prototype.makeLearnModel=function(){return a.make()},K.prototype.$setDiscoveryJobFromOrd=function(t){var n,r=this;return e.Ord.make(t).get().then(function(e){return n=e,r.setJob({jobOrOrd:n,depth:3})}).then(function(){return n})},K.prototype.$discoveryJobComplete=function(t){var n=this;t.loadSlots().then(function(){var e=t.getSlots().properties();return n.$discoveries=e.is("bacnet:DiscoveryPoint").toValueArray(),T(n)}).catch(e.error)},K.prototype.doDiscover=function(){var t=this;return t.getDeviceExt().submitPointDiscoveryJob().then(function(n){return n=e.Ord.make({base:e.Ord.make("station:"),child:n.relativizeToSession()}),t.$setDiscoveryJobFromOrd(n)})},K.prototype.getTypesForDiscoverySubject=function(e){var r=e.getObjectId().getObjectType(),o=e.getPropertyId();return this.getPropertyInfo(r,o).then(function(o){var a=[],i=o.getAsnType(),s=!1;switch(r!==U.getOrdinal()&&r!==G.getOrdinal()&&r!==H.getOrdinal()||(s=!0),i){case c.ASN_NULL:case c.ASN_BACNET_LIST:case c.ASN_CONSTRUCTED_DATA:return t.resolve([]);case c.ASN_BOOLEAN:j(a,s);break;case c.ASN_UNSIGNED:case c.ASN_INTEGER:S(a,s),j(a,s);break;case c.ASN_REAL:case c.ASN_DOUBLE:w(a,s);break;case c.ASN_ENUMERATED:o&&"bacnet:BacnetBinaryPv"===o.getType()&&j(a,s),S(a,s);break;case c.ASN_BACNET_ARRAY:e.getPropertyArrayIndex()>0&&(r===U.getOrdinal()||r===q.getOrdinal()?(w(a,!0),j(a,!0),S(a,!0)):r===G.getOrdinal()||r===Y.getOrdinal()?(j(a,!0),S(a,!0),w(a,!0)):r===H.getOrdinal()||r===W.getOrdinal()?(S(a,!0),w(a,!0),j(a,!0)):(w(a,!1),j(a,!1),S(a,!1)))}return A(a,!1),t.all(n.map(a,m.make))})},K.prototype.getProposedValuesFromDiscovery=function(t,n){var o,a=this,i=t.getObjectId(),c=t.getPropertyId();return o=a.getPropertyInfo(i.getObjectType(),c).then(function(r){var o,s=t.getIndex(),u=e.$("bacnet:BacnetPropertyIdentifier").get("presentValue"),d=t.getObjectName()||String(t.getObjectId()),l=a.getDevice(),p=a.getJob();return c!==u.getOrdinal()&&(d+="-"+t.getPropertyIdentifier()),s.length&&(d+="_"+s),o={name:d.replace(/\//g,"."),values:{objectId:t.getObjectId(),propertyId:e.DynamicEnum.make({ordinal:c,range:u.getRange()}),readStatus:"unsubscribed",writeStatus:"readonly"}},s&&(o.values.propertyArrayIndex=parseInt(s)),r&&(o.values.dataType=String(r.getDataType())),D(n)&&(o.values.writeStatus="writable"),O(t,n,p).then(function(e){return e&&(o.values.enabled=!1),C(t,i,p)}).then(function(e){return $(n,e,r,l,o.values),o})}),r.showLoading(J,o),o},K.prototype.isExisting=function(t,n){var r,o;return!!e.hasType(n,"control:ControlPoint")&&(r=n.getProxyExt(),o=t.getIndex()?parseInt(t.getIndex()):-1,r.getType().is("bacnet:BacnetProxyExt")&&r.getObjectId().getObjectType()===t.getObjectId().getObjectType()&&r.getObjectId().getInstanceNumber()===t.getObjectId().getInstanceNumber()&&r.getPropertyId().getTag().equals(t.getPropertyIdentifier())&&r.getPropertyArrayIndex()===o)},K.prototype.saveStateForKey=function(){var e=this.getJob(),t=e&&e.getNavOrd(),n=this.getDeviceExt(),r=n&&n.getNavOrd(),o={};return r&&(o.$pointExtOrd=r.toString()),t&&(o.$jobOrd=t.toString()),o},K.prototype.restoreStateForKey=function(n){var r=this.getDeviceExt(),o=r&&r.getNavOrd()
;return o&&n.$jobOrd&&n.$pointExtOrd&&o.toString()===n.$pointExtOrd?this.$setDiscoveryJobFromOrd(n.$jobOrd).catch(e.error):t.resolve()},K});