/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/webProfileConfigMgrAgent
 */
define(['baja!', 'baja!baja:User,web:WebProfileConfig', 'lex!web', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, BaseEditor, MgrColumn, MixinMgrColumn, Column) {
  'use strict';

  var webLex = lexs[0],
    userType = baja.lt('baja:User'),
    SHOULD_VALIDATE = BaseEditor.SHOULD_VALIDATE;
  var WebProfileConfigMgrColumn = function WebProfileConfigMgrColumn() {
    MixinMgrColumn.call(this, baja.lt('web:WebProfileConfig'), {
      type: userType,
      displayName: webLex.get('webProfileConfig'),
      flags: Column.flags.EDITABLE | Column.flags.UNSEEN
    });
  };
  WebProfileConfigMgrColumn.prototype = Object.create(MixinMgrColumn.prototype);
  WebProfileConfigMgrColumn.prototype.constructor = WebProfileConfigMgrColumn;
  WebProfileConfigMgrColumn.prototype.getConfigFor = function (rows) {
    var config = MixinMgrColumn.prototype.getConfigFor.apply(this, arguments);
    var props = {
      alwaysExpand: true
    };
    props[SHOULD_VALIDATE] = true;
    config.properties = props;
    return config;
  };
  WebProfileConfigMgrColumn.prototype.commit = function (value, row, params) {
    var user = row.getSubject(),
      name = this.getName(),
      config = user.get(name),
      batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      prom;
    if (config.isMounted()) {
      prom = config.serverSideCall({
        typeSpec: 'webEditors:TypeConfigSSCHandler',
        methodName: 'syncFrom',
        value: value,
        batch: batch
      });
    } else {
      prom = user.set({
        slot: name,
        value: value,
        batch: batch
      });
    }
    if (progressCallback) {
      progressCallback(MgrColumn.COMMIT_READY);
    }
    return prom;
  };
  var exports = {};

  //TODO: requireExactTypeMatch()

  exports.getColumns = function () {
    return [new WebProfileConfigMgrColumn()];
  };
  return exports;
});
