function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/* jshint browser: true */

define(['baja!', 'baja!gx:Size', 'lex!pdf'], function (baja, types, lexes) {
  'use strict';

  var _lexes = _slicedToArray(lexes, 1),
    lex = _lexes[0];
  var portrait = 'pageSize.orient.portrait';
  var landscape = 'pageSize.orient.landscape';
  var pageSizeList = 'pageSize.list';

  /**
   * API Status: **Private**
   * @module nmodule/webEditors/rc/wb/util/pageSizeUtils
   */
  var exports = {};
  exports.getList = function () {
    return lex.get(pageSizeList).split(';');
  };
  /**
   * Get a list of all the listed page sizes in the lexicon. As well as useful information about each. The fields on
   * each object in the list are as follows:
   *
   * key: lexicon value for the page size
   * editorKey: lexicon key for displayName (useful for the PageSizeEditor)
   * displayName: the lexicon display value for the page size
   * width: width of the page size
   * height: height of the page size
   *
   * @private
   * @returns {Array}
   */
  exports.$getPageDimensions = function () {
    var list = exports.getList();
    return list.map(function (sizeText) {
      var displayName = lex.get('pageSize.' + sizeText + '.displayName');
      var width = lex.get('pageSize.' + sizeText + '.width');
      var height = lex.get('pageSize.' + sizeText + '.height');
      return {
        key: sizeText,
        editorKey: 'pageSize.' + sizeText + '.displayName',
        displayName: displayName,
        width: width,
        height: height
      };
    });
  };

  /**
   * Get a list of all the listed page orientations. These include portrait and landscape. Each entry in the list
   * contains the following fields:
   *
   * editorKey: lexicon key for the display name of the orientation
   * text: display value of the orientation
   *
   * @private
   * @returns {Array}
   */
  exports.$getOrientations = function () {
    return [{
      editorKey: portrait,
      text: lex.get(portrait)
    }, {
      editorKey: landscape,
      text: lex.get(landscape)
    }];
  };

  /**
   * Given a Size type, return the matching page orientation and size.
   *
   *
   * @param {module:nmodule/gx/rc/baja/Size} size
   * @returns {object|null}
   */
  exports.getSizeAndOrientation = function (size) {
    var orientation = size.getWidth() > size.getHeight() ? landscape : portrait,
      displaySize,
      sizes = lex.get(pageSizeList).split(';'),
      key = '';
    for (var i = 0; i < sizes.length; i++) {
      var width = +parseFloat(lex.get('pageSize.' + sizes[i] + '.width'));
      var height = +parseFloat(lex.get('pageSize.' + sizes[i] + '.height'));
      var displayNameKey = 'pageSize.' + sizes[i] + '.displayName';
      var displayName = lex.get(displayNameKey);
      var matchFound = Math.abs(size.getWidth() - width) < 0.1 && Math.abs(size.getHeight() - height) < 0.1 || Math.abs(size.getWidth() - height) < 0.1 && Math.abs(size.getHeight() - width) < 0.1;
      if (matchFound) {
        displaySize = displayName;
        key = displayNameKey;
        break;
      }
    }
    if (!displaySize) {
      // set to custom
      displaySize = lex.get('pageSize.custom.displayName');
      key = 'pageSize.custom.displayName';
    }
    return {
      size: displaySize,
      orientation: orientation,
      sizeKey: key
    };
  };

  /**
   * Given the display values for size and orientation, return a size value. If no match is found, throw an error.
   * @param {string} size
   * @param {string} orientation
   * @returns {module:nmodule/gx/rc/baja/Size}
   */
  exports.makeFromSizeAndOrientation = function (size, orientation) {
    var landscapeText = lex.get(landscape);
    var portraitText = lex.get(portrait);
    var isLandscape = orientation === landscapeText;
    var isPortrait = orientation === portraitText;
    var dimensionList = exports.$getPageDimensions();
    for (var i = 0; i < dimensionList.length; i++) {
      var dimensions = dimensionList[i];
      if (dimensions.displayName === size) {
        var smaller = Math.min(dimensions.width, dimensions.height);
        var larger = Math.max(dimensions.width, dimensions.height);
        if (isPortrait) {
          return baja.$('gx:Size', smaller, larger);
        } else if (isLandscape) {
          return baja.$('gx:Size', larger, smaller);
        }
      }
    }
    throw new Error("Could not find matching dimensions for page with size = \"".concat(size, "\" and orientation = \"").concat(orientation, "\""));
  };
  return exports;
});
