/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/UserFacetsEditor
 */
define(['baja!', 'baja!baja:UnitConversion', 'underscore', 'nmodule/webEditors/rc/fe/baja/FacetsEditor'], function (baja, types, _, FacetsEditor) {
  'use strict';

  var DEFAULT_UNIT_CONVERSION = baja.DynamicEnum.make({
    en: 'baja:UnitConversion'
  });

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/UserFacetsEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/FacetsEditor
   * @param params
   */
  var UserFacetsEditor = function UserFacetsEditor(params) {
    FacetsEditor.call(this, _.extend({}, params, {
      keyName: 'UserFacetsEditor',
      formFactor: 'compact',
      properties: {
        allowAdd: false,
        allowChangeType: false,
        allowDelete: false,
        allowRename: false,
        showHeader: false,
        uxFieldEditors: baja.Facets.make({
          timeFormat: 'webEditors:TimeFormatEditor'
        })
      }
    }));
  };
  UserFacetsEditor.prototype = Object.create(FacetsEditor.prototype);
  UserFacetsEditor.prototype.constructor = UserFacetsEditor;
  UserFacetsEditor.prototype.$makeDisplayOnly = function () {
    //TODO: come up with a better way of doing this.
  };
  UserFacetsEditor.prototype.doLoad = function (facets) {
    facets = baja.Facets.make({
      timeFormat: facets.get('timeFormat') || '',
      unitConversion: facets.get('unitConversion') || DEFAULT_UNIT_CONVERSION
    });
    return FacetsEditor.prototype.doLoad.call(this, facets);
  };
  return UserFacetsEditor;
});
