/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/wb/util/TransferDataManager
 */
define(['baja!', 'underscore', 'Promise', 'bajaux/dragdrop/NavNodeEnvelope', 'nmodule/webEditors/rc/util/SyncedSessionStorage'], function (baja, _, Promise, NavNodeEnvelope, SyncedSessionStorage) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////
  var getStorage = SyncedSessionStorage.getInstance;
  getStorage(); //kick it off immediately

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/TransferDataManager
   */
  var TransferDataManager = function TransferDataManager() {};

  /**
   *
   * @returns {Promise} resolves to an array of `NavNode`s
   */
  TransferDataManager.prototype.getLinkMark = function () {
    return getStorage().then(function (storage) {
      var linkMarkString = storage.getItem('LinkMark'),
        linkMarks = linkMarkString ? JSON.parse(linkMarkString) : [],
        linkMark = linkMarks[0];

      // TODO Really should check to make sure all linkMarks have a typeSpec,
      if (linkMark && linkMark.typeSpec) {
        var envelope = new NavNodeEnvelope(linkMarks);
        return envelope.toValues();
      }
    });
  };

  /**
   *
   * @param {Array} nodes - Array of baja:INavNode
   * @returns {Promise<String>} Promise that will be resolved to the JSON stringify
   *    of the NavNodes.
   */
  TransferDataManager.prototype.setLinkMark = function (nodes) {
    // If nodes is falsy, interpret it as an empty array.
    if (!nodes) {
      return getStorage().then(function (storage) {
        var item = '[]';
        storage.setItem('LinkMark', item);
        return item;
      });
    }

    // Reject if nodes is not an array of baja:INavNodes.
    if (!_.isArray(nodes) || !baja.hasType(nodes[0], 'baja:INavNode')) {
      return Promise.reject(new Error('TransferDataManager.setLinkMark ' + 'requires an array of NavNodes'));
    }

    // Convert array of INavNodes to a JSON string using NavNodeEnvelope
    var envelope = new NavNodeEnvelope(nodes);
    return Promise.all([getStorage(), envelope.toJson()]).then(function (args) {
      var storage = args[0],
        json = JSON.stringify(args[1]);
      storage.setItem('LinkMark', json);
      return json;
    });
  };
  TransferDataManager.INSTANCE = new TransferDataManager();
  return {
    getInstance: function getInstance() {
      return TransferDataManager.INSTANCE;
    }
  };
});
