function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/CertificateAliasEditor
 */
define(['baja!', 'nmodule/webEditors/rc/fe/baja/AdapterEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils'], function (baja, AdapterEditor, spaceUtils, subscriberUtils) {
  'use strict';

  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCertManagerService = leaseWhenNeeded(function (base) {
    return resolveService('platCrypto:CertManagerService', base);
  });

  /**
   * Editor for choosing a certificate alias. It will retrieve the list of
   * certificate alias names using
   * `platCrypto:CertManagerService.getCertificateAliases`. It supports the
   * following bajaux Properties:
   *
   * - `storeId`: (string, default `'USER_KEY_STORE'`) selects which crypto
   *   store to query from. Should be a member of
   *   `com.tridium.crypto.core.io.CryptoStoreId`.
   * - `purposeId`: (string, default `'SERVER_CERT'`) selects which key purpose to filter
   *   the certificate alias names on. Use an empty string to show all aliases.
   *   Should be a member of `com.tridium.crypto.core.cert.KeyPurpose`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/CertificateAliasEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/AdapterEditor
   */
  return /*#__PURE__*/function (_AdapterEditor) {
    function CertificateAliasEditor() {
      _classCallCheck(this, CertificateAliasEditor);
      return _callSuper(this, CertificateAliasEditor, arguments);
    }
    _inherits(CertificateAliasEditor, _AdapterEditor);
    return _createClass(CertificateAliasEditor, [{
      key: "toConfig",
      value:
      /**
       * Build as a StringEditor, with the list of certificate aliases retrieved
       * from the station as the datalist.
       * @param {string} certificateName
       * @returns {Promise.<object>}
       */
      function toConfig(certificateName) {
        return this.$resolveCertificateAliasNames()["catch"](function () {
          return [];
        }).then(function (certNames) {
          return {
            value: certificateName,
            properties: {
              datalist: certNames.join(';'),
              'relevant-filter': false
            },
            formFactor: 'mini'
          };
        });
      }

      /**
       * @private
       * @returns {Promise.<string[]>}
       */
    }, {
      key: "$resolveCertificateAliasNames",
      value: function $resolveCertificateAliasNames() {
        var props = this.properties();
        var storeId = props.getValue('storeId');
        var purposeId = props.getValue('purposeId');
        if (typeof storeId !== 'string') {
          storeId = 'USER_KEY_STORE';
        }
        if (typeof purposeId !== 'string') {
          purposeId = 'SERVER_CERT';
        }
        return this.$resolveCertManagerService().then(function (service) {
          return service.rpc('getCertificateAliases', storeId, purposeId);
        });
      }

      /**
       * @private
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$resolveCertManagerService",
      value: function $resolveCertManagerService() {
        return this.getOrdBase().then(getCertManagerService);
      }
    }]);
  }(AdapterEditor);
});
