function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/tree/TreeTable
 */
define(['bajaux/commands/Command', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (Command, CommandButton, $, Promise, _, fe, Table, TreeTableModel) {
  'use strict';

  function makeSpacers(count) {
    return _.map(_.range(0, count), makeSpacer);
  }
  function makeSpacer() {
    var spacer = document.createElement('div');
    spacer.className = 'spacer';
    return spacer;
  }

  /**
   * A table backed by a
   * {@link module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel TreeTableModel},
   * that provides buttons to expand/collapse sections of the tree.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/tree/TreeTable
   * @extends module:nmodule/webEditors/rc/wb/table/Table
   */
  var TreeTable = function TreeTable() {
    Table.apply(this, arguments);
  };
  TreeTable.prototype = Object.create(Table.prototype);
  TreeTable.prototype.constructor = TreeTable;

  /**
   * Adds `TreeTable` class.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  TreeTable.prototype.doInitialize = function (dom) {
    dom.addClass('TreeTable');
    return Table.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Loads in a `TreeTableModel`.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel} tableModel
   * @returns {Promise}
   */
  TreeTable.prototype.doLoad = function (tableModel) {
    if (!(tableModel instanceof TreeTableModel)) {
      throw new Error('TreeTableModel required');
    }
    return Table.prototype.doLoad.apply(this, arguments);
  };

  /**
   * Remove the `TreeTable` class and destroy child widgets.
   *
   * @returns {Promise}
   */
  TreeTable.prototype.doDestroy = function () {
    var that = this;
    that.jq().removeClass('TreeTable');
    return that.getChildWidgets().destroyAll().then(function () {
      return Table.prototype.doDestroy.apply(that, arguments);
    });
  };

  /**
   * Build the cell for the specified column and row. For the first column,
   * indent to show the tree depth, and add a button to expand/collapse the
   * tree at that row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Column} column
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise}
   */
  TreeTable.prototype.buildCell = function (column, row, dom) {
    var model = this.getModel();
    var el = dom[0];
    return Promise.resolve(Table.prototype.buildCell.apply(this, arguments)).then(function () {
      if (model.getColumnIndex(column) !== 0) {
        return;
      } //first column only

      var prom;
      if (model.isExpandable(row)) {
        var buttonEl = document.createElement('button');
        buttonEl.type = 'button';
        buttonEl.className = 'expand';
        buttonEl.classList.add(model.isExpanded(row) ? 'expanded' : 'collapsed');
        el.prepend(buttonEl);
        var buttonDom = $(buttonEl);
        prom = fe.buildFor({
          type: CommandButton,
          dom: buttonDom,
          value: new Command({
            func: function func() {
              var expanded = model.isExpanded(row);
              buttonDom.toggleClass('expanded', !expanded).toggleClass('collapsed', expanded);
              return model.toggle(row);
            }
          })
        });
      }
      el.prepend.apply(el, _toConsumableArray(makeSpacers(model.getDepth(row))));
      return prom;
    });
  };
  return TreeTable;
});
