function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'Promise', 'underscore', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/menu/Separator'], function (Command, CommandGroup, Promise, _, ExportCommand, CommandGroupContextMenu, Separator) {
  'use strict';

  var BLANK_ICON = 'module://icons/x16/blank.png',
    CHECK_ICON = 'module://icons/x16/whiteIcons/check.png';

  /**
   * Default context menu for a Table. Will include an export command and
   * commands to show/hide individual columns.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   */
  var DefaultTableContextMenu = function DefaultTableContextMenu(table) {
    CommandGroupContextMenu.apply(this, arguments);
    this.$table = table;
  };
  DefaultTableContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  DefaultTableContextMenu.prototype.constructor = DefaultTableContextMenu;

  /**
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  DefaultTableContextMenu.prototype.toContextMenu = function () {
    var table = this.$table;
    return Promise.all([getExportCommand(table), new Separator(), getShowHideCommands(table)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        exportCmd = _ref2[0],
        separator = _ref2[1],
        showHideCommands = _ref2[2];
      return new CommandGroup({
        commands: [exportCmd, separator].concat(showHideCommands)
      });
    });
  };

  /**
   * @param {JQuery} jq
   * @param {string} selector
   */
  DefaultTableContextMenu.prototype.arm = function (jq, selector) {
    var that = this;
    jq.on('click', selector, function (e) {
      return that.$doContextMenu(e);
    });
    that.$armContextMenuAsync(jq, selector);
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {module:bajaux/commands/Command}
   */
  function getExportCommand(table) {
    return new ExportCommand(table);
  }
  var ShowHideColumnCommand = function ShowHideColumnCommand(column, displayName) {
    Command.call(this, {
      displayName: displayName,
      icon: getIcon(column),
      func: function func() {
        column.setUnseen(!column.isUnseen());
        this.setIcon(getIcon(column));
      }
    });
  };
  ShowHideColumnCommand.prototype = Object.create(Command.prototype);
  ShowHideColumnCommand.prototype.constructor = ShowHideColumnCommand;
  ShowHideColumnCommand.prototype.hideAfterInvoke = function () {
    return false;
  };
  ShowHideColumnCommand.prototype.safeToHideIcon = function () {
    return false;
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Column} column
   * @returns {string}
   */
  function getIcon(column) {
    return column.isUnseen() ? BLANK_ICON : CHECK_ICON;
  }

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {Promise<module:bajaux/commands/Command>}
   */
  function getShowHideCommands(table) {
    var model = table.getModel(),
      columns = _.filter(model.getColumns(), function (col) {
        return col.isHidable();
      });
    return Promise.all(columns.map(function (column) {
      return Promise.resolve(column.toDisplayName()).then(function (displayName) {
        return new ShowHideColumnCommand(column, displayName);
      });
    }));
  }
  return DefaultTableContextMenu;
});
