function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/*eslint-env browser */ /*jshint browser: true */
/*global niagara: false */

/**
 * API Status: **Private**
 *
 * The core JavaScript for a Shell Profile.
 *
 * @module nmodule/webEditors/rc/wb/profile/profile
 */
define(["lex!webEditors", "baja!", "log!nmodule.webEditors.rc.wb.profile.profile", "jquery", "Promise", "dialogs", "profileInfo", "underscore", "bajaux/Widget", "bajaux/events", "bajaux/commands/CommandGroup", "bajaux/util/SaveCommand", "nmodule/js/rc/asyncUtils/asyncUtils", "nmodule/webEditors/rc/fe/feDialogs", "nmodule/webEditors/rc/servlets/navMonitor", "nmodule/webEditors/rc/transform/ExportCommand", "nmodule/webEditors/rc/util/textUtils", "nmodule/webEditors/rc/wb/shell/TitlePane", "nmodule/webEditors/rc/wb/commands/LogoutCommand", "nmodule/webEditors/rc/wb/commands/SelectViewCommand", "nmodule/webEditors/rc/wb/commands/HomeCommand", "nmodule/webEditors/rc/wb/profile/profileSideBars", "nmodule/webEditors/rc/wb/profile/ProfileCommandButtonGroup", "nmodule/webEditors/rc/wb/profile/profileUtils", "bajauxContainer", "hbs!nmodule/webEditors/rc/wb/profile/agentListTemplate"], function (lexs, baja, log, $, Promise, dialogs, profileInfo, _, Widget, events, CommandGroup, SaveCommand, asyncUtils, feDialogs, navMonitor, ExportCommand, textUtils, TitlePane, LogoutCommand, SelectViewCommand, HomeCommand, profileSideBars, ProfileCommandButtonGroup, profileUtils, container, agentListTemplate) {
  "use strict";

  var LOAD_EVENT = events.LOAD_EVENT,
    LOAD_FAIL_EVENT = events.LOAD_FAIL_EVENT,
    INITIALIZE_FAIL_EVENT = events.INITIALIZE_FAIL_EVENT,
    COMMAND_CHANGE_EVENT = events.command.CHANGE_EVENT,
    webEditorsLex = lexs[0],
    contentTitlePane = new TitlePane(),
    doRequire = asyncUtils.doRequire,
    logError = log.severe.bind(log),
    subjectToDisplay = textUtils.subjectToDisplay,
    isFunction = _.isFunction,
    console = window.console,
    supportsDynamicLoading = isFunction(history.pushState) && profileInfo.isDynamicLoading(),
    supportsConsoleTime = isFunction(console.time) && isFunction(console.timeEnd),
    supportsBrowserProfiling = supportsConsoleTime && niagara.env.profileBrowser;
  contentTitlePane.buildCommandGroup = function (widget) {
    return Promise.all([TitlePane.prototype.buildCommandGroup.apply(this, arguments), profileUtils.resolveProfileCommands(widget, profileInfo.getViewInfo())]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        commands = _ref2[0],
        profileCommands = _ref2[1];
      commands.add.apply(commands, _toConsumableArray(profileCommands));
      return commands;
    });
  };

  /**
   * //TODO: fully address overscroll
   * On an iPad, you can get ugly gray overscroll when dragging the nav tree /
   * main content. This fixes most of it.
   */
  (function fixOverscroll() {
    function isTouchSupported() {
      return 'ontouchstart' in window || navigator.maxTouchPoints;
    }
    if (!isTouchSupported()) {
      return;
    }
    var scrollables = '.TitlePane > .content, .ux-fullscreen > .ux-body';
    $('body').on('touchmove', scrollables, function (e) {
      var $this = $(this);
      if ($this.get(0).scrollHeight > $this.innerHeight()) {
        e.stopPropagation();
      }
    });
    $(document).on('touchmove', '.split-pane-divider', function (e) {
      e.preventDefault();
    });
  })();

  ////////////////////////////////////////////////////////////////
  // Widget
  ////////////////////////////////////////////////////////////////

  /**
   * @inner
   * @returns {Promise} promise to be resolved with "yes" if the user
   * wants to save, "no" if the user wants to abandon unsaved chances, "cancel"
   * if the user decided not to navigate away
   */
  function promptToSaveChanges() {
    if (container.isModified()) {
      return dialogs.showYesNoCancel(webEditorsLex.getSafe("saveChanges")).promise().then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          dlg = _ref4[0],
          id = _ref4[1];
        return id;
      });
    } else {
      return Promise.resolve("no");
    }
  }
  /**
   * Loads a bajaux Widget.
   *
   * @param  {String} uri
   * @param  {Array.<String>} [deps] any dependencies to preload before requiring
   * the actual Widget
   * @param  {String} rjs The RequireJS Id of the Widget.
   * @param  {String} moduleName The module name for the Widget.
   * @param  {String} typeName  The type name for the Widget.
   * @param  {Boolean} pushHistoryState Flag indicating whether to push the
   * history state or not.
   * @returns {Promise}
   */
  function loadWidget(uri, deps, rjs, moduleName, typeName, pushHistoryState) {
    var timeId;
    if (supportsBrowserProfiling) {
      timeId = "Load Widget: " + uri;
      console.time(timeId);
    }
    contentTitlePane.$getContentElement().css("visibility", "hidden");
    var viewInfo = profileInfo.getViewInfo();
    var selectedItem;
    viewInfo.list.forEach(function (item) {
      var def = item.uri === uri;
      item.def = def;
      if (def) {
        selectedItem = item;
      }
    });
    return promptToSaveChanges().then(function saveChanges(clicked) {
      return clicked === "yes" ? container.save() : clicked;
    }).then(function initAndLoad(clicked) {
      if (clicked === 'cancel') {
        // If the user clicked cancel, don't load the new view
        return;
      }
      contentTitlePane.$getDisplayNameElement().text(webEditorsLex.get("loading"));
      if (supportsDynamicLoading && pushHistoryState) {
        history.pushState(viewInfo, "", uri);
      }
      profileInfo.setViewInfo(viewInfo);

      // Dynamically load the JavaScript for the Widget
      // and then initialize and load it into the container.
      return Promise.all([doRequire(rjs, deps),
      // destroy command buttons now. otherwise, commands from view A sit
      // around idle even after view A is destroyed and before view B is loaded.
      contentTitlePane.$destroyCommandButtons()]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 1),
          Widget = _ref6[0];
        var newWidget = new Widget(moduleName, typeName);
        return container.initialize(newWidget, "bajaux").then(function loadContainer() {
          return container.load(newWidget, selectedItem.ord);
        });
      });
    }).then(function () {
      initializeAgentList();
    })["finally"](function () {
      contentTitlePane.$getContentElement().css("visibility", "inherit");
      $(window).resize();
      if (supportsBrowserProfiling) {
        console.timeEnd(timeId);
      }
    });
  }

  /**
   * Arm event handlers for the button that appears in mobile mode and provides
   * access to the current content widget's Commands.
   */
  function armMobileToggleCommands() {
    var toggleCommandsJq = $("#WebShell-toggle-commands");

    // When a command is clicked, show the commands in a dialog for the user to invoke.
    toggleCommandsJq.on('click', function () {
      var ed = contentTitlePane.getContentWidget();
      profileUtils.resolveProfileCommands(ed).then(function (profileCommands) {
        var group = new CommandGroup();
        toggleCommandsJq.addClass("selected");
        ed.getCommandGroup().flatten().filter(function (cmd) {
          return cmd.isEnabled();
        }).forEach(function (cmd) {
          group.add(cmd);
        });
        group.add.apply(group, _toConsumableArray(profileCommands));
        group.add(new HomeCommand());
        if (profileInfo.getConfigOptions().viewSelection) {
          group.add(new SelectViewCommand(function (item) {
            loadView(item, true)["catch"](logError);
          }));
        }
        group.add(new LogoutCommand());
        feDialogs.selfClosing({
          type: ProfileCommandButtonGroup,
          value: group
        })["finally"](function () {
          toggleCommandsJq.removeClass("selected");
        });
      })["catch"](baja.error);
    });
  }

  /**
   * Arm the Content Title Pane for a bajaux Widget
   * environment. The Title Pane will update with the name
   * of the Widget once it's been loaded.
   *
   * @returns {Promise} A promise that's resolved once the Widget has
   * been loaded into the TitlePane.
   */
  function armContentTitlePaneForWidget() {
    var contentElement = contentTitlePane.$getContentElement(),
      toggleTitleJq = $("#WebShell-toggle-title"),
      existingWidget = Widget["in"]($('#bajaux').children('.bajaux-widget-container').children('.bajaux-widget'));
    function setMainWidget(ed) {
      return contentTitlePane.setContentWidget(ed).then(function () {
        return subjectToDisplay(ed);
      }).then(function (displayName) {
        //TODO: should individual editors override toDisplayName to return component display name?
        contentTitlePane.$getDisplayNameElement().text(displayName);
        toggleTitleJq.text(displayName);
        document.title = displayName;
      })["finally"](function () {
        contentElement.css("visibility", "inherit");
        //$(window).resize(); //see NCCB-16117
      });
    }

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      contentElement.on([LOAD_EVENT, LOAD_FAIL_EVENT, INITIALIZE_FAIL_EVENT].join(' '), '#bajaux', function (e, ed) {
        var target = $(e.target);
        if (target.hasClass('bajaux-widget') && target.parent().parent().attr('id') === 'bajaux') {
          resolve(setMainWidget(ed));
        }
      });
      if (container.isError()) {
        // If an error message is already showing then just show the content.
        resolve(setMainWidget(existingWidget || new Widget()));
      } else if (existingWidget && existingWidget.isInitialized() && existingWidget.value() !== null && !existingWidget.isLoading()) {
        // If the Widget is already initialized and not loading the just show the content.
        resolve(setMainWidget(existingWidget));
      }
    });
  }

  ////////////////////////////////////////////////////////////////
  // Agent List
  ////////////////////////////////////////////////////////////////

  /**
   * Navigate to a new view.
   * @param {BajaViewInfo} item info for the view we are navigating to
   * @param  {Boolean} pushHistoryState Flag indicating whether to push the
   * history state or not.
   * @returns {Promise}
   */
  function loadView(item, pushHistoryState) {
    var deps = item.builtRjs,
      rjs = item.rjs,
      moduleName = item.moduleName,
      typeName = item.typeName,
      uri = item.uri,
      wd = item.wd;
    if (!rjs) {
      if (item.ux) {
        //prevent BJsBuildVerificationTests from falsely picking up a bajaui dependency
        //nmodule/bajaui/rc/ux/PxWidget
        //nmodule/bajaui/rc/bajaui.built.min
        var bajaui = 'nmodule'.toLowerCase() + '/bajaui';
        rjs = bajaui + '/rc/ux/PxWidget';
        deps = wd ? [] : [bajaui + '/rc/bajaui.built.min'];
      } else if (item.hx || item.wb || item.px) {
        rjs = 'nmodule/webEditors/rc/wb/profile/ServletViewWidget';
        deps = wd ? [] : ['nmodule/webEditors/rc/webEditors.built.min'];
      }
    }
    if (!container.isError() && supportsDynamicLoading && rjs) {
      return loadWidget(uri, deps, rjs, moduleName, typeName, pushHistoryState);
    } else {
      return Promise.resolve(location.assign(uri));
    }
  }

  /**
   * Initializes the DOM for the Agent List dropdown. This will tear down
   * any existing list and rebuild it.
   */
  function initializeAgentList() {
    var viewInfo = profileInfo.getViewInfo(),
      html = agentListTemplate(viewInfo),
      jq = contentTitlePane.$getControlsElement();
    jq.empty().off().toggle(viewInfo.list.length > 1).html(html).on('change', function () {
      var index = $("option:selected", $(this)).index(),
        item = viewInfo.list[index];
      loadView(item, true)["catch"](logError);
    });
  }

  /**
   * Load the default view from the current view info. If no view is specified
   * as default, will load the first view in the list.
   *
   * @param {module:profileInfo~ViewInfo} viewInfo view info for the ORD we're
   * navigating to
   * @param  {Boolean} pushHistoryState Flag indicating whether to push the
   * history state or not.
   * @returns {Promise}
   */
  function navigateToView(viewInfo, pushHistoryState) {
    var list = viewInfo.list,
      def = _.findWhere(list, {
        def: true
      }) || _.first(list);
    profileInfo.setViewInfo(viewInfo);
    initializeAgentList();
    return loadView(def, pushHistoryState);
  }

  /**
   * Hyperlink to the specified URI. This method will
   * detect whether the URI is a bajaux Widget. If so
   * it will attempt to load the content dynamically.
   *
   * @param  {String} uri The URI to hyperlink to.
   */
  function doHyperlink(uri) {
    // A dynamic hyperlink can only happen if...
    // - The current environment is a bajaux environment.
    // - Dynamic loading is enabled.
    // - The ORD doesn't have any view parameters (can be improved
    // at a later date).

    if (!container.isError() && supportsDynamicLoading && !/view:[^?]+\?.+$/.test(uri)) {
      var timeId;
      if (supportsBrowserProfiling) {
        timeId = "Hyperlink: " + uri;
        console.time(timeId);
      }
      Promise.resolve($.ajax("/view/all" + uri, {
        type: "GET",
        contentType: "application/json",
        dataType: "json"
      })).then(function (viewInfo) {
        if (supportsBrowserProfiling) {
          console.timeEnd(timeId);
        }
        navigateToView(viewInfo, true)["catch"](logError);
      })["catch"](function () {
        location.assign(uri);
      });
    } else {
      location.assign(uri);
    }
  }

  ////////////////////////////////////////////////////////////////
  // Content
  ////////////////////////////////////////////////////////////////

  /**
   * Initialize the Content.
   *
   * @returns {Promise} A promise that's resolved once the
   * content has been loaded into the Title Pane.
   */
  function initializeContent() {
    return contentTitlePane.initialize($("#WebShell-content")).then(function () {
      contentTitlePane.$getContentElement().on(COMMAND_CHANGE_EVENT, function (e, cmd) {
        if (cmd instanceof SaveCommand) {
          $('#WebShell-toggle-commands').toggleClass('unsaved-changes', cmd.isEnabled());
        }
      });
      initializeAgentList();
      armMobileToggleCommands();
      return armContentTitlePaneForWidget(contentTitlePane);
    })["finally"](function () {
      $("#WebShell-logoff").show();
    });
  }

  ////////////////////////////////////////////////////////////////
  // Hx
  ////////////////////////////////////////////////////////////////

  if (require.specified("hx")) {
    require(["hx"], function (hx) {
      var contentElem;

      /**
       * Get the element that contains Hx content.
       *
       * @inner
       * @returns {JQuery}
       */
      function getContentElement() {
        return contentElem || (contentElem = $('#WebShell-content').children('.content'));
      }

      /**
       * Old method kept climbing up the element tree to document.body so it
       * essentially gave you getBoundingClientRect(). Now stops when it reaches
       * the main content element.
       *
       * @inner
       *
       * @param elem
       * @returns {Array.<Number>}
       */
      hx.getElementBounds = function (elem) {
        var left = 0,
          top = 0,
          contentElem = getContentElement()[0];
        while (elem && elem !== contentElem) {
          left += elem.offsetLeft;
          top += elem.offsetTop;
          elem = elem.offsetParent;
        }
        return [left, top];
      };

      /**
       * Gives width of containing element (main content div) rather than
       * document.body.
       *
       * @returns {Number}
       */
      hx.getScreenWidth = function () {
        return getContentElement().width();
      };

      /**
       * Gives height of containing element (main content div) rather than
       * document.body.
       *
       * @returns {Number}
       */
      hx.getScreenHeight = function () {
        return getContentElement().height();
      };
    });
  }

  ////////////////////////////////////////////////////////////////
  // Initialize
  ////////////////////////////////////////////////////////////////

  (function initialize() {
    dialogs.showLoading(0, initializeContent()["catch"](logError));
    profileSideBars(doHyperlink);
    if (supportsDynamicLoading) {
      // NCCB-31800: hold a copy of the view info from first load
      var originalViewInfo = profileInfo.getViewInfo();

      //set a timeout since chrome triggers a popstate we don't want on first page load
      setTimeout(function () {
        $(window).on("popstate", function (ev) {
          // Navigate back to the previous view. If going back to the first
          // history entry, here will be nothing on the stack, so use the view
          // info from first pageload.
          navigateToView(ev.originalEvent.state || originalViewInfo, false)["catch"](logError);
        });
      }, 250);
    }
    niagara.env.hyperlink = function (ordStr, assign) {
      return niagara.env.toHyperlink(ordStr, {
        $skipStationSideNormalization: true
      }).then(function (uri) {
        if (typeof assign === "function") {
          assign(uri);
        } else {
          doHyperlink(uri);
        }
      })["catch"](function (err) {
        logError(err);
        location.assign(baja.Ord.make(ordStr).toUri());
      });
    };
    var webShell = $('#WebShell');
    webShell.on('click', '#WebShell-logoff button', function () {
      new LogoutCommand().invoke();
    });
    navMonitor.armElement(webShell);
  })();
});
