function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
 */
define(['baja!', 'jquery', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.profile.media.MediaSettingsWidget', 'bajaux/commands/Command', 'bajaux/events', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/wb/profile/media/MediaSettings', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, $, lexs, log, Command, events, switchboard, MediaSettings, OrderedMapEditor, feDialogs, CompositeEditor, CompositeBuilder, profileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logSevere = log.severe.bind(log);
  var HX_MEDIA_TYPE = 'hx:HxPxMedia';
  var UX_MEDIA_TYPE = 'uxBuilder:UxMedia';
  var MEDIA_TYPE = webEditorsLex.getSafe('changeMediaType'),
    PREVIEW_UX = webEditorsLex.getSafe('previewUx'),
    PREVIEW_HX = webEditorsLex.getSafe('previewHx'),
    PRESERVE_IDENTITIES = webEditorsLex.getSafe('preserveIdentities'),
    AUDITION_MODE = webEditorsLex.getSafe('auditionMode'),
    AUDITION_INDEX = webEditorsLex.getSafe('auditionIndex'),
    SHOW_VALIDATION_WARNINGS = webEditorsLex.getSafe('showValidationWarnings'),
    VALIDATION_WARNINGS = webEditorsLex.getSafe('validationWarnings');
  var KEYS_TO_TYPE = {
    'mediaType': 'baja:String',
    'previewUx': 'baja:Boolean',
    'previewHx': 'baja:Boolean',
    'preserveIdentities': 'baja:Boolean',
    'auditionMode': 'baja:Boolean',
    'auditionIndex': 'baja:Integer',
    'showValidationWarnings': 'baja:Boolean',
    'validationWarnings': 'baja:String'
  };
  var MEDIA_TYPES;
  var getKeys = function getKeys() {
    return Object.keys(KEYS_TO_TYPE);
  };
  var tpl = function tpl() {
    return "\n    <table class=\"ux-table\">\n      <tr class=\"ux-table-row\"><td>".concat(MEDIA_TYPE, "</td><td class=\"mediaType\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PREVIEW_UX, "</td><td class=\"previewUx\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PREVIEW_HX, "</td><td class=\"previewHx\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(PRESERVE_IDENTITIES, "</td><td class=\"preserveIdentities\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(AUDITION_MODE, "</td><td class=\"auditionMode\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(AUDITION_INDEX, "</td><td class=\"auditionIndex\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(SHOW_VALIDATION_WARNINGS, "</td><td class=\"showValidationWarnings\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(VALIDATION_WARNINGS, "</td><td class=\"validationWarnings\"></td></tr>\n    </table>");
  };

  /**
   * Allows configuration of Media settings.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var MediaSettingsWidget = /*#__PURE__*/function (_CompositeEditor) {
    function MediaSettingsWidget(params) {
      var _this;
      _classCallCheck(this, MediaSettingsWidget);
      _this = _callSuper(this, MediaSettingsWidget, [params]);
      switchboard(_this, {
        $handleModify: {
          allow: 'oneAtATime',
          onRepeat: 'returnLast'
        }
      });
      return _this;
    }
    _inherits(MediaSettingsWidget, _CompositeEditor);
    return _createClass(MediaSettingsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        return Promise.resolve(MEDIA_TYPES || MediaSettings.makeMediaMap()).then(function (map) {
          if (!MEDIA_TYPES) {
            MEDIA_TYPES = map;
          }
          dom.addClass('MediaSettingsWidget').html(tpl());
          dom.on(MODIFY_EVENT, '*', function (event) {
            _this2.$handleModify(event);
          });
        });
      }

      /**
       * Update the Widget when the settings have been retrieved.
       * @param {jQuery.Event} event
       */
    }, {
      key: "$handleModify",
      value: function $handleModify(event) {
        var _this3 = this;
        var settings;
        this.read().then(function (readSettings) {
          settings = readSettings;
          settings.saveToStorage();
          return _this3.$updateRows(settings);
        }).then(function () {
          var target = $(event.target);
          var builder = _this3.getBuilder();
          if (target.hasClass('auditionMode')) {
            return settings.resolveMediaInfo({
              auditionModeRemove: !settings.auditionMode
            }).then(function (results) {
              return builder.getEditorFor("auditionIndex").load(results.auditionIndex || 0);
            });
          } else if (target.hasClass('mediaType') || target.hasClass('showValidationWarnings') || target.hasClass('previewUx') || target.hasClass('previewHx')) {
            if (settings.showValidationWarnings) {
              var _settings = settings,
                mediaType = _settings.mediaType;
              if (settings.previewUx) {
                mediaType = UX_MEDIA_TYPE;
              } else if (settings.previewHx) {
                mediaType = HX_MEDIA_TYPE;
              }
              return settings.resolveMediaInfo({
                mediaType: mediaType
              }).then(function () {
                var builder = _this3.getBuilder();
                return builder.getEditorFor("validationWarnings").load(settings.validationWarnings);
              });
            }
          }
        })["catch"](logSevere);
      }

      /**
       * Update row visibility and readonly states.
       * @private
       * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} settings
       * @return {Promise}
       */
    }, {
      key: "$updateRows",
      value: function $updateRows(settings) {
        var builder = this.getBuilder(),
          modifiedMedia = settings.mediaType !== this.$defaultSettings.mediaType,
          readonlyPreview = modifiedMedia,
          auditionMode = settings.auditionMode,
          isPxFile = settings.isPxFile,
          previewUx = settings.previewUx,
          previewHx = settings.previewHx,
          showValidationWarnings = settings.showValidationWarnings;
        var uxViewParam = profileUtils.getViewParameter('ux');
        var previewHxVisible = uxViewParam === 'false';
        builder.getDomFor("previewHx").parent().toggle(previewHxVisible);
        builder.getDomFor("validationWarnings").parent().toggle(showValidationWarnings);
        builder.getDomFor("auditionIndex").parent().toggle(auditionMode);
        builder.getDomFor("preserveIdentities").parent().toggle(!!isPxFile && modifiedMedia);
        return Promise.all([builder.getEditorFor("previewUx").setReadonly(readonlyPreview || previewHx), builder.getEditorFor("previewHx").setReadonly(readonlyPreview || previewUx), readonlyPreview && builder.getEditorFor("previewUx").load(false), readonlyPreview && builder.getEditorFor("previewHx").load(false), builder.getEditorFor("mediaType").setReadonly(previewUx || previewHx)]);
      }

      /**
       * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} a builder
       * to show selectors for each media setting property.
       */
    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this4 = this;
        var that = this;
        var builder = new CompositeBuilder();
        builder.getKeys = getKeys;
        builder.getDomFor = function (key) {
          return that.jq().find('.' + key);
        };
        builder.getValueFor = function (key) {
          if (key === "mediaType") {
            return MEDIA_TYPES;
          } else {
            return baja.$(KEYS_TO_TYPE[key], _this4.$defaultSettings[key]);
          }
        };
        builder.getConfigFor = function (key) {
          if (key === "mediaType") {
            return {
              type: OrderedMapEditor,
              properties: {
                lexicon: 'webEditors',
                lexiconIcons: true
              },
              //loadParams: { selectedValue: this.$defaultSettings[key] }, //getConfigFor does not seem to support this
              formFactor: 'mini'
            };
          } else if (key === "auditionIndex" && that.$auditionSize) {
            return {
              properties: {
                min: 0,
                max: that.$auditionSize - 1
              },
              formFactor: 'mini'
            };
          } else if (key === "validationWarnings") {
            return {
              properties: {
                multiLine: true,
                fieldWidth: 60
              },
              readonly: true,
              formFactor: 'mini'
            };
          }
          return {
            formFactor: 'mini'
          };
        };
        builder.$loadFor = function (key) {
          var params = {};
          if (key === "mediaType") {
            params = {
              selectedValue: _this4.$defaultSettings[key]
            };
          }
          return CompositeBuilder.prototype.$loadFor.apply(builder, [key, params]);
        };
        return builder;
      }

      /**
       * Load in the current configured settings (either saved by the user or the defaults).
       *
       * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(mediaSettings) {
        var _arguments = arguments,
          _this5 = this;
        var mediaType;
        var uxViewParam = profileUtils.getViewParameter('ux'),
          isUxPreview = uxViewParam === 'true',
          isHxPreview = uxViewParam === 'false';
        if (isUxPreview) {
          mediaType = UX_MEDIA_TYPE;
        } else if (isHxPreview) {
          mediaType = HX_MEDIA_TYPE;
        }
        this.$ord = mediaSettings.ord;
        return mediaSettings.resolveMediaInfo({
          mediaType: mediaType
        }).then(function (readSettings) {
          _this5.$defaultSettings = readSettings;
          _this5.$auditionSize = readSettings.auditionSize;
          _this5.$isPxFile = mediaSettings.isPxFile;
          readSettings.previewUx = isUxPreview;
          readSettings.previewHx = isHxPreview;
          return _superPropGet(MediaSettingsWidget, "doLoad", _this5, 3)(_arguments).then(function () {
            return _this5.$updateRows(readSettings);
          });
        });
      }

      /**
       * Read user-entered settings.
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/profile/media/MediaSettings>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this6 = this;
        var keys = getKeys();
        var builder = this.getBuilder();
        return Promise.all(keys.map(function (key) {
          return builder.getEditorFor(key).read();
        })).then(function (enums) {
          var settings = {
            ord: _this6.$ord,
            auditionSize: _this6.$auditionSize,
            isPxFile: _this6.$isPxFile
          };
          keys.forEach(function (key, i) {
            settings[key] = enums[i].valueOf();
          });
          return new MediaSettings(settings);
        });
      }
    }, {
      key: "doSave",
      value: function doSave(value) {
        //don't modify the file unless the mediaType has been modified
        if (this.$defaultSettings.mediaType === value.mediaType) {
          value.mediaType = "";
        }
        return value.saveMediaInfo(value);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('MediaSettingsWidget');
        return _superPropGet(MediaSettingsWidget, "doDestroy", this, 3)([]);
      }

      /**
       * @param {baja.Ord} ord
       * @returns {Array.<module:bajaux/commands/Command>}
       */
    }], [{
      key: "makeCommands",
      value: function makeCommands(ord) {
        var mediaSettings = MediaSettings.make(ord);
        if (mediaSettings.auditionMode) {
          return [new PreviousMediaCommand(mediaSettings), new NextMediaCommand(mediaSettings), new MediaCommand(mediaSettings)];
        } else {
          return [new MediaCommand(mediaSettings)];
        }
      }
    }]);
  }(CompositeEditor);
  /**
   * Launch the Media Settings Dialog.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */
  var MediaCommand = /*#__PURE__*/function (_Command) {
    function MediaCommand(mediaSettings) {
      _classCallCheck(this, MediaCommand);
      return _callSuper(this, MediaCommand, [{
        module: 'webEditors',
        lex: 'commands.mediaCommand',
        func: function func() {
          return feDialogs.showFor({
            title: webEditorsLex.getSafe('commands.mediaCommand.displayName'),
            value: mediaSettings,
            type: MediaSettingsWidget
          });
        }
      }]);
    }
    _inherits(MediaCommand, _Command);
    return _createClass(MediaCommand);
  }(Command);
  /**
   * Navigate to the previous auditionIndex.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */
  var PreviousMediaCommand = /*#__PURE__*/function (_Command2) {
    function PreviousMediaCommand(mediaSettings) {
      _classCallCheck(this, PreviousMediaCommand);
      return _callSuper(this, PreviousMediaCommand, [{
        module: 'webEditors',
        lex: 'commands.previousMediaCommand',
        func: function func() {
          return mediaSettings.auditionNavigation(false);
        }
      }]);
    }
    _inherits(PreviousMediaCommand, _Command2);
    return _createClass(PreviousMediaCommand);
  }(Command);
  /**
   * Navigate to the next auditionIndex.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget
   * @param {module:nmodule/webEditors/rc/wb/profile/media/MediaSettings} mediaSettings
   */
  var NextMediaCommand = /*#__PURE__*/function (_Command3) {
    function NextMediaCommand(mediaSettings) {
      _classCallCheck(this, NextMediaCommand);
      return _callSuper(this, NextMediaCommand, [{
        module: 'webEditors',
        lex: 'commands.nextMediaCommand',
        func: function func() {
          return mediaSettings.auditionNavigation(true);
        }
      }]);
    }
    _inherits(NextMediaCommand, _Command3);
    return _createClass(NextMediaCommand);
  }(Command);
  return MediaSettingsWidget;
});
