/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/ProfileCommandButtonGroup
 */
define(['bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/BaseWidget'], function (CommandButtonGroup, BaseWidget) {
  'use strict';

  /**
   * A command button group for the profile. This command button group
   * is used when the commands for a displayed view are popped up in a
   * dialog box.
   *
   * @class
   * @extends module:bajaux/util/CommandButtonGroup
   * @alias module:nmodule/webEditors/rc/wb/ProfileCommandButtonGroup
   */
  var ProfileCommandButtonGroup = function ProfileCommandButtonGroup() {
    CommandButtonGroup.apply(this, arguments);
  };
  ProfileCommandButtonGroup.prototype = Object.create(CommandButtonGroup.prototype);
  ProfileCommandButtonGroup.prototype.constructor = ProfileCommandButtonGroup;

  /**
   * @param {JQuery} dom
   */
  ProfileCommandButtonGroup.prototype.doInitialize = function (dom) {
    // When any of the buttons on the dialog are clicked, fire
    // a value ready event. This event will automatically close
    // a dialog opened with `feDialogs.selfClosing`.
    dom.on('click', 'button', function () {
      dom.trigger(BaseWidget.VALUE_READY_EVENT);
    });
    return CommandButtonGroup.prototype.doInitialize.apply(this, arguments);
  };
  return ProfileCommandButtonGroup;
});
