/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/ContextMenuSupport
 */
define(['jquery', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/wb/menu/baseMenuAgentSet', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function ($, Promise, asyncUtils, baseMenuAgentSet, menuUtils, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin,
    forSubject = menuUtils.forSubject,
    doRequire = asyncUtils.doRequire,
    DEFAULT_MENU_ID = 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu',
    MIXIN_NAME = 'contextMenuSupport';
  function getSubject(w, e) {
    if (typeof w.getSubject === 'function') {
      return w.getSubject($(e.target));
    }
    return [w.value()];
  }
  var exports = {
    $toContextMenu: function $toContextMenu(e) {
      var _this = this;
      return Promise.resolve(getSubject(this, e)).then(function (subject) {
        if (!subject) {
          return;
        }
        return forSubject(_this, subject).then(function (group) {
          if (!group) {
            throw new Error('no commands apply to entire subject');
          }
          if (typeof _this.updateMenuCommandGroup === 'function') {
            return _this.updateMenuCommandGroup(group, subject);
          }
          return group;
        });
      });
    }
  };

  /**
   * This mixin adds support for context menus to a bajaux Widget.
   *
   * The target widget may optionally implement any of these functions:
   *
   * - `getContextMenuSelector()`: return a CSS selector for elements from which
   *   to listen for right click events. Defaults to `.contextMenu`.
   * - `getSubject(jq)` - this function will receive the jQuery element that is
   *   being right-clicked/contextmenu-ed. It should return an array consisting
   *   of the baja Values that would be represented by this widget, given a
   *   right click on that element. For instance, a right click on a `tr` in a
   *   Table would probably represent the Value stored at that row - or if
   *   multiple rows were ctrl-clicked, multiple values could be returned. If
   *   not implemented, the value `load()`ed into the Widget is always
   *   considered to be the subject.
   *
   * @alias module:nmodule/webEditors/rc/wb/mixin/ContextMenuSupport
   * @param {module:bajaux/Widget} target
   * @param {object} params
   * @param {string} [params.menuModuleId=nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu] a
   * custom subclass of `CommandGroupContextMenu` can be used instead if
   * desired.
   */
  function addContextMenuSupport(target, params) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }
    var menuId = params && params.menuModuleId || DEFAULT_MENU_ID,
      menu,
      _doInitialize = target.doInitialize,
      _doDestroy = target.doDestroy;
    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        return doRequire(menuId);
      }).then(function (Menu) {
        menu = new Menu(that);
        menu.arm();
        that.getContextMenu = function () {
          return menu;
        };
      });
    };
    target.doDestroy = function () {
      return Promise.all([_doDestroy.apply(this, arguments), typeof menu.destroy === 'function' && menu.destroy()]);
    };
  }
  return addContextMenuSupport;
});
