/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn
 */
define(['baja!', 'underscore', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, _, PropertyMgrColumn) {
  'use strict';

  function toMixinName(type) {
    return String(type).replace(':', '_');
  }

  //TODO: BMixIn.getDisplayNameInParent? for now just pass in displayName
  /**
   * API Status: **Development**
   *
   * Manager column for working with a `baja:IMixIn`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   * @param {Type} type the type of the `BIMixin` subclass this column is intended
   * to edit
   * @param {Object} params
   */
  var MixinMgrColumn = function MixinMgrColumn(type, params) {
    PropertyMgrColumn.call(this, toMixinName(type), _.extend({
      getDefaultValue: function getDefaultValue() {
        return baja.$(type);
      }
    }, params));
  };
  MixinMgrColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  MixinMgrColumn.prototype.constructor = MixinMgrColumn;

  /**
   * Load the default editor for the coalesced instance of the mixin.
   *
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @returns {Object} config object for `fe.makeFor`
   */
  MixinMgrColumn.prototype.getConfigFor = function (rows) {
    return {
      value: this.coalesceRows(rows)
    };
  };
  MixinMgrColumn.prototype.commit = function () {
    return PropertyMgrColumn.prototype.commit.apply(this, arguments);
  };
  return MixinMgrColumn;
});
