function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder
 */
define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/PropertySheetRow', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel'], function (baja, lexs, Promise, _, DisplayOnlyEditor, CompositeBuilder, fe, PropertySheetRow, MgrModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var ROW_NOT_EDITABLE = {};
  function getColumnName(column) {
    return column.getName();
  }

  /**
   * `CompositeBuilder` that watches selected rows in a `MgrModel`. It delegates
   * the construction of editors and the retrieval of values to the individual
   * `MgrColumn`s in the `MgrModel`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder
   * @extends module:nmodule/webEditors/rc/fe/config/CompositeBuilder
   * @param {Object} params
   * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} params.model
   * the `MgrModel` to be used as this builder's data source
   * @param {module:nmodule/webEditors/rc/util/ListSelection} params.selection
   * the `ListSelection` that tracks which rows in the `MgrModel` are selected.
   */
  var MgrModelCompositeBuilder = function MgrModelCompositeBuilder(params) {
    var model = params && params.model,
      selection = params && params.selection;
    if (!selection) {
      throw new Error('ListSelection required');
    }
    this.$selection = selection;
    CompositeBuilder.call(this, {
      dataSource: model
    });
  };
  MgrModelCompositeBuilder.prototype = Object.create(CompositeBuilder.prototype);
  MgrModelCompositeBuilder.prototype.constructor = MgrModelCompositeBuilder;

  /**
   * Get the column matching the given name in the `MgrModel` data source.
   *
   * @private
   * @param {String} columnName
   * @returns {module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn} the
   * `MgrColumn` with the given name, or `null` if not found
   */
  MgrModelCompositeBuilder.prototype.$getColumn = function (columnName) {
    return this.getDataSource().getColumn(columnName);
  };

  /**
   * Get all selected rows in the `MgrModel` data source as determined by the
   * builder's `ListSelection`.
   *
   * @private
   * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>}
   */
  MgrModelCompositeBuilder.prototype.$getSelectedRows = function () {
    var model = this.getDataSource(),
      selection = this.$selection;
    return selection.getSelectedElements(model.getRows());
  };

  /**
   * Set the `MgrModel` data source.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} model
   * @returns {Promise} promise to be resolved with the `MgrModel` has
   * been set as the data source
   */
  MgrModelCompositeBuilder.prototype.setDataSource = function (model) {
    if (model && !(model instanceof MgrModel)) {
      return Promise.reject(new Error('MgrModel required'));
    }
    return CompositeBuilder.prototype.setDataSource.apply(this, arguments);
  };

  /**
   * Delegates to the matching `MgrColumn`'s `getConfigFor` function, using
   * the currently selected `Row`s.
   *
   * @param {String} key the column name
   * @returns {Object} a config object to be given to `fe.makeFor`
   */
  MgrModelCompositeBuilder.prototype.getConfigFor = function (key) {
    var column = this.$getColumn(key);
    return column && column.getConfigFor(this.$getSelectedRows());
  };

  /**
   * Resolve the display name from the matching column.
   *
   * @param {String} key the column name
   * @returns {Promise} promise to be resolved with the display name,
   * or with `null` if column not found
   */
  MgrModelCompositeBuilder.prototype.getDisplayNameFor = function (key) {
    var column = this.$getColumn(key);
    return Promise.resolve(column && column.toDisplayName());
  };

  /**
   * Resolve the column icon of the matching column.
   *
   * @param {String} key the column name
   * @returns {Promise} promise to be resolved with an icon URI, or `null`
   * if column not found
   */
  MgrModelCompositeBuilder.prototype.getIconFor = function (key) {
    var column = this.$getColumn(key);
    return Promise.resolve(column && column.getColumnIcon());
  };

  /**
   * Get the names of all editable columns in the `MgrModel`.
   *
   * @returns {Promise} promise to be resolved with an array of string names
   */
  MgrModelCompositeBuilder.prototype.getKeys = function () {
    var model = this.getDataSource();
    return Promise.resolve(model.getEditableColumns().map(getColumnName));
  };

  /**
   * Get a value coalesced from the matching column, using the currently
   * selected rows.
   *
   * @param {String} key the column name
   * @returns {*} a value given to us by the column's `coalesceRows` function,
   * using the currently selected rows - or `null` if column not found
   */
  MgrModelCompositeBuilder.prototype.getValueFor = function (key) {
    var column = this.$getColumn(key);
    return column && column.coalesceRows(this.$getSelectedRows());
  };

  /**
   * If the editor for this key has been built, and is still considered by the
   * column for this key to be suitable for the selected rows, just reuse
   * that editor.
   *
   * Otherwise, rebuild a new editor for this key.
   *
   * @private
   * @param {String} key
   * @returns {Promise} promise to be resolved with an editor the referenced
   * column likes for the selected rows.
   */
  MgrModelCompositeBuilder.prototype.$makeFor = function (key) {
    var that = this,
      existing = that.getEditorFor(key),
      column = that.$getColumn(key);
    return Promise.all([Promise["try"](function () {
      return that.getConfigFor(key);
    })["catch"](function () {
      return ROW_NOT_EDITABLE;
    }), Promise["try"](function () {
      return that.getValueFor(key);
    })["catch"](function () {
      return ROW_NOT_EDITABLE;
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        config = _ref2[0],
        value = _ref2[1];
      var valueEd = getValueEditor(existing);

      // if a row wasn't editable the last time we built the editor, don't
      // reuse the "can't edit" editor even if the column doesn't know to say
      // no to it.
      if (valueEd && value !== ROW_NOT_EDITABLE && !(valueEd instanceof DisplayOnlyEditor) && column.isEditorSuitable(valueEd, that.$getSelectedRows())) {
        return existing;
      }

      // if a column can't provide an editable value for these rows, show a
      // display-only "can't edit" message.
      if (config === ROW_NOT_EDITABLE) {
        config = {
          type: DisplayOnlyEditor
        };
      }

      //TODO: remove readonly checks after password rpc works offline
      if (baja.isOffline() || column.isReadonly()) {
        config = _.extend({}, config, {
          readonly: true
        });
      }
      return Promise.resolve(existing && existing.isInitialized() && existing.destroy()).then(function () {
        return fe.makeFor(config);
      });
    }).then(function (ed) {
      return that.$map[key] = ed;
    });
  };

  //ed can be a PropertySheetRow, which custom columns shouldn't have to know
  //about. pass the value editor instead.
  //TODO: this is still probably not the best way to go about this
  function getValueEditor(ed) {
    if (!ed) {
      return;
    }
    if (ed instanceof PropertySheetRow && ed.isInitialized()) {
      return ed.$getSubPropertySheet() || ed.$getValueEditor();
    } else {
      return ed.isInitialized() && ed;
    }
  }

  /**
   * If a column doesn't have an editable value for us, we'll have a
   * DisplayOnlyEditor from $makeFor to load a "can't edit" message into.
   */
  MgrModelCompositeBuilder.prototype.$loadFor = function (key, params) {
    var _this = this;
    return this.$initializeFor(key).then(function (ed) {
      return Promise["try"](function () {
        return _this.getValueFor(key);
      })["catch"](function () {
        return webEditorsLex.get('mgr.cannotEdit');
      }).then(function (value) {
        return ed.load(value, params);
      });
    });
  };
  return MgrModelCompositeBuilder;
});
