/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
 */
define(['bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (Command, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin,
    MIXIN_NAME = 'MGR_COMMAND';

  /**
   * API Status: **Development**
   *
   * Optional mixin type used to extend a bajaux `Command` with extra functionality used by
   * a `Manager` view. Commands don't need to apply this mixin to be functional in a bajaux
   * `Manager`, this can just provide additional behavior to any `Command` that requires it.
   *
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
   *
   * @mixin
   * @param {module:bajaux/commands/Command} target the `Command` to have the
   * mixin functionality applied to it.
   */
  var exports = function exports(target) {
    if (!(target instanceof Command)) {
      throw new Error('MgrCommand mixin must be applied to a Command type');
    }
    if (!applyMixin(target, MIXIN_NAME)) {
      return;
    }

    /**
     * Returns a Boolean indicating whether this `Command` should be shown in the 'action bar'
     * at the bottom of the manager view. Defaults to `true`.
     *
     * @function module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand#isShownInActionBar
     * @returns {Boolean}
     */
    target.isShownInActionBar = function () {
      return this.$showInActionBar;
    };

    /**
     * Set whether this `Command` should be shown in the 'action bar' at the bottom of the
     * manager view. The default behavior is to show all commands in the manager's command
     * group at the bottom of the view. If called, it will typically be with a `false` argument
     * show the command in the tool bar, but not in the main view.
     *
     * @function module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand#setShowInActionBar
     * @param {Boolean} show true if this instance should be shown in the manager's action bar.
     */
    target.setShowInActionBar = function (show) {
      this.$showInActionBar = !!show;
    };
    target.$showInActionBar = true;
  };
  return exports;
});
