/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/EditCommand
 */
define(['baja!', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource'], function (baja, _, Command, feDialogs, BatchComponentEditor, MgrModel, ArrayComponentSource) {
  'use strict';

  function makeSubMgrModel(manager) {
    var mgrModel = manager.getModel(),
      selectedRows = manager.getMainTable().getSelectedRows(),
      comps = _.map(selectedRows, function (row) {
        return row.getSubject();
      });
    return new MgrModel({
      componentSource: new ArrayComponentSource(comps),
      columns: mgrModel.getEditableColumns()
    });
  }

  /**
   * Command for editing existing components in a Manager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/EditCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */
  var EditCommand = function EditCommand(manager) {
    var that = this;
    that.$allowOffline = false;
    Command.call(that, {
      module: 'webEditors',
      lex: 'commands.mgr.edit',
      enabled: false,
      /**
       * Takes the components that are currently selected in the manager's
       * main table, and allows for editing them using a `BatchComponentEditor`.
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/EditCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: makeSubMgrModel(manager),
            properties: {
              ordBase: ordBase
            },
            type: BatchComponentEditor
          });
        });
      }
    });
  };
  EditCommand.prototype = Object.create(Command.prototype);
  EditCommand.prototype.constructor = EditCommand;

  /**
   * Return true if the edit command is allowed in an offline
   * environment. The default is for offline editing to be
   * disallowed.
   *
   * @returns {boolean}
   */
  EditCommand.prototype.isAllowedOffline = function () {
    return this.$allowOffline;
  };

  /**
   * Set or unset the allowed offline property. If the `allow`
   * parameter is false, calls to enable the command via `setEnabled`
   * in an offline environment will not succeed.
   *
   * @param {boolean} allow
   */
  EditCommand.prototype.setAllowedOffline = function (allow) {
    this.$allowOffline = !!allow;
  };
  EditCommand.prototype.setEnabled = function (enabled) {
    //TODO: remove readonly checks after password rpc works offline
    if (!this.$allowOffline && baja.isOffline()) {
      enabled = false;
    }
    return Command.prototype.setEnabled.call(this, enabled);
  };
  return EditCommand;
});
